/*
 * Decompiled with CFR 0.152.
 */
package com.ihsanbal.logging;

import com.ihsanbal.logging.BufferListener;
import com.ihsanbal.logging.Level;
import com.ihsanbal.logging.Logger;
import com.ihsanbal.logging.Printer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0015B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\bH\u0002J \u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/ihsanbal/logging/LoggingInterceptor;", "Lokhttp3/Interceptor;", "builder", "Lcom/ihsanbal/logging/LoggingInterceptor$Builder;", "(Lcom/ihsanbal/logging/LoggingInterceptor$Builder;)V", "isDebug", "", "addQueryAndHeaders", "Lokhttp3/Request;", "request", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "printlnRequestLog", "", "printlnResponseLog", "receivedMs", "", "response", "proceedResponse", "Builder", "lib"})
public final class LoggingInterceptor
implements Interceptor {
    private final boolean isDebug;
    private final Builder builder;

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        Request request = this.addQueryAndHeaders(chain.request());
        if (!this.isDebug || this.builder.getLevel() == Level.NONE) {
            return chain.proceed(request);
        }
        this.printlnRequestLog(request);
        long startNs = System.nanoTime();
        Response response = null;
        try {
            response = this.proceedResponse(chain, request);
        }
        catch (Exception e) {
            Printer.Companion.printFailed(this.builder.getTag(false), this.builder);
            throw (Throwable)e;
        }
        long receivedMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        this.printlnResponseLog(receivedMs, response, request);
        return response;
    }

    private final void printlnResponseLog(long receivedMs, Response response, Request request) {
        Printer.Companion.printJsonResponse(this.builder, receivedMs, response.isSuccessful(), response.code(), response.headers(), response, request.url().encodedPathSegments(), response.message(), request.url().toString());
    }

    private final void printlnRequestLog(Request request) {
        RequestBody requestBody = request.body();
        String string = request.url().url().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"request.url.toUrl().toString()");
        Printer.Companion.printJsonRequest(this.builder, requestBody, string, request.headers(), request.method());
    }

    private final Response proceedResponse(Interceptor.Chain chain, Request request) {
        Response response;
        if (this.builder.isMockEnabled() && this.builder.getListener() != null) {
            TimeUnit.MILLISECONDS.sleep(this.builder.getSleepMs());
            Response.Builder builder = new Response.Builder();
            BufferListener bufferListener = this.builder.getListener();
            if (bufferListener == null) {
                Intrinsics.throwNpe();
            }
            String string = bufferListener.getJsonResponse(request);
            response = builder.body(string != null ? ResponseBody.Companion.create(string, MediaType.Companion.parse("application/json")) : null).request(chain.request()).protocol(Protocol.HTTP_2).message("Mock data from LoggingInterceptor").code(200).build();
        } else {
            response = chain.proceed(request);
        }
        return response;
    }

    private final Request addQueryAndHeaders(Request request) {
        HttpUrl.Builder httpUrlBuilder;
        Request.Builder requestBuilder = request.newBuilder();
        Set<String> set = this.builder.getHeaders().keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"builder.headers.keys");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            String key = (String)element$iv;
            boolean bl = false;
            if (this.builder.getHeaders().get(key) == null) continue;
            boolean bl2 = false;
            boolean bl3 = false;
            String it = string;
            boolean bl4 = false;
            String string2 = key;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"key");
            String string3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it");
            requestBuilder.addHeader(string2, string3);
        }
        HttpUrl.Builder builder = httpUrlBuilder = request.url().newBuilder(request.url().toString());
        if (builder != null) {
            HttpUrl.Builder builder2 = builder;
            boolean bl = false;
            boolean bl5 = false;
            HttpUrl.Builder it = builder2;
            boolean bl6 = false;
            Set<String> set2 = this.builder.getHttpUrl().keySet();
            Intrinsics.checkExpressionValueIsNotNull(set2, (String)"builder.httpUrl.keys");
            Iterable $this$forEach$iv2 = set2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                String key = (String)element$iv;
                boolean bl7 = false;
                String string = key;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
                httpUrlBuilder.addQueryParameter(string, this.builder.getHttpUrl().get(key));
            }
        }
        HttpUrl.Builder builder3 = httpUrlBuilder;
        Object object = builder3 != null ? builder3.build() : null;
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return requestBuilder.url(object).build();
    }

    private LoggingInterceptor(Builder builder) {
        this.builder = builder;
        this.isDebug = this.builder.isDebugAble();
    }

    public /* synthetic */ LoggingInterceptor(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 C2\u00020\u0001:\u0001CB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u0005J\u0016\u00100\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u0005J\u0006\u00101\u001a\u000202J\u0010\u00103\u001a\u00020\u00002\u0006\u00104\u001a\u00020\u000bH\u0007J \u00105\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u000b2\u0006\u00107\u001a\u00020$2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0012\u00108\u001a\u00020\u00002\b\u00108\u001a\u0004\u0018\u000109H\u0007J\u000e\u0010:\u001a\u00020\u00052\u0006\u0010;\u001a\u00020\u000bJ\u000e\u0010<\u001a\u00020\u00002\u0006\u0010*\u001a\u00020)J\u0010\u0010=\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u000bH\u0007J\u0010\u0010\u001e\u001a\u00020\u00002\b\u0010\u001e\u001a\u0004\u0018\u00010\u001dJ\u0010\u0010?\u001a\u00020\u00002\b\u0010@\u001a\u0004\u0018\u00010\u0005J\u0010\u0010A\u001a\u00020\u00002\b\u0010@\u001a\u0004\u0018\u00010\u0005J\u000e\u0010B\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0013J\u000e\u0010@\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u0005R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u001a\u0010\u0011\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\f\"\u0004\b\u0012\u0010\u000eR\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\"\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\b\u0010\u000f\u001a\u0004\u0018\u00010\u001d@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0010\u0010!\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001e\u0010*\u001a\u00020)2\u0006\u0010\u000f\u001a\u00020)@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u0006D"}, d2={"Lcom/ihsanbal/logging/LoggingInterceptor$Builder;", "", "()V", "headers", "Ljava/util/HashMap;", "", "getHeaders", "()Ljava/util/HashMap;", "httpUrl", "getHttpUrl", "isDebugAble", "", "()Z", "setDebugAble", "(Z)V", "<set-?>", "isLogHackEnable", "isMockEnabled", "setMockEnabled", "Lcom/ihsanbal/logging/Level;", "level", "getLevel", "()Lcom/ihsanbal/logging/Level;", "listener", "Lcom/ihsanbal/logging/BufferListener;", "getListener", "()Lcom/ihsanbal/logging/BufferListener;", "setListener", "(Lcom/ihsanbal/logging/BufferListener;)V", "Lcom/ihsanbal/logging/Logger;", "logger", "getLogger", "()Lcom/ihsanbal/logging/Logger;", "requestTag", "responseTag", "sleepMs", "", "getSleepMs", "()J", "setSleepMs", "(J)V", "", "type", "getType", "()I", "addHeader", "name", "value", "addQueryParam", "build", "Lcom/ihsanbal/logging/LoggingInterceptor;", "enableAndroidStudioV3LogsHack", "useHack", "enableMock", "useMock", "sleep", "executor", "Ljava/util/concurrent/Executor;", "getTag", "isRequest", "log", "loggable", "isDebug", "request", "tag", "response", "setLevel", "Companion", "lib"})
    public static final class Builder {
        @NotNull
        private final HashMap<String, String> headers = new HashMap();
        @NotNull
        private final HashMap<String, String> httpUrl = new HashMap();
        private boolean isLogHackEnable;
        private boolean isDebugAble;
        private int type = 4;
        private String requestTag;
        private String responseTag;
        @NotNull
        private Level level = Level.BASIC;
        @Nullable
        private Logger logger;
        private boolean isMockEnabled;
        private long sleepMs;
        @Nullable
        private BufferListener listener;
        private static String TAG;
        public static final Companion Companion;

        @NotNull
        public final HashMap<String, String> getHeaders() {
            return this.headers;
        }

        @NotNull
        public final HashMap<String, String> getHttpUrl() {
            return this.httpUrl;
        }

        public final boolean isLogHackEnable() {
            return this.isLogHackEnable;
        }

        public final boolean isDebugAble() {
            return this.isDebugAble;
        }

        public final void setDebugAble(boolean bl) {
            this.isDebugAble = bl;
        }

        public final int getType() {
            return this.type;
        }

        @NotNull
        public final Level getLevel() {
            return this.level;
        }

        @Nullable
        public final Logger getLogger() {
            return this.logger;
        }

        public final boolean isMockEnabled() {
            return this.isMockEnabled;
        }

        public final void setMockEnabled(boolean bl) {
            this.isMockEnabled = bl;
        }

        public final long getSleepMs() {
            return this.sleepMs;
        }

        public final void setSleepMs(long l) {
            this.sleepMs = l;
        }

        @Nullable
        public final BufferListener getListener() {
            return this.listener;
        }

        public final void setListener(@Nullable BufferListener bufferListener) {
            this.listener = bufferListener;
        }

        @NotNull
        public final Builder setLevel(@NotNull Level level) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)level), (String)"level");
            this.level = level;
            return this;
        }

        @NotNull
        public final String getTag(boolean isRequest) {
            String string;
            boolean bl = isRequest;
            if (bl) {
                CharSequence charSequence = this.requestTag;
                boolean bl2 = false;
                boolean bl3 = false;
                if (charSequence == null || charSequence.length() == 0) {
                    string = TAG;
                } else {
                    string = this.requestTag;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                }
            } else if (!bl) {
                CharSequence charSequence = this.responseTag;
                boolean bl4 = false;
                boolean bl5 = false;
                if (charSequence == null || charSequence.length() == 0) {
                    string = TAG;
                } else {
                    string = this.responseTag;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        @NotNull
        public final Builder addHeader(@NotNull String name, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            ((Map)this.headers).put(name, value);
            return this;
        }

        @NotNull
        public final Builder addQueryParam(@NotNull String name, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            ((Map)this.httpUrl).put(name, value);
            return this;
        }

        @NotNull
        public final Builder tag(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            TAG = tag;
            return this;
        }

        @NotNull
        public final Builder request(@Nullable String tag) {
            this.requestTag = tag;
            return this;
        }

        @NotNull
        public final Builder response(@Nullable String tag) {
            this.responseTag = tag;
            return this;
        }

        @Deprecated(message="Set level based on your requirement", replaceWith=@ReplaceWith(imports={}, expression="setLevel(Level.Basic)"), level=DeprecationLevel.ERROR)
        @NotNull
        public final Builder loggable(boolean isDebug) {
            this.isDebugAble = isDebug;
            return this;
        }

        @NotNull
        public final Builder log(int type) {
            this.type = type;
            return this;
        }

        @NotNull
        public final Builder logger(@Nullable Logger logger) {
            this.logger = logger;
            return this;
        }

        @Deprecated(message="Create your own Logcat filter for best result", level=DeprecationLevel.ERROR)
        @NotNull
        public final Builder executor(@Nullable Executor executor) {
            String string = "Deprecated";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }

        @NotNull
        public final Builder enableMock(boolean useMock, long sleep, @Nullable BufferListener listener) {
            this.isMockEnabled = useMock;
            this.sleepMs = sleep;
            this.listener = listener;
            return this;
        }

        @Deprecated(message="Android studio has resolved problem for latest versions", level=DeprecationLevel.WARNING)
        @NotNull
        public final Builder enableAndroidStudioV3LogsHack(boolean useHack) {
            this.isLogHackEnable = useHack;
            return this;
        }

        @NotNull
        public final LoggingInterceptor build() {
            return new LoggingInterceptor(this, null);
        }

        static {
            Companion = new Companion(null);
            TAG = "LoggingI";
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/ihsanbal/logging/LoggingInterceptor$Builder$Companion;", "", "()V", "TAG", "", "lib"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

