/*
 * Decompiled with CFR 0.152.
 */
package com.ihsanbal.logging;

import android.text.TextUtils;
import com.ihsanbal.logging.Level;
import com.ihsanbal.logging.Logger;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class LoggingInterceptor
implements Interceptor {
    private final boolean isDebug;
    private Builder builder;

    private LoggingInterceptor(Builder builder) {
        this.builder = builder;
        this.isDebug = builder.isDebug;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (this.builder.getHeaders().size() > 0) {
            Headers headers = request.headers();
            Set names = headers.names();
            Iterator iterator = names.iterator();
            Request.Builder requestBuilder = request.newBuilder();
            requestBuilder.headers(this.builder.getHeaders());
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                requestBuilder.addHeader(name, headers.get(name));
            }
            request = requestBuilder.build();
        }
        if (!this.isDebug || this.builder.getLevel() == Level.NONE) {
            return chain.proceed(request);
        }
        Logger.printJsonRequest(this.builder, request);
        long st = System.nanoTime();
        Response response = chain.proceed(request);
        List segmentList = ((Request)request.tag()).url().encodedPathSegments();
        long chainMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - st);
        String header = response.headers().toString();
        int code = response.code();
        boolean isSuccessful = response.isSuccessful();
        String bodyString = Logger.getJsonString(response.body().string());
        Logger.printJsonResponse(this.builder, chainMs, isSuccessful, code, header, bodyString, segmentList);
        Request cloneRequest = chain.request();
        MediaType contentType = null;
        if (cloneRequest.body() != null) {
            contentType = cloneRequest.body().contentType();
        }
        ResponseBody body = ResponseBody.create(contentType, (String)bodyString);
        return response.newBuilder().body(body).build();
    }

    public static class Builder {
        private static String TAG = "LoggingI";
        private boolean isDebug;
        private int type = 3;
        private String requestTag;
        private String responseTag;
        private Level level = Level.BASIC;
        private Headers.Builder builder = new Headers.Builder();

        int getType() {
            return this.type;
        }

        Level getLevel() {
            return this.level;
        }

        Headers getHeaders() {
            return this.builder.build();
        }

        String getTag(boolean isRequest) {
            if (isRequest) {
                return TextUtils.isEmpty((CharSequence)this.requestTag) ? TAG : this.requestTag;
            }
            return TextUtils.isEmpty((CharSequence)this.responseTag) ? TAG : this.responseTag;
        }

        public Builder addHeader(String name, String value) {
            this.builder.set(name, value);
            return this;
        }

        public Builder setLevel(Level level) {
            this.level = level;
            return this;
        }

        public Builder tag(String tag) {
            TAG = tag;
            return this;
        }

        public Builder request(String tag) {
            this.requestTag = tag;
            return this;
        }

        public Builder response(String tag) {
            this.responseTag = tag;
            return this;
        }

        public Builder loggable(boolean isDebug) {
            this.isDebug = isDebug;
            return this;
        }

        public Builder log(int type) {
            this.type = type;
            return this;
        }

        void addHeaders(Headers headers) {
            if (headers != null && headers.size() > 0) {
                Object[] names = headers.names().toArray();
                for (int i = 0; i < headers.size(); ++i) {
                    this.addHeader(names[i].toString(), headers.get(names[i].toString()));
                }
            }
        }

        public LoggingInterceptor build() {
            return new LoggingInterceptor(this);
        }
    }
}

