/*
 * Decompiled with CFR 0.152.
 */
package me.ibrahimsn.lib;

import android.graphics.Rect;
import android.os.Bundle;
import android.view.View;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.customview.widget.ExploreByTouchHelper;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import me.ibrahimsn.lib.BottomBarItem;
import me.ibrahimsn.lib.SmoothBottomBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B@\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012!\u0010\u0007\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0016\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0014J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0014J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\"\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0014J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0007\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lme/ibrahimsn/lib/AccessibleExploreByTouchHelper;", "Landroidx/customview/widget/ExploreByTouchHelper;", "host", "Lme/ibrahimsn/lib/SmoothBottomBar;", "bottomBarItems", "", "Lme/ibrahimsn/lib/BottomBarItem;", "onClickAction", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "id", "", "<init>", "(Lme/ibrahimsn/lib/SmoothBottomBar;Ljava/util/List;Lkotlin/jvm/functions/Function1;)V", "getVisibleVirtualViews", "virtualViewIds", "", "getVirtualViewAt", "x", "", "y", "onPopulateNodeForVirtualView", "virtualViewId", "node", "Landroidx/core/view/accessibility/AccessibilityNodeInfoCompat;", "onPerformActionForVirtualView", "", "action", "arguments", "Landroid/os/Bundle;", "updateBoundsForBottomItem", "Landroid/graphics/Rect;", "index", "lib_release"})
public final class AccessibleExploreByTouchHelper
extends ExploreByTouchHelper {
    @NotNull
    private final SmoothBottomBar host;
    @NotNull
    private final List<BottomBarItem> bottomBarItems;
    @NotNull
    private final Function1<Integer, Unit> onClickAction;

    public AccessibleExploreByTouchHelper(@NotNull SmoothBottomBar host, @NotNull List<BottomBarItem> bottomBarItems, @NotNull Function1<? super Integer, Unit> onClickAction) {
        Intrinsics.checkNotNullParameter((Object)((Object)host), (String)"host");
        Intrinsics.checkNotNullParameter(bottomBarItems, (String)"bottomBarItems");
        Intrinsics.checkNotNullParameter(onClickAction, (String)"onClickAction");
        super((View)host);
        this.host = host;
        this.bottomBarItems = bottomBarItems;
        this.onClickAction = onClickAction;
    }

    protected void getVisibleVirtualViews(@NotNull List<Integer> virtualViewIds) {
        Intrinsics.checkNotNullParameter(virtualViewIds, (String)"virtualViewIds");
        int n = ((Collection)this.bottomBarItems).size();
        for (int i = 0; i < n; ++i) {
            virtualViewIds.add(i);
        }
    }

    protected int getVirtualViewAt(float x, float y) {
        int itemWidth = this.host.getWidth() / this.bottomBarItems.size();
        return (int)(x / (float)itemWidth);
    }

    protected void onPopulateNodeForVirtualView(int virtualViewId, @NotNull AccessibilityNodeInfoCompat node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        node.setClassName((CharSequence)Reflection.getOrCreateKotlinClass(BottomBarItem.class).getSimpleName());
        node.setContentDescription((CharSequence)this.bottomBarItems.get(virtualViewId).getContentDescription());
        node.setClickable(true);
        node.setFocusable(true);
        node.setScreenReaderFocusable(true);
        node.addAction(AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_CLICK);
        node.setSelected(this.host.getItemActiveIndex() == virtualViewId);
        Rect bottomItemBoundRect = this.updateBoundsForBottomItem(virtualViewId);
        node.setBoundsInParent(bottomItemBoundRect);
    }

    protected boolean onPerformActionForVirtualView(int virtualViewId, int action, @Nullable Bundle arguments) {
        if (action == 16) {
            this.onClickAction.invoke((Object)virtualViewId);
            return true;
        }
        return false;
    }

    private final Rect updateBoundsForBottomItem(int index) {
        int left;
        Rect itemBounds = new Rect();
        int itemWidth = this.host.getWidth() / this.bottomBarItems.size();
        itemBounds.left = left = index * itemWidth;
        itemBounds.top = 0;
        itemBounds.right = left + itemWidth;
        itemBounds.bottom = this.host.getHeight();
        return itemBounds;
    }
}

