/*
 * Decompiled with CFR 0.152.
 */
package com.bosong.frescozoomablelib.zoomable;

import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.view.MotionEvent;
import com.bosong.frescozoomablelib.gestures.TransformGestureDetector;
import com.bosong.frescozoomablelib.zoomable.ZoomableController;
import com.facebook.common.logging.FLog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class DefaultZoomableController
implements ZoomableController,
TransformGestureDetector.Listener {
    public static final int LIMIT_NONE = 0;
    public static final int LIMIT_TRANSLATION_X = 1;
    public static final int LIMIT_TRANSLATION_Y = 2;
    public static final int LIMIT_SCALE = 4;
    public static final int LIMIT_ALL = 7;
    private static final float EPS = 0.001f;
    private static final Class<?> TAG = DefaultZoomableController.class;
    private static final RectF IDENTITY_RECT = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
    private TransformGestureDetector mGestureDetector;
    private ZoomableController.Listener mListener = null;
    private boolean mIsEnabled = false;
    private boolean mIsRotationEnabled = false;
    private boolean mIsScaleEnabled = true;
    private boolean mIsTranslationEnabled = true;
    private float mMinScaleFactor = 1.0f;
    private float mMaxScaleFactor = 2.0f;
    private final RectF mViewBounds = new RectF();
    private final RectF mImageBounds = new RectF();
    private final RectF mTransformedImageBounds = new RectF();
    private final Matrix mPreviousTransform = new Matrix();
    private final Matrix mActiveTransform = new Matrix();
    private final Matrix mActiveTransformInverse = new Matrix();
    private final float[] mTempValues = new float[9];
    private final RectF mTempRect = new RectF();
    private boolean mWasTransformCorrected;

    public static DefaultZoomableController newInstance() {
        return new DefaultZoomableController(TransformGestureDetector.newInstance());
    }

    public DefaultZoomableController(TransformGestureDetector gestureDetector) {
        this.mGestureDetector = gestureDetector;
        this.mGestureDetector.setListener(this);
    }

    public void reset() {
        FLog.v(TAG, (String)"reset");
        this.mGestureDetector.reset();
        this.mPreviousTransform.reset();
        this.mActiveTransform.reset();
        this.onTransformChanged();
    }

    @Override
    public void setListener(ZoomableController.Listener listener) {
        this.mListener = listener;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.mIsEnabled = enabled;
        if (!enabled) {
            this.reset();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    public void setRotationEnabled(boolean enabled) {
        this.mIsRotationEnabled = enabled;
    }

    public boolean isRotationEnabled() {
        return this.mIsRotationEnabled;
    }

    public void setScaleEnabled(boolean enabled) {
        this.mIsScaleEnabled = enabled;
    }

    public boolean isScaleEnabled() {
        return this.mIsScaleEnabled;
    }

    public void setTranslationEnabled(boolean enabled) {
        this.mIsTranslationEnabled = enabled;
    }

    public boolean isTranslationEnabled() {
        return this.mIsTranslationEnabled;
    }

    public void setMinScaleFactor(float minScaleFactor) {
        this.mMinScaleFactor = minScaleFactor;
    }

    public float getMinScaleFactor() {
        return this.mMinScaleFactor;
    }

    public void setMaxScaleFactor(float maxScaleFactor) {
        this.mMaxScaleFactor = maxScaleFactor;
    }

    public float getMaxScaleFactor() {
        return this.mMaxScaleFactor;
    }

    @Override
    public float getScaleFactor() {
        return this.getMatrixScaleFactor(this.mActiveTransform);
    }

    @Override
    public void setImageBounds(RectF imageBounds) {
        if (!imageBounds.equals((Object)this.mImageBounds)) {
            this.mImageBounds.set(imageBounds);
            this.onTransformChanged();
        }
    }

    public RectF getImageBounds() {
        return this.mImageBounds;
    }

    private RectF getTransformedImageBounds() {
        return this.mTransformedImageBounds;
    }

    @Override
    public void setViewBounds(RectF viewBounds) {
        this.mViewBounds.set(viewBounds);
    }

    public RectF getViewBounds() {
        return this.mViewBounds;
    }

    @Override
    public boolean isIdentity() {
        return this.isMatrixIdentity(this.mActiveTransform, 0.001f);
    }

    @Override
    public boolean wasTransformCorrected() {
        return this.mWasTransformCorrected;
    }

    @Override
    public Matrix getTransform() {
        return this.mActiveTransform;
    }

    public void getImageRelativeToViewAbsoluteTransform(Matrix outMatrix) {
        outMatrix.setRectToRect(IDENTITY_RECT, this.mTransformedImageBounds, Matrix.ScaleToFit.FILL);
    }

    public PointF mapViewToImage(PointF viewPoint) {
        float[] points = this.mTempValues;
        points[0] = viewPoint.x;
        points[1] = viewPoint.y;
        this.mActiveTransform.invert(this.mActiveTransformInverse);
        this.mActiveTransformInverse.mapPoints(points, 0, points, 0, 1);
        this.mapAbsoluteToRelative(points, points, 1);
        return new PointF(points[0], points[1]);
    }

    public PointF mapImageToView(PointF imagePoint) {
        float[] points = this.mTempValues;
        points[0] = imagePoint.x;
        points[1] = imagePoint.y;
        this.mapRelativeToAbsolute(points, points, 1);
        this.mActiveTransform.mapPoints(points, 0, points, 0, 1);
        return new PointF(points[0], points[1]);
    }

    private void mapAbsoluteToRelative(float[] destPoints, float[] srcPoints, int numPoints) {
        for (int i = 0; i < numPoints; ++i) {
            destPoints[i * 2 + 0] = (srcPoints[i * 2 + 0] - this.mImageBounds.left) / this.mImageBounds.width();
            destPoints[i * 2 + 1] = (srcPoints[i * 2 + 1] - this.mImageBounds.top) / this.mImageBounds.height();
        }
    }

    private void mapRelativeToAbsolute(float[] destPoints, float[] srcPoints, int numPoints) {
        for (int i = 0; i < numPoints; ++i) {
            destPoints[i * 2 + 0] = srcPoints[i * 2 + 0] * this.mImageBounds.width() + this.mImageBounds.left;
            destPoints[i * 2 + 1] = srcPoints[i * 2 + 1] * this.mImageBounds.height() + this.mImageBounds.top;
        }
    }

    public void zoomToPoint(float scale, PointF imagePoint, PointF viewPoint) {
        FLog.v(TAG, (String)"zoomToPoint");
        this.calculateZoomToPointTransform(this.mActiveTransform, scale, imagePoint, viewPoint, 7);
        this.onTransformChanged();
    }

    protected boolean calculateZoomToPointTransform(Matrix outTransform, float scale, PointF imagePoint, PointF viewPoint, int limitFlags) {
        float[] viewAbsolute = this.mTempValues;
        viewAbsolute[0] = imagePoint.x;
        viewAbsolute[1] = imagePoint.y;
        this.mapRelativeToAbsolute(viewAbsolute, viewAbsolute, 1);
        float distanceX = viewPoint.x - viewAbsolute[0];
        float distanceY = viewPoint.y - viewAbsolute[1];
        boolean transformCorrected = false;
        outTransform.setScale(scale, scale, viewAbsolute[0], viewAbsolute[1]);
        transformCorrected |= this.limitScale(outTransform, viewAbsolute[0], viewAbsolute[1], limitFlags);
        outTransform.postTranslate(distanceX, distanceY);
        return transformCorrected |= this.limitTranslation(outTransform, limitFlags);
    }

    public void setTransform(Matrix newTransform) {
        FLog.v(TAG, (String)"setTransform");
        this.mActiveTransform.set(newTransform);
        this.onTransformChanged();
    }

    protected TransformGestureDetector getDetector() {
        return this.mGestureDetector;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        FLog.v(TAG, (String)"onTouchEvent: action: ", (Object)event.getAction());
        if (this.mIsEnabled) {
            return this.mGestureDetector.onTouchEvent(event);
        }
        return false;
    }

    @Override
    public void onGestureBegin(TransformGestureDetector detector) {
        FLog.v(TAG, (String)"onGestureBegin");
        this.mPreviousTransform.set(this.mActiveTransform);
        this.mWasTransformCorrected = !this.canScrollInAllDirection();
    }

    @Override
    public void onGestureUpdate(TransformGestureDetector detector) {
        FLog.v(TAG, (String)"onGestureUpdate");
        boolean transformCorrected = this.calculateGestureTransform(this.mActiveTransform, 7);
        this.onTransformChanged();
        this.mWasTransformCorrected = transformCorrected;
    }

    @Override
    public void onGestureEnd(TransformGestureDetector detector) {
        FLog.v(TAG, (String)"onGestureEnd");
    }

    protected boolean calculateGestureTransform(Matrix outTransform, int limitTypes) {
        TransformGestureDetector detector = this.mGestureDetector;
        boolean transformCorrected = false;
        outTransform.set(this.mPreviousTransform);
        if (this.mIsRotationEnabled) {
            float angle = detector.getRotation() * 57.29578f;
            outTransform.postRotate(angle, detector.getPivotX(), detector.getPivotY());
        }
        if (this.mIsScaleEnabled) {
            float scale = detector.getScale();
            outTransform.postScale(scale, scale, detector.getPivotX(), detector.getPivotY());
        }
        transformCorrected |= this.limitScale(outTransform, detector.getPivotX(), detector.getPivotY(), limitTypes);
        if (this.mIsTranslationEnabled) {
            outTransform.postTranslate(detector.getTranslationX(), detector.getTranslationY());
        }
        return transformCorrected |= this.limitTranslation(outTransform, limitTypes);
    }

    private void onTransformChanged() {
        this.mActiveTransform.mapRect(this.mTransformedImageBounds, this.mImageBounds);
        if (this.mListener != null && this.isEnabled()) {
            this.mListener.onTransformChanged(this.mActiveTransform);
        }
    }

    private boolean limitScale(Matrix transform, float pivotX, float pivotY, int limitTypes) {
        if (!DefaultZoomableController.shouldLimit(limitTypes, 4)) {
            return false;
        }
        float currentScale = this.getMatrixScaleFactor(transform);
        float targetScale = this.limit(currentScale, this.mMinScaleFactor, this.mMaxScaleFactor);
        if (targetScale != currentScale) {
            float scale = targetScale / currentScale;
            transform.postScale(scale, scale, pivotX, pivotY);
            return true;
        }
        return false;
    }

    private boolean limitTranslation(Matrix transform, int limitTypes) {
        float offsetTop;
        if (!DefaultZoomableController.shouldLimit(limitTypes, 3)) {
            return false;
        }
        RectF b = this.mTempRect;
        b.set(this.mImageBounds);
        transform.mapRect(b);
        float offsetLeft = DefaultZoomableController.shouldLimit(limitTypes, 1) ? this.getOffset(b.left, b.right, this.mViewBounds.left, this.mViewBounds.right, this.mImageBounds.centerX()) : 0.0f;
        float f = offsetTop = DefaultZoomableController.shouldLimit(limitTypes, 2) ? this.getOffset(b.top, b.bottom, this.mViewBounds.top, this.mViewBounds.bottom, this.mImageBounds.centerY()) : 0.0f;
        if (offsetLeft != 0.0f || offsetTop != 0.0f) {
            transform.postTranslate(offsetLeft, offsetTop);
            return true;
        }
        return false;
    }

    private static boolean shouldLimit(int limits, int flag) {
        return (limits & flag) != 0;
    }

    private float getOffset(float imageStart, float imageEnd, float limitStart, float limitEnd, float limitCenter) {
        float imageWidth = imageEnd - imageStart;
        float limitWidth = limitEnd - limitStart;
        float limitInnerWidth = Math.min(limitCenter - limitStart, limitEnd - limitCenter) * 2.0f;
        if (imageWidth < limitInnerWidth) {
            return limitCenter - (imageEnd + imageStart) / 2.0f;
        }
        if (imageWidth < limitWidth) {
            if (limitCenter < (limitStart + limitEnd) / 2.0f) {
                return limitStart - imageStart;
            }
            return limitEnd - imageEnd;
        }
        if (imageStart > limitStart) {
            return limitStart - imageStart;
        }
        if (imageEnd < limitEnd) {
            return limitEnd - imageEnd;
        }
        return 0.0f;
    }

    private float limit(float value, float min, float max) {
        return Math.min(Math.max(min, value), max);
    }

    private float getMatrixScaleFactor(Matrix transform) {
        transform.getValues(this.mTempValues);
        return this.mTempValues[0];
    }

    private boolean isMatrixIdentity(Matrix transform, float eps) {
        transform.getValues(this.mTempValues);
        this.mTempValues[0] = this.mTempValues[0] - 1.0f;
        this.mTempValues[4] = this.mTempValues[4] - 1.0f;
        this.mTempValues[8] = this.mTempValues[8] - 1.0f;
        for (int i = 0; i < 9; ++i) {
            if (!(Math.abs(this.mTempValues[i]) > eps)) continue;
            return false;
        }
        return true;
    }

    private boolean canScrollInAllDirection() {
        return this.mTransformedImageBounds.left < this.mViewBounds.left - 0.001f && this.mTransformedImageBounds.top < this.mViewBounds.top - 0.001f && this.mTransformedImageBounds.right > this.mViewBounds.right + 0.001f && this.mTransformedImageBounds.bottom > this.mViewBounds.bottom + 0.001f;
    }

    @Override
    public int computeHorizontalScrollRange() {
        return (int)this.mTransformedImageBounds.width();
    }

    @Override
    public int computeHorizontalScrollOffset() {
        return (int)(this.mViewBounds.left - this.mTransformedImageBounds.left);
    }

    @Override
    public int computeHorizontalScrollExtent() {
        return (int)this.mViewBounds.width();
    }

    @Override
    public int computeVerticalScrollRange() {
        return (int)this.mTransformedImageBounds.height();
    }

    @Override
    public int computeVerticalScrollOffset() {
        return (int)(this.mViewBounds.top - this.mTransformedImageBounds.top);
    }

    @Override
    public int computeVerticalScrollExtent() {
        return (int)this.mViewBounds.height();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LimitFlag {
    }
}

