/*
 * Decompiled with CFR 0.152.
 */
package com.bosong.frescozoomablelib.zoomable;

import android.graphics.Matrix;
import android.support.annotation.Nullable;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.bosong.frescozoomablelib.gestures.TransformGestureDetector;
import com.bosong.frescozoomablelib.zoomable.AbstractAnimatedZoomableController;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.logging.FLog;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorListenerAdapter;
import com.nineoldandroids.animation.ValueAnimator;

public class AnimatedZoomableControllerSupport
extends AbstractAnimatedZoomableController {
    private static final Class<?> TAG = AnimatedZoomableControllerSupport.class;
    private final ValueAnimator mValueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});

    public static AnimatedZoomableControllerSupport newInstance() {
        return new AnimatedZoomableControllerSupport(TransformGestureDetector.newInstance());
    }

    public AnimatedZoomableControllerSupport(TransformGestureDetector transformGestureDetector) {
        super(transformGestureDetector);
        this.mValueAnimator.setInterpolator((Interpolator)new DecelerateInterpolator());
    }

    @Override
    public void setTransformAnimated(Matrix newTransform, long durationMs, final @Nullable Runnable onAnimationComplete) {
        FLog.v(this.getLogTag(), (String)"setTransformAnimated: duration %d ms", (Object)durationMs);
        this.stopAnimation();
        Preconditions.checkArgument((durationMs > 0L ? 1 : 0) != 0);
        Preconditions.checkState((!this.isAnimating() ? 1 : 0) != 0);
        this.setAnimating(true);
        this.mValueAnimator.setDuration(durationMs);
        this.getTransform().getValues(this.getStartValues());
        newTransform.getValues(this.getStopValues());
        this.mValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                AnimatedZoomableControllerSupport.this.calculateInterpolation(AnimatedZoomableControllerSupport.this.getWorkingTransform(), ((Float)valueAnimator.getAnimatedValue()).floatValue());
                AnimatedZoomableControllerSupport.super.setTransform(AnimatedZoomableControllerSupport.this.getWorkingTransform());
            }
        });
        this.mValueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationCancel(Animator animation) {
                FLog.v(AnimatedZoomableControllerSupport.this.getLogTag(), (String)"setTransformAnimated: animation cancelled");
                this.onAnimationStopped();
            }

            public void onAnimationEnd(Animator animation) {
                FLog.v(AnimatedZoomableControllerSupport.this.getLogTag(), (String)"setTransformAnimated: animation finished");
                this.onAnimationStopped();
            }

            private void onAnimationStopped() {
                if (onAnimationComplete != null) {
                    onAnimationComplete.run();
                }
                AnimatedZoomableControllerSupport.this.setAnimating(false);
                AnimatedZoomableControllerSupport.this.getDetector().restartGesture();
            }
        });
        this.mValueAnimator.start();
    }

    @Override
    public void stopAnimation() {
        if (!this.isAnimating()) {
            return;
        }
        FLog.v(this.getLogTag(), (String)"stopAnimation");
        this.mValueAnimator.cancel();
        this.mValueAnimator.removeAllUpdateListeners();
        this.mValueAnimator.removeAllListeners();
    }

    @Override
    protected Class<?> getLogTag() {
        return TAG;
    }
}

