/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.event;

import android.content.SharedPreferences;
import android.os.Handler;
import com.ironz.binaryprefs.event.EventBridge;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class MainThreadEventBridgeImpl
implements EventBridge {
    private final List<SharedPreferences.OnSharedPreferenceChangeListener> currentListeners;
    private final Handler handler = new Handler();

    public MainThreadEventBridgeImpl(String prefName, Map<String, List<SharedPreferences.OnSharedPreferenceChangeListener>> allListeners) {
        this.currentListeners = this.putIfAbsentListeners(prefName, allListeners);
    }

    private List<SharedPreferences.OnSharedPreferenceChangeListener> putIfAbsentListeners(String prefName, Map<String, List<SharedPreferences.OnSharedPreferenceChangeListener>> allListeners) {
        if (allListeners.containsKey(prefName)) {
            return allListeners.get(prefName);
        }
        ArrayList<SharedPreferences.OnSharedPreferenceChangeListener> listeners = new ArrayList<SharedPreferences.OnSharedPreferenceChangeListener>();
        allListeners.put(prefName, listeners);
        return listeners;
    }

    @Override
    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.currentListeners.add(listener);
    }

    @Override
    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.currentListeners.remove(listener);
    }

    @Override
    public void notifyListenersUpdate(String key, byte[] bytes) {
        this.notifyListeners(key);
    }

    @Override
    public void notifyListenersRemove(String key) {
        this.notifyListeners(key);
    }

    private void notifyListeners(final String key) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (SharedPreferences.OnSharedPreferenceChangeListener listener : MainThreadEventBridgeImpl.this.currentListeners) {
                    listener.onSharedPreferenceChanged(null, key);
                }
            }
        });
    }
}

