/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.event;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Process;
import com.ironz.binaryprefs.cache.CacheProvider;
import com.ironz.binaryprefs.encryption.ValueEncryption;
import com.ironz.binaryprefs.event.EventBridge;
import com.ironz.binaryprefs.file.directory.DirectoryProvider;
import com.ironz.binaryprefs.serialization.SerializerFactory;
import com.ironz.binaryprefs.task.TaskExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class BroadcastEventBridgeImpl
implements EventBridge {
    private static final String INTENT_PREFIX = "com.ironz.binaryprefs.";
    private static final String ACTION_PREFERENCE_UPDATED = "com.ironz.binaryprefs.ACTION_PREFERENCE_UPDATED_";
    private static final String ACTION_PREFERENCE_REMOVED = "com.ironz.binaryprefs.ACTION_PREFERENCE_REMOVED_";
    private static final String PREFERENCE_NAME = "preference_name";
    private static final String PREFERENCE_KEY = "preference_key";
    private static final String PREFERENCE_VALUE = "preference_value";
    private static final String PREFERENCE_PROCESS_ID = "preference_process_id";
    private final List<SharedPreferences.OnSharedPreferenceChangeListener> currentListeners;
    private final Handler handler = new Handler();
    private final Context context;
    private final String prefName;
    private final CacheProvider cacheProvider;
    private final SerializerFactory serializerFactory;
    private final TaskExecutor taskExecutor;
    private final ValueEncryption valueEncryption;
    private final String updateActionName;
    private final String removeActionName;
    private final int processId;
    private final BroadcastReceiver updateReceiver;
    private final BroadcastReceiver removeReceiver;

    public BroadcastEventBridgeImpl(Context context, String prefName, CacheProvider cacheProvider, SerializerFactory serializerFactory, TaskExecutor taskExecutor, ValueEncryption valueEncryption, DirectoryProvider directoryProvider, Map<String, List<SharedPreferences.OnSharedPreferenceChangeListener>> allListeners) {
        this.context = context;
        this.prefName = prefName;
        this.cacheProvider = cacheProvider;
        this.serializerFactory = serializerFactory;
        this.taskExecutor = taskExecutor;
        this.valueEncryption = valueEncryption;
        this.updateActionName = this.createUpdateActionName(directoryProvider);
        this.removeActionName = this.createRemoveActionName(directoryProvider);
        this.currentListeners = this.putIfAbsentListeners(prefName, allListeners);
        this.updateReceiver = this.createUpdateReceiver();
        this.removeReceiver = this.createRemoveReceiver();
        this.processId = Process.myPid();
    }

    private String createUpdateActionName(DirectoryProvider directoryProvider) {
        return ACTION_PREFERENCE_UPDATED + directoryProvider.getStoreDirectory().getAbsolutePath();
    }

    private String createRemoveActionName(DirectoryProvider directoryProvider) {
        return ACTION_PREFERENCE_REMOVED + directoryProvider.getStoreDirectory().getAbsolutePath();
    }

    private List<SharedPreferences.OnSharedPreferenceChangeListener> putIfAbsentListeners(String prefName, Map<String, List<SharedPreferences.OnSharedPreferenceChangeListener>> allListeners) {
        if (allListeners.containsKey(prefName)) {
            return allListeners.get(prefName);
        }
        ArrayList<SharedPreferences.OnSharedPreferenceChangeListener> listeners = new ArrayList<SharedPreferences.OnSharedPreferenceChangeListener>();
        allListeners.put(prefName, listeners);
        return listeners;
    }

    private BroadcastReceiver createRemoveReceiver() {
        return new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                BroadcastEventBridgeImpl.this.notifyRemove(intent);
            }
        };
    }

    private BroadcastReceiver createUpdateReceiver() {
        return new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                BroadcastEventBridgeImpl.this.notifyUpdate(intent);
            }
        };
    }

    private void subscribeReceivers() {
        this.context.registerReceiver(this.updateReceiver, new IntentFilter(this.updateActionName));
        this.context.registerReceiver(this.removeReceiver, new IntentFilter(this.removeActionName));
    }

    private void notifyUpdate(Intent intent) {
        if (!this.prefName.equals(intent.getStringExtra(PREFERENCE_NAME))) {
            return;
        }
        if (this.processId == intent.getIntExtra(PREFERENCE_PROCESS_ID, 0)) {
            return;
        }
        String key = intent.getStringExtra(PREFERENCE_KEY);
        byte[] value = intent.getByteArrayExtra(PREFERENCE_VALUE);
        this.notifyUpdateTask(key, value);
    }

    private void notifyUpdateTask(final String key, final byte[] value) {
        this.taskExecutor.submit(new Runnable(){

            @Override
            public void run() {
                BroadcastEventBridgeImpl.this.notifyUpdateInternal(key, value);
            }
        });
    }

    private void notifyUpdateInternal(String key, byte[] value) {
        Object o = this.fetchObject(key, value);
        this.update(key, o);
    }

    private Object fetchObject(String key, byte[] bytes) {
        byte[] decrypt = this.valueEncryption.decrypt(bytes);
        return this.serializerFactory.deserialize(key, decrypt);
    }

    private void notifyRemove(Intent intent) {
        if (!this.prefName.equals(intent.getStringExtra(PREFERENCE_NAME))) {
            return;
        }
        if (this.processId == intent.getIntExtra(PREFERENCE_PROCESS_ID, 0)) {
            return;
        }
        this.notifyRemoveTask(intent);
    }

    private void notifyRemoveTask(final Intent intent) {
        this.taskExecutor.submit(new Runnable(){

            @Override
            public void run() {
                BroadcastEventBridgeImpl.this.notifyRemoveInternal(intent);
            }
        });
    }

    private void notifyRemoveInternal(Intent intent) {
        String key = intent.getStringExtra(PREFERENCE_KEY);
        this.remove(key);
    }

    @Override
    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        if (this.currentListeners.isEmpty()) {
            this.subscribeReceivers();
        }
        this.currentListeners.add(listener);
    }

    @Override
    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.currentListeners.remove(listener);
        if (this.currentListeners.isEmpty()) {
            this.unSubscribeReceivers();
        }
    }

    private void unSubscribeReceivers() {
        this.context.unregisterReceiver(this.updateReceiver);
        this.context.unregisterReceiver(this.removeReceiver);
    }

    @Override
    public void notifyListenersUpdate(String key, byte[] bytes) {
        this.notifyListenersHandler(key);
        this.sendUpdateIntent(key, bytes);
    }

    @Override
    public void notifyListenersRemove(String key) {
        this.notifyListenersHandler(key);
        this.sendRemoveIntent(key);
    }

    private void update(String key, Object value) {
        this.cacheProvider.put(key, value);
        this.notifyListenersHandler(key);
    }

    private void remove(String key) {
        this.cacheProvider.remove(key);
        this.notifyListenersHandler(key);
    }

    private void notifyListenersHandler(final String key) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                BroadcastEventBridgeImpl.this.notifyListenersInternal(key);
            }
        });
    }

    private void notifyListenersInternal(String key) {
        for (SharedPreferences.OnSharedPreferenceChangeListener listener : this.currentListeners) {
            listener.onSharedPreferenceChanged(null, key);
        }
    }

    private void sendUpdateIntent(final String key, final byte[] bytes) {
        this.taskExecutor.submit(new Runnable(){

            @Override
            public void run() {
                BroadcastEventBridgeImpl.this.sendUpdateIntentInternal(key, bytes);
            }
        });
    }

    private void sendRemoveIntent(final String key) {
        this.taskExecutor.submit(new Runnable(){

            @Override
            public void run() {
                BroadcastEventBridgeImpl.this.sendRemoveIntentInternal(key);
            }
        });
    }

    private void sendUpdateIntentInternal(String key, byte[] bytes) {
        Intent intent = new Intent(this.updateActionName);
        intent.putExtra(PREFERENCE_PROCESS_ID, this.processId);
        intent.putExtra(PREFERENCE_NAME, this.prefName);
        intent.putExtra(PREFERENCE_KEY, key);
        intent.putExtra(PREFERENCE_VALUE, bytes);
        this.context.sendBroadcast(intent);
    }

    private void sendRemoveIntentInternal(String key) {
        Intent intent = new Intent(this.removeActionName);
        intent.putExtra(PREFERENCE_PROCESS_ID, this.processId);
        intent.putExtra(PREFERENCE_NAME, this.prefName);
        intent.putExtra(PREFERENCE_KEY, key);
        this.context.sendBroadcast(intent);
    }
}

