/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Environment;
import android.os.Looper;
import com.ironz.binaryprefs.BinaryPreferences;
import com.ironz.binaryprefs.ParametersProvider;
import com.ironz.binaryprefs.Preferences;
import com.ironz.binaryprefs.cache.ConcurrentCacheProviderImpl;
import com.ironz.binaryprefs.encryption.KeyEncryption;
import com.ironz.binaryprefs.encryption.ValueEncryption;
import com.ironz.binaryprefs.event.BroadcastEventBridgeImpl;
import com.ironz.binaryprefs.event.EventBridge;
import com.ironz.binaryprefs.event.ExceptionHandler;
import com.ironz.binaryprefs.event.MainThreadEventBridgeImpl;
import com.ironz.binaryprefs.exception.PreferencesInitializationException;
import com.ironz.binaryprefs.file.adapter.NioFileAdapter;
import com.ironz.binaryprefs.file.directory.AndroidDirectoryProviderImpl;
import com.ironz.binaryprefs.file.transaction.MultiProcessTransactionImpl;
import com.ironz.binaryprefs.lock.SimpleLockFactoryImpl;
import com.ironz.binaryprefs.migration.MigrateProcessor;
import com.ironz.binaryprefs.serialization.SerializerFactory;
import com.ironz.binaryprefs.serialization.serializer.persistable.Persistable;
import com.ironz.binaryprefs.serialization.serializer.persistable.PersistableRegistry;
import com.ironz.binaryprefs.task.ScheduledBackgroundTaskExecutor;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public final class BinaryPreferencesBuilder {
    private static final String INCORRECT_THREAD_INIT_MESSAGE = "Preferences should be instantiated in the main thread.";
    public static final String DEFAULT_NAME = "default";
    private final ParametersProvider parametersProvider = new ParametersProvider();
    private final Map<String, ReadWriteLock> locks = this.parametersProvider.getLocks();
    private final Map<String, Lock> processLocks = this.parametersProvider.getProcessLocks();
    private final Map<String, ExecutorService> executors = this.parametersProvider.getExecutors();
    private final Map<String, Map<String, Object>> caches = this.parametersProvider.getCaches();
    private final Map<String, List<SharedPreferences.OnSharedPreferenceChangeListener>> allListeners = this.parametersProvider.getAllListeners();
    private final Context context;
    private final PersistableRegistry persistableRegistry = new PersistableRegistry();
    private final MigrateProcessor migrateProcessor = new MigrateProcessor();
    private File baseDir = Environment.getDataDirectory();
    private String name = "default";
    private boolean supportInterProcess = false;
    private KeyEncryption keyEncryption = KeyEncryption.NO_OP;
    private ValueEncryption valueEncryption = ValueEncryption.NO_OP;
    private ExceptionHandler exceptionHandler = ExceptionHandler.PRINT;

    public BinaryPreferencesBuilder(Context context) {
        this.context = context;
        this.baseDir = context.getFilesDir();
    }

    public BinaryPreferencesBuilder name(String name) {
        this.name = name;
        return this;
    }

    public BinaryPreferencesBuilder externalStorage(boolean value) {
        this.baseDir = value ? this.context.getExternalFilesDir(null) : this.context.getFilesDir();
        return this;
    }

    public BinaryPreferencesBuilder customDirectory(File baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    public BinaryPreferencesBuilder supportInterProcess(boolean value) {
        this.supportInterProcess = value;
        return this;
    }

    public BinaryPreferencesBuilder keyEncryption(KeyEncryption keyEncryption) {
        this.keyEncryption = keyEncryption;
        return this;
    }

    public BinaryPreferencesBuilder valueEncryption(ValueEncryption valueEncryption) {
        this.valueEncryption = valueEncryption;
        return this;
    }

    public BinaryPreferencesBuilder exceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public BinaryPreferencesBuilder registerPersistable(String key, Class<? extends Persistable> persistable) {
        this.persistableRegistry.register(key, persistable);
        return this;
    }

    public BinaryPreferencesBuilder migrateFrom(SharedPreferences preferences) {
        this.migrateProcessor.add(preferences);
        return this;
    }

    public Preferences build() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new PreferencesInitializationException(INCORRECT_THREAD_INIT_MESSAGE);
        }
        BinaryPreferences preferences = this.createInstance();
        this.migrateProcessor.migrateTo(preferences);
        return preferences;
    }

    private BinaryPreferences createInstance() {
        AndroidDirectoryProviderImpl directoryProvider = new AndroidDirectoryProviderImpl(this.name, this.baseDir);
        NioFileAdapter fileAdapter = new NioFileAdapter(directoryProvider);
        SimpleLockFactoryImpl lockFactory = new SimpleLockFactoryImpl(this.name, directoryProvider, this.locks, this.processLocks);
        MultiProcessTransactionImpl fileTransaction = new MultiProcessTransactionImpl(fileAdapter, lockFactory, this.valueEncryption, this.keyEncryption);
        ConcurrentCacheProviderImpl cacheProvider = new ConcurrentCacheProviderImpl(this.name, this.caches);
        ScheduledBackgroundTaskExecutor executor = new ScheduledBackgroundTaskExecutor(this.name, this.exceptionHandler, this.executors);
        SerializerFactory serializerFactory = new SerializerFactory(this.persistableRegistry);
        EventBridge eventsBridge = this.supportInterProcess ? new BroadcastEventBridgeImpl(this.context, this.name, cacheProvider, serializerFactory, executor, this.valueEncryption, directoryProvider, this.allListeners) : new MainThreadEventBridgeImpl(this.name, this.allListeners);
        return new BinaryPreferences(fileTransaction, eventsBridge, cacheProvider, executor, serializerFactory, lockFactory);
    }
}

