/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs;

import android.content.SharedPreferences;
import com.ironz.binaryprefs.BinaryPreferencesEditor;
import com.ironz.binaryprefs.Preferences;
import com.ironz.binaryprefs.PreferencesEditor;
import com.ironz.binaryprefs.cache.CacheProvider;
import com.ironz.binaryprefs.event.EventBridge;
import com.ironz.binaryprefs.event.OnSharedPreferenceChangeListenerWrapper;
import com.ironz.binaryprefs.file.transaction.FileTransaction;
import com.ironz.binaryprefs.file.transaction.TransactionElement;
import com.ironz.binaryprefs.lock.LockFactory;
import com.ironz.binaryprefs.serialization.SerializerFactory;
import com.ironz.binaryprefs.serialization.serializer.persistable.Persistable;
import com.ironz.binaryprefs.task.FutureBarrier;
import com.ironz.binaryprefs.task.TaskExecutor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;

final class BinaryPreferences
implements Preferences {
    private final FileTransaction fileTransaction;
    private final EventBridge eventsBridge;
    private final CacheProvider cacheProvider;
    private final TaskExecutor taskExecutor;
    private final SerializerFactory serializerFactory;
    private final Lock readLock;
    private final Lock writeLock;

    BinaryPreferences(FileTransaction fileTransaction, EventBridge eventsBridge, CacheProvider cacheProvider, TaskExecutor taskExecutor, SerializerFactory serializerFactory, LockFactory lockFactory) {
        this.fileTransaction = fileTransaction;
        this.eventsBridge = eventsBridge;
        this.cacheProvider = cacheProvider;
        this.taskExecutor = taskExecutor;
        this.serializerFactory = serializerFactory;
        this.readLock = lockFactory.getReadLock();
        this.writeLock = lockFactory.getWriteLock();
        this.fetchCache();
    }

    private void fetchCache() {
        this.readLock.lock();
        try {
            FutureBarrier barrier = this.taskExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    BinaryPreferences.this.fetchInternal();
                }
            });
            barrier.completeBlockingUnsafe();
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void fetchInternal() {
        if (this.cacheProvider.keys().length != 0) {
            return;
        }
        for (TransactionElement element : this.fileTransaction.fetch()) {
            String name = element.getName();
            byte[] bytes = element.getContent();
            Object o = this.serializerFactory.deserialize(name, bytes);
            this.cacheProvider.put(name, o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getAll() {
        this.readLock.lock();
        try {
            Map<String, Object> all = this.cacheProvider.getAll();
            HashMap<String, Object> clone = new HashMap<String, Object>(all.size());
            for (String key : all.keySet()) {
                Object value = all.get(key);
                Object redefinedValue = this.serializerFactory.redefineMutable(value);
                clone.put(key, redefinedValue);
            }
            Map map = Collections.unmodifiableMap(clone);
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String key, String defValue) {
        this.readLock.lock();
        try {
            Object o = this.cacheProvider.get(key);
            if (o == null) {
                String string = defValue;
                return string;
            }
            String string = (String)o;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getStringSet(String key, Set<String> defValue) {
        this.readLock.lock();
        try {
            Object o = this.cacheProvider.get(key);
            if (o == null) {
                Set<String> set = defValue;
                return set;
            }
            Set strings = (Set)o;
            HashSet<String> hashSet = new HashSet<String>(strings);
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(String key, int defValue) {
        this.readLock.lock();
        try {
            Object o = this.cacheProvider.get(key);
            if (o == null) {
                int n = defValue;
                return n;
            }
            int n = (Integer)o;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(String key, long defValue) {
        this.readLock.lock();
        try {
            Object o = this.cacheProvider.get(key);
            if (o == null) {
                long l = defValue;
                return l;
            }
            long l = (Long)o;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(String key, float defValue) {
        this.readLock.lock();
        try {
            Object o = this.cacheProvider.get(key);
            if (o == null) {
                float f = defValue;
                return f;
            }
            float f = ((Float)o).floatValue();
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String key, boolean defValue) {
        this.readLock.lock();
        try {
            Object o = this.cacheProvider.get(key);
            if (o == null) {
                boolean bl = defValue;
                return bl;
            }
            boolean bl = (Boolean)o;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Persistable> T getPersistable(String key, T defValue) {
        this.readLock.lock();
        try {
            Object o = this.cacheProvider.get(key);
            if (o == null) {
                T t = defValue;
                return t;
            }
            Persistable persistable = ((Persistable)o).deepClone();
            return (T)persistable;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(String key, byte defValue) {
        this.readLock.lock();
        try {
            Object o = this.cacheProvider.get(key);
            if (o == null) {
                byte by = defValue;
                return by;
            }
            byte by = (Byte)o;
            return by;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(String key, short defValue) {
        this.readLock.lock();
        try {
            Object o = this.cacheProvider.get(key);
            if (o == null) {
                short s = defValue;
                return s;
            }
            short s = (Short)o;
            return s;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char getChar(String key, char defValue) {
        this.readLock.lock();
        try {
            Object o = this.cacheProvider.get(key);
            if (o == null) {
                char c = defValue;
                return c;
            }
            char c = ((Character)o).charValue();
            return c;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(String key, double defValue) {
        this.readLock.lock();
        try {
            Object o = this.cacheProvider.get(key);
            if (o == null) {
                double d = defValue;
                return d;
            }
            double d = (Double)o;
            return d;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean contains(String key) {
        this.readLock.lock();
        try {
            boolean bl = this.cacheProvider.contains(key);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public PreferencesEditor edit() {
        this.readLock.lock();
        try {
            BinaryPreferencesEditor binaryPreferencesEditor = new BinaryPreferencesEditor(this.fileTransaction, this.eventsBridge, this.taskExecutor, this.serializerFactory, this.cacheProvider, this.writeLock);
            return binaryPreferencesEditor;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<String> keys() {
        this.readLock.lock();
        try {
            List<String> list = Arrays.asList(this.cacheProvider.keys());
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.writeLock.lock();
        try {
            OnSharedPreferenceChangeListenerWrapper wrapper = new OnSharedPreferenceChangeListenerWrapper(this, listener);
            this.eventsBridge.registerOnSharedPreferenceChangeListener(wrapper);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.writeLock.lock();
        try {
            OnSharedPreferenceChangeListenerWrapper wrapper = new OnSharedPreferenceChangeListenerWrapper(this, listener);
            this.eventsBridge.unregisterOnSharedPreferenceChangeListener(wrapper);
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

