/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.bluetooth.wrapper;

import com.github.hypfvieh.DbusHelper;
import com.github.hypfvieh.bluetooth.wrapper.BluetoothDeviceType;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.Properties;
import org.freedesktop.dbus.types.Variant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBluetoothObject {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BluetoothDeviceType bluetoothType;
    private DBusConnection dbusConnection;
    private final String dbusPath;

    public AbstractBluetoothObject(BluetoothDeviceType _bluetoothType, DBusConnection _dbusConnection, String _dbusPath) {
        this.bluetoothType = _bluetoothType;
        this.dbusConnection = _dbusConnection;
        this.dbusPath = _dbusPath;
    }

    protected abstract Class<? extends DBusInterface> getInterfaceClass();

    public BluetoothDeviceType getBluetoothType() {
        return this.bluetoothType;
    }

    public String getDbusPath() {
        return this.dbusPath;
    }

    public DBusConnection getDbusConnection() {
        return this.dbusConnection;
    }

    protected <T extends DBusInterface> Map<String, T> getRemoteObjects(Set<String> _objectNames, String _parentPath, Class<T> _type) {
        LinkedHashMap<String, T> map = new LinkedHashMap<String, T>();
        String path = _parentPath;
        if (!_parentPath.endsWith("/")) {
            path = path + "/";
        }
        for (String string : _objectNames) {
            T remoteObject = DbusHelper.getRemoteObject(this.getDbusConnection(), path + string, _type);
            map.put(path + string, remoteObject);
        }
        return map;
    }

    protected <T> T getTyped(String _field, Class<T> _type) {
        Objects.requireNonNull(_type, "Class required");
        Objects.requireNonNull(_field, "Property name required");
        try {
            Properties remoteObject = (Properties)this.dbusConnection.getRemoteObject("org.bluez", this.dbusPath, Properties.class);
            Object obj = remoteObject.Get(this.getInterfaceClass().getName(), _field);
            if (_type.isAssignableFrom(obj.getClass())) {
                return _type.cast(obj);
            }
        }
        catch (DBusException | DBusExecutionException _ex) {
            this.logger.trace("Error while receiving data from DBUS (Field: {}, Type: {}).", new Object[]{_field, _type, _ex});
        }
        return null;
    }

    protected void setTyped(String _field, Object _value) {
        try {
            Properties remoteObject = (Properties)this.dbusConnection.getRemoteObject("org.bluez", this.dbusPath, Properties.class);
            remoteObject.Set(this.getInterfaceClass().getName(), _field, _value);
        }
        catch (DBusException _ex) {
            this.logger.trace("Error while setting data for DBUS (Field: {}, Value: {}).", new Object[]{_field, _value, _ex});
        }
    }

    protected Map<String, Variant<?>> optionsToVariantMap(Map<String, Object> _options) {
        LinkedHashMap optionMap = new LinkedHashMap();
        if (_options != null) {
            for (Map.Entry<String, Object> entry : _options.entrySet()) {
                if (entry.getValue() == null) continue;
                optionMap.put(entry.getKey(), new Variant(entry.getValue()));
            }
        }
        return optionMap;
    }

    protected byte[] byteListToByteArray(List<?> _list) {
        if (_list == null) {
            return null;
        }
        if (_list.isEmpty()) {
            return new byte[0];
        }
        if (!Byte.class.isAssignableFrom(_list.get(0).getClass()) && !Byte.TYPE.isAssignableFrom(_list.get(0).getClass())) {
            return null;
        }
        byte[] result = new byte[_list.size()];
        for (int i = 0; i < _list.size(); ++i) {
            Object x = _list.get(i);
            result[i] = (Byte)x;
        }
        return result;
    }

    protected byte[] toPrimitives(Byte[] oBytes) {
        byte[] bytes = new byte[oBytes.length];
        for (int i = 0; i < oBytes.length; ++i) {
            bytes[i] = oBytes[i];
        }
        return bytes;
    }
}

