/*
 * Decompiled with CFR 0.152.
 */
package com.hzn.lib;

import android.app.Activity;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.View;
import java.util.ArrayList;

public class EasyTransitionOptions {
    private Activity activity;
    private View[] views;
    private ArrayList<ViewAttrs> attrs;

    public EasyTransitionOptions(Activity activity, View[] views) {
        this.activity = activity;
        this.views = views;
    }

    public static EasyTransitionOptions makeTransitionOptions(Activity activity, View ... views) {
        return new EasyTransitionOptions(activity, views);
    }

    public void update() {
        if (null == this.views) {
            return;
        }
        this.attrs = new ArrayList();
        for (View v : this.views) {
            int[] location = new int[2];
            v.getLocationOnScreen(location);
            this.attrs.add(new ViewAttrs(v.getId(), location[0], location[1], v.getWidth(), v.getHeight()));
        }
    }

    public Activity getActivity() {
        return this.activity;
    }

    public ArrayList<ViewAttrs> getAttrs() {
        return this.attrs;
    }

    public static class ViewAttrs
    implements Parcelable {
        public int id;
        public float startX;
        public float startY;
        public float width;
        public float height;
        public static final Parcelable.Creator<ViewAttrs> CREATOR = new Parcelable.Creator<ViewAttrs>(){

            public ViewAttrs createFromParcel(Parcel source) {
                return new ViewAttrs(source);
            }

            public ViewAttrs[] newArray(int size) {
                return new ViewAttrs[size];
            }
        };

        public ViewAttrs(int id, float startX, float startY, float width, float height) {
            this.id = id;
            this.startX = startX;
            this.startY = startY;
            this.width = width;
            this.height = height;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.id);
            dest.writeFloat(this.startX);
            dest.writeFloat(this.startY);
            dest.writeFloat(this.width);
            dest.writeFloat(this.height);
        }

        protected ViewAttrs(Parcel in) {
            this.id = in.readInt();
            this.startX = in.readFloat();
            this.startY = in.readFloat();
            this.width = in.readFloat();
            this.height = in.readFloat();
        }
    }
}

