/*
 * Decompiled with CFR 0.152.
 */
package com.android.iplayer.utils;

import android.os.Handler;
import android.os.Looper;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPool {
    private static volatile ThreadPool mInstance;
    private ExecutorService mCachedThreadPool;
    private static final int CPU_COUNT;
    private static final int CORE_POOL_SIZE;
    private static final int THREAD_KEEP_LIVE_TIME = 30;
    private static final int TASK_QUEUE_MAX_COUNT = 128;
    private ThreadPoolExecutor mThreadPoolExecutor = new ThreadPoolExecutor(CORE_POOL_SIZE, CORE_POOL_SIZE, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(128));
    public Handler mMainHandler = new Handler(Looper.getMainLooper());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized ThreadPool getInstance() {
        Class<ThreadPool> clazz = ThreadPool.class;
        synchronized (ThreadPool.class) {
            if (null == mInstance) {
                mInstance = new ThreadPool();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void run(Runnable runnable) {
        if (null == this.mCachedThreadPool) {
            this.mCachedThreadPool = Executors.newSingleThreadExecutor();
        }
        this.mCachedThreadPool.execute(runnable);
    }

    public void stop() {
        try {
            if (null != this.mCachedThreadPool) {
                this.mCachedThreadPool.shutdown();
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public void reset() {
        try {
            if (null != this.mMainHandler) {
                this.mMainHandler.removeCallbacksAndMessages(null);
            }
            if (null != this.mCachedThreadPool) {
                this.mCachedThreadPool.shutdown();
                this.mCachedThreadPool = null;
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public void runOnThreadPool(Runnable runnable) {
        this.mThreadPoolExecutor.execute(runnable);
    }

    public void runOnUIThread(Runnable runnable) {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            runnable.run();
        } else {
            this.mMainHandler.post(runnable);
        }
    }

    public void runOnUIThreadByThreadPool(final Runnable runnable) {
        if (null == runnable) {
            return;
        }
        this.mThreadPoolExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ThreadPool.this.mMainHandler.post(runnable);
            }
        });
    }

    public <T> Future<T> runOnThreadPool(Callable<T> callable) {
        return this.mThreadPoolExecutor.submit(callable);
    }

    static {
        CPU_COUNT = Runtime.getRuntime().availableProcessors();
        CORE_POOL_SIZE = Math.max(CPU_COUNT, 5);
    }
}

