/*
 * Decompiled with CFR 0.152.
 */
package com.android.iplayer.widget.controls;

import android.content.Context;
import android.view.View;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.android.iplayer.R;
import com.android.iplayer.base.BaseControlWidget;
import com.android.iplayer.model.PlayerState;
import com.android.iplayer.utils.AnimationUtils;
import com.android.iplayer.utils.PlayerUtils;
import com.android.iplayer.widget.view.BatteryView;

public class ControlToolBarView
extends BaseControlWidget
implements View.OnClickListener {
    private View mController;
    private boolean showBack;
    private boolean showTv;
    private boolean showWindow;
    private boolean showMenu;
    private OnToolBarActionListener mOnToolBarActionListener;

    public ControlToolBarView(Context context) {
        super(context);
    }

    @Override
    public int getLayoutId() {
        return R.layout.player_control_toolar;
    }

    @Override
    public void initViews() {
        this.hide();
        this.findViewById(R.id.controller_title_back).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.controller_title_tv).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.controller_title_window).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.controller_title_menu).setOnClickListener((View.OnClickListener)this);
        this.mController = this.findViewById(R.id.controller_title_bar);
    }

    public void onClick(View view) {
        if (view.getId() == R.id.controller_title_back) {
            if (null != this.mControlWrapper) {
                if (this.mControlWrapper.isOrientationPortrait()) {
                    if (null != this.mOnToolBarActionListener) {
                        this.mOnToolBarActionListener.onBack();
                    }
                } else {
                    this.mControlWrapper.quitFullScreen();
                }
            }
        } else if (view.getId() == R.id.controller_title_tv) {
            this.reStartDelayedRunnable();
            if (null != this.mOnToolBarActionListener) {
                this.mOnToolBarActionListener.onTv();
            }
        } else if (view.getId() == R.id.controller_title_window) {
            this.reStartDelayedRunnable();
            if (null != this.mOnToolBarActionListener) {
                this.mOnToolBarActionListener.onWindow();
            }
        } else if (view.getId() == R.id.controller_title_menu) {
            this.reStartDelayedRunnable();
            if (null != this.mOnToolBarActionListener) {
                this.mOnToolBarActionListener.onMenu();
            }
        }
    }

    @Override
    public void showControl(boolean isAnimation) {
        if (null != this.mController && this.mController.getVisibility() != 0) {
            if (isAnimation) {
                AnimationUtils.getInstance().startTranslateTopToLocat(this.mController, this.getAnimationDuration(), null);
            } else {
                this.mController.setVisibility(0);
            }
        }
    }

    @Override
    public void hideControl(boolean isAnimation) {
        if (null != this.mController && this.mController.getVisibility() != 8) {
            if (isAnimation) {
                AnimationUtils.getInstance().startTranslateLocatToTop(this.mController, this.getAnimationDuration(), new AnimationUtils.OnAnimationListener(){

                    @Override
                    public void onAnimationEnd(Animation animation) {
                        ControlToolBarView.this.mController.setVisibility(8);
                    }
                });
            } else {
                this.mController.setVisibility(8);
            }
        }
    }

    @Override
    public void onPlayerState(PlayerState state, String message) {
        switch (state) {
            case STATE_RESET: 
            case STATE_STOP: {
                this.onReset();
                break;
            }
            case STATE_START: {
                if (this.isNoimalScene()) {
                    this.show();
                }
                this.showControl(true);
                break;
            }
            case STATE_PREPARE: {
                this.hide();
            }
        }
    }

    @Override
    public void onOrientation(int direction) {
        if (null == this.mController) {
            return;
        }
        if (1 == direction) {
            this.show();
            this.findViewById(R.id.controller_title).setVisibility(0);
            this.findViewById(R.id.controller_title_back).setVisibility(0);
            this.findViewById(R.id.controller_title_tv).setVisibility(8);
            this.findViewById(R.id.controller_title_window).setVisibility(8);
            this.findViewById(R.id.controller_title_menu).setVisibility(8);
            FrameLayout controllerBattery = (FrameLayout)this.findViewById(R.id.controller_battery);
            controllerBattery.setVisibility(0);
            controllerBattery.addView((View)new BatteryView(this.getContext()));
            int margin = PlayerUtils.getInstance().dpToPxInt(22.0f);
            this.mController.setPadding(margin, 0, margin, 0);
            if (this.isPlaying()) {
                this.reStartDelayedRunnable();
            }
        } else {
            this.findViewById(R.id.controller_title).setVisibility(8);
            this.findViewById(R.id.controller_title_back).setVisibility(this.showBack ? 0 : 8);
            this.findViewById(R.id.controller_title_tv).setVisibility(this.showTv ? 0 : 8);
            this.findViewById(R.id.controller_title_window).setVisibility(this.showWindow ? 0 : 8);
            this.findViewById(R.id.controller_title_menu).setVisibility(this.showMenu ? 0 : 8);
            FrameLayout controllerBattery = (FrameLayout)this.findViewById(R.id.controller_battery);
            controllerBattery.removeAllViews();
            controllerBattery.setVisibility(8);
            this.mController.setPadding(0, 0, 0, 0);
            if (this.isNoimalScene()) {
                this.show();
            } else {
                this.hide();
            }
        }
    }

    @Override
    public void onPlayerScene(int playerScene) {
        if (this.isNoimalScene()) {
            this.show();
            if (this.isPlaying()) {
                this.showControl(false);
                this.reStartDelayedRunnable();
            }
        } else {
            this.hide();
        }
    }

    @Override
    public void setTitle(String title) {
        ((TextView)this.findViewById(R.id.controller_title)).setText((CharSequence)PlayerUtils.getInstance().formatHtml(title));
    }

    public void showBack(boolean showBack) {
        this.showBack = showBack;
        this.findViewById(R.id.controller_title_back).setVisibility(this.isOrientationLandscape() ? 0 : (showBack ? 0 : 8));
    }

    public void showMenus(boolean showTv, boolean showWindow, boolean showMenu) {
        this.showTv = showTv;
        this.showWindow = showWindow;
        this.showMenu = showMenu;
        this.findViewById(R.id.controller_title_tv).setVisibility(this.isOrientationLandscape() ? 8 : (showTv ? 0 : 8));
        this.findViewById(R.id.controller_title_window).setVisibility(this.isOrientationLandscape() ? 8 : (showWindow ? 0 : 8));
        this.findViewById(R.id.controller_title_menu).setVisibility(this.isOrientationLandscape() ? 8 : (showMenu ? 0 : 8));
    }

    public void setOnToolBarActionListener(OnToolBarActionListener onToolBarActionListener) {
        this.mOnToolBarActionListener = onToolBarActionListener;
    }

    @Override
    public void onReset() {
        super.onReset();
        this.hideControl(false);
    }

    public static abstract class OnToolBarActionListener {
        public void onBack() {
        }

        public void onTv() {
        }

        public void onWindow() {
        }

        public void onMenu() {
        }
    }
}

