/*
 * Decompiled with CFR 0.152.
 */
package com.android.iplayer.utils;

import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;

public class AnimationUtils {
    private static final String TAG = "AnimationUtils";
    private static AnimationUtils mInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized AnimationUtils getInstance() {
        Class<AnimationUtils> clazz = AnimationUtils.class;
        synchronized (AnimationUtils.class) {
            if (null == mInstance) {
                mInstance = new AnimationUtils();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void startTranslateLocatToLeft(View targetView, long durationMillis, OnAnimationListener listener) {
        this.startTranslateAnimation(targetView, 0, false, durationMillis, listener);
    }

    public void startTranslateLeftToLocat(View targetView, long durationMillis, OnAnimationListener listener) {
        this.startTranslateAnimation(targetView, 0, true, durationMillis, listener);
    }

    public void startTranslateLocatToTop(View targetView, long durationMillis, OnAnimationListener listener) {
        this.startTranslateAnimation(targetView, 1, false, durationMillis, listener);
    }

    public void startTranslateTopToLocat(View targetView, long durationMillis, OnAnimationListener listener) {
        this.startTranslateAnimation(targetView, 1, true, durationMillis, listener);
    }

    public void startTranslateLocatToRight(View targetView, long durationMillis, OnAnimationListener listener) {
        this.startTranslateAnimation(targetView, 2, false, durationMillis, listener);
    }

    public void startTranslateRightToLocat(View targetView, long durationMillis, OnAnimationListener listener) {
        this.startTranslateAnimation(targetView, 2, true, durationMillis, listener);
    }

    public void startTranslateLocatToBottom(View targetView, long durationMillis, OnAnimationListener listener) {
        this.startTranslateAnimation(targetView, 3, false, durationMillis, listener);
    }

    public void startTranslateBottomToLocat(View targetView, long durationMillis, OnAnimationListener listener) {
        this.startTranslateAnimation(targetView, 3, true, durationMillis, listener);
    }

    private void startTranslateAnimation(View targetView, int direction, boolean motion, long durationMillis, OnAnimationListener listener) {
        if (null == targetView) {
            if (null != listener) {
                listener.onAnimationEnd(null);
            }
            return;
        }
        new TranslateYAnimation().startTranslateAnimation(targetView, direction, motion, durationMillis, listener);
    }

    private TranslateAnimation moveFormLocatToLeft() {
        TranslateAnimation animation = new TranslateAnimation(1, 0.0f, 1, -1.0f, 1, 0.0f, 1, 0.0f);
        return animation;
    }

    private TranslateAnimation moveFormLeftToLocat() {
        TranslateAnimation animation = new TranslateAnimation(1, -1.0f, 1, 0.0f, 1, 0.0f, 1, 0.0f);
        return animation;
    }

    private TranslateAnimation moveFromLocatToTop() {
        TranslateAnimation animation = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 0.0f, 1, -1.0f);
        return animation;
    }

    private TranslateAnimation moveFormTopToLocat() {
        TranslateAnimation animation = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, -1.0f, 1, 0.0f);
        return animation;
    }

    private TranslateAnimation moveFormLocatToRight() {
        TranslateAnimation animation = new TranslateAnimation(1, 0.0f, 1, 1.0f, 1, 0.0f, 1, 0.0f);
        return animation;
    }

    private TranslateAnimation moveFormRightToLocat() {
        TranslateAnimation animation = new TranslateAnimation(1, 1.0f, 1, 0.0f, 1, 0.0f, 1, 0.0f);
        return animation;
    }

    private TranslateAnimation moveFormLocatToBottom() {
        TranslateAnimation animation = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 0.0f, 1, 1.0f);
        return animation;
    }

    private TranslateAnimation moveFormBottomToLocat() {
        TranslateAnimation animation = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 1.0f, 1, 0.0f);
        return animation;
    }

    public void startAlphaAnimatioTo(View view, long duration, boolean isFillAfter, OnAnimationListener listener) {
        if (null == view) {
            return;
        }
        new AnimationTask().start(view, duration, isFillAfter, listener);
    }

    public void startAlphaAnimatioFrom(View view, long duration, boolean isFillAfter, OnAnimationListener listener) {
        if (null == view) {
            return;
        }
        new AnimationTaskFrom().start(view, duration, isFillAfter, listener);
    }

    private class AnimationTaskFrom {
        private View mView;
        private OnAnimationListener mOnAnimationListener;

        private AnimationTaskFrom() {
        }

        public void start(View view, long duration, boolean isFillAfter, OnAnimationListener listener) {
            this.mView = view;
            this.mOnAnimationListener = listener;
            this.mView.setVisibility(0);
            AlphaAnimation alphaAnim = new AlphaAnimation(0.0f, 1.0f);
            alphaAnim.setDuration(duration);
            alphaAnim.setFillAfter(isFillAfter);
            alphaAnim.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    if (null != AnimationTaskFrom.this.mOnAnimationListener) {
                        AnimationTaskFrom.this.mOnAnimationListener.onAnimationEnd(animation);
                    }
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            this.mView.startAnimation((Animation)alphaAnim);
        }
    }

    private class AnimationTask {
        private View mView;
        private OnAnimationListener mOnAnimationListener;

        private AnimationTask() {
        }

        public void start(View view, long duration, boolean isFillAfter, OnAnimationListener listener) {
            this.mView = view;
            this.mOnAnimationListener = listener;
            AlphaAnimation alphaAnim = new AlphaAnimation(1.0f, 0.0f);
            alphaAnim.setDuration(duration);
            alphaAnim.setFillAfter(isFillAfter);
            alphaAnim.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    if (null != AnimationTask.this.mOnAnimationListener) {
                        AnimationTask.this.mOnAnimationListener.onAnimationEnd(animation);
                    }
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            this.mView.startAnimation((Animation)alphaAnim);
        }
    }

    private class TranslateYAnimation {
        private View mTargetView;
        private OnAnimationListener mOnAnimationListener;

        private TranslateYAnimation() {
        }

        public void startTranslateAnimation(View targetView, int direction, boolean motion, long durationMillis, OnAnimationListener listener) {
            this.mTargetView = targetView;
            this.mOnAnimationListener = listener;
            TranslateAnimation animation = null;
            switch (direction) {
                case 0: {
                    if (motion) {
                        animation = AnimationUtils.this.moveFormLeftToLocat();
                        break;
                    }
                    animation = AnimationUtils.this.moveFormLocatToLeft();
                    break;
                }
                case 1: {
                    if (motion) {
                        animation = AnimationUtils.this.moveFormTopToLocat();
                        break;
                    }
                    animation = AnimationUtils.this.moveFromLocatToTop();
                    break;
                }
                case 2: {
                    if (motion) {
                        animation = AnimationUtils.this.moveFormRightToLocat();
                        break;
                    }
                    animation = AnimationUtils.this.moveFormLocatToRight();
                    break;
                }
                case 3: {
                    animation = motion ? AnimationUtils.this.moveFormBottomToLocat() : AnimationUtils.this.moveFormLocatToBottom();
                }
            }
            if (null != animation) {
                animation.setDuration(durationMillis);
                animation.setAnimationListener(new Animation.AnimationListener(){

                    public void onAnimationStart(Animation animation) {
                    }

                    public void onAnimationEnd(Animation animation) {
                        if (null != TranslateYAnimation.this.mOnAnimationListener) {
                            TranslateYAnimation.this.mOnAnimationListener.onAnimationEnd(animation);
                        }
                    }

                    public void onAnimationRepeat(Animation animation) {
                    }
                });
                this.mTargetView.setVisibility(0);
                this.mTargetView.startAnimation((Animation)animation);
            } else if (null != this.mOnAnimationListener) {
                this.mOnAnimationListener.onAnimationEnd(null);
            }
        }
    }

    public static interface OnAnimationListener {
        public void onAnimationEnd(Animation var1);
    }
}

