/*
 * Decompiled with CFR 0.152.
 */
package com.android.iplayer.base;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetFileDescriptor;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.Toast;
import com.android.iplayer.R;
import com.android.iplayer.base.AbstractMediaPlayer;
import com.android.iplayer.base.BaseController;
import com.android.iplayer.controller.VideoController;
import com.android.iplayer.interfaces.IMediaPlayerControl;
import com.android.iplayer.interfaces.IVideoPlayerControl;
import com.android.iplayer.interfaces.IVideoRenderView;
import com.android.iplayer.listener.OnPlayerEventListener;
import com.android.iplayer.listener.OnWindowActionListener;
import com.android.iplayer.manager.IVideoManager;
import com.android.iplayer.manager.IWindowManager;
import com.android.iplayer.media.IVideoPlayer;
import com.android.iplayer.model.PlayerState;
import com.android.iplayer.utils.ILogger;
import com.android.iplayer.utils.PlayerUtils;
import com.android.iplayer.widget.view.WindowPlayerFloatView;

public abstract class BasePlayer
extends FrameLayout
implements IVideoPlayerControl,
IMediaPlayerControl {
    protected static final String TAG = BasePlayer.class.getSimpleName();
    private BaseController mController;
    protected OnPlayerEventListener mOnPlayerActionListener;
    private int mScreenOrientation = 0;
    private String mDataSource;
    private AssetFileDescriptor mAssetsSource;
    private ViewGroup mParent;
    private int[] mPlayerParams;
    private IVideoPlayer mIVideoPlayer;
    private boolean mIsActivityWindow;
    private boolean mIsGlobalWindow;
    private boolean mContinuityPlay;
    private boolean mRestoreDirection = true;
    private Context mParentContext;

    public BasePlayer(Context context) {
        this(context, null);
    }

    public BasePlayer(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BasePlayer(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        View.inflate((Context)context, (int)R.layout.player_base_video, (ViewGroup)this);
        if (null != attrs) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.BasePlayer);
            boolean createController = typedArray.getBoolean(R.styleable.BasePlayer_initController, false);
            if (createController) {
                this.setController(new VideoController(context));
            }
            typedArray.recycle();
        }
        this.mIVideoPlayer = new IVideoPlayer();
        this.mIVideoPlayer.setIMediaPlayerControl(this);
        this.initViews();
    }

    protected abstract void initViews();

    private void setScreenOrientation(int orientation) {
        this.mScreenOrientation = orientation;
        if (null != this.mController) {
            this.mController.onScreenOrientation(orientation);
        }
    }

    private void setWindowPropertyPlayer(boolean isActivityWindow, boolean isGlobalWindow) {
        this.mIsActivityWindow = isActivityWindow;
        this.mIsGlobalWindow = isGlobalWindow;
        if (null != this.mController) {
            this.mController.setWindowPropertyPlayer(isActivityWindow, isGlobalWindow);
        }
    }

    public boolean isActivityWindow() {
        return this.mIsActivityWindow;
    }

    public boolean isGlobalWindow() {
        return this.mIsGlobalWindow;
    }

    private void hideSystemBar(ViewGroup decorView) {
        Activity activity = PlayerUtils.getInstance().getActivity(this.getTargetContext());
        if (null != activity && !activity.isFinishing()) {
            int uiOptions = decorView.getSystemUiVisibility();
            if (Build.VERSION.SDK_INT >= 16) {
                uiOptions |= 2;
            }
            if (Build.VERSION.SDK_INT >= 19) {
                uiOptions |= 0x1000;
            }
            decorView.setSystemUiVisibility(uiOptions);
            activity.getWindow().setFlags(1024, 1024);
        }
    }

    private void showSysBar(ViewGroup decorView) {
        Activity activity = PlayerUtils.getInstance().getActivity(this.getTargetContext());
        if (null != activity && !activity.isFinishing()) {
            int uiOptions = decorView.getSystemUiVisibility();
            if (Build.VERSION.SDK_INT >= 16) {
                uiOptions &= 0xFFFFFFFD;
            }
            if (Build.VERSION.SDK_INT >= 19) {
                uiOptions &= 0xFFFFEFFF;
            }
            decorView.setSystemUiVisibility(uiOptions);
            activity.getWindow().clearFlags(1024);
        }
    }

    private ViewGroup getDecorView() {
        Activity activity = PlayerUtils.getInstance().getActivity(this.getTargetContext());
        if (null != activity && !activity.isFinishing()) {
            ViewGroup viewGroup = (ViewGroup)activity.getWindow().getDecorView();
            return viewGroup;
        }
        return null;
    }

    private Context getTargetContext() {
        if (null != this.getParentContext()) {
            return this.getParentContext();
        }
        return this.getContext();
    }

    private Object getDataSource() {
        if (!TextUtils.isEmpty((CharSequence)this.mDataSource)) {
            return this.mDataSource;
        }
        if (null != this.mAssetsSource) {
            return this.mAssetsSource;
        }
        return null;
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus && this.mScreenOrientation == 1) {
            this.hideSystemBar(this.getDecorView());
        }
    }

    @Override
    public BasePlayer getVideoPlayer() {
        return this;
    }

    @Override
    public AbstractMediaPlayer getMediaPlayer() {
        if (null != this.mOnPlayerActionListener) {
            return this.mOnPlayerActionListener.createMediaPlayer();
        }
        return null;
    }

    @Override
    public IVideoRenderView getRenderView() {
        if (null != this.mOnPlayerActionListener) {
            return this.mOnPlayerActionListener.createRenderView();
        }
        return null;
    }

    @Override
    public void onPlayerState(PlayerState state, String message) {
        ILogger.d(TAG, "onPlayerState-->state:" + (Object)((Object)state) + ",message:" + message);
        if (null != this.mIVideoPlayer) {
            this.setKeepScreenOn(this.mIVideoPlayer.isPlaying());
        }
        if (state == PlayerState.STATE_COMPLETION && this.mRestoreDirection && !this.mContinuityPlay && this.mScreenOrientation == 1) {
            this.quitFullScreen();
        }
        PlayerState tempState = state;
        String tempMessage = message;
        if (null != this.mController) {
            this.mController.onPlayerState(tempState, tempMessage);
        }
        if (null != this.mOnPlayerActionListener) {
            this.mOnPlayerActionListener.onPlayerState(tempState, tempMessage);
        }
    }

    @Override
    public void onBuffer(int percent) {
        if (null != this.mController) {
            this.mController.onBuffer(percent);
        }
    }

    @Override
    public void onVideoSizeChanged(int width, int height) {
        if (null != this.mOnPlayerActionListener) {
            this.mOnPlayerActionListener.onVideoSizeChanged(width, height);
        }
    }

    @Override
    public void onProgress(long currentDurtion, long totalDurtion) {
        if (null != this.mController) {
            this.mController.onProgress(currentDurtion, totalDurtion);
        }
        if (null != this.mOnPlayerActionListener) {
            this.mOnPlayerActionListener.onProgress(currentDurtion, totalDurtion);
        }
    }

    @Override
    public void setLoop(boolean loop) {
        if (null != this.mIVideoPlayer) {
            this.mIVideoPlayer.setLoop(loop);
        }
    }

    @Override
    public void setProgressCallBackSpaceMilliss(int callBackSpaceMilliss) {
        if (null != this.mIVideoPlayer) {
            this.mIVideoPlayer.setCallBackSpaceMilliss(callBackSpaceMilliss);
        }
    }

    @Override
    public void setOnPlayerActionListener(OnPlayerEventListener listener) {
        this.mOnPlayerActionListener = listener;
    }

    @Override
    public void setDataSource(String dataSource) {
        this.mDataSource = dataSource;
        this.mAssetsSource = null;
        if (null != this.mIVideoPlayer) {
            this.mIVideoPlayer.setDateSource(dataSource);
        }
    }

    @Override
    public void setDataSource(AssetFileDescriptor dataSource) {
        this.mAssetsSource = dataSource;
        this.mDataSource = null;
        if (null != this.mIVideoPlayer) {
            this.mIVideoPlayer.setDateSource(dataSource);
        }
    }

    @Override
    public void setZoomModel(int scaleModel) {
        if (null != this.mIVideoPlayer) {
            this.mIVideoPlayer.setZoomModel(scaleModel);
            if (null != this.mController) {
                this.mController.onZoomModel(scaleModel);
            }
        } else {
            IVideoManager.getInstance().setZoomModel(scaleModel);
        }
        if (null != this.mOnPlayerActionListener) {
            this.mOnPlayerActionListener.onZoomModel(scaleModel);
        }
    }

    @Override
    public void setDegree(int degree) {
        if (null != this.mIVideoPlayer) {
            this.mIVideoPlayer.setDegree(degree);
        }
    }

    @Override
    public void setSpeed(float speed) {
        if (null != this.mIVideoPlayer) {
            this.mIVideoPlayer.setSpeed(speed);
        }
    }

    @Override
    public boolean setSoundMute(boolean mute) {
        if (null != this.mIVideoPlayer) {
            boolean soundMute = this.mIVideoPlayer.setSoundMute(mute);
            if (null != this.mController) {
                this.mController.onMute(soundMute);
            }
            if (null != this.mOnPlayerActionListener) {
                this.mOnPlayerActionListener.onMute(soundMute);
            }
            return soundMute;
        }
        return false;
    }

    @Override
    public boolean isSoundMute() {
        if (null != this.mIVideoPlayer) {
            return this.mIVideoPlayer.isSoundMute();
        }
        return false;
    }

    @Override
    public boolean toggleMute() {
        if (null != this.mIVideoPlayer) {
            boolean mute = this.mIVideoPlayer.toggleMute();
            if (null != this.mController) {
                this.mController.onMute(mute);
            }
            if (null != this.mOnPlayerActionListener) {
                this.mOnPlayerActionListener.onMute(mute);
            }
            return mute;
        }
        return false;
    }

    @Override
    public boolean setMirror(boolean mirror) {
        if (null != this.mIVideoPlayer) {
            boolean isMirror = this.mIVideoPlayer.setMirror(mirror);
            if (null != this.mController) {
                this.mController.onMirror(isMirror);
            }
            if (null != this.mOnPlayerActionListener) {
                this.mOnPlayerActionListener.onMirror(isMirror);
            }
            return isMirror;
        }
        return false;
    }

    @Override
    public boolean toggleMirror() {
        if (null != this.mIVideoPlayer) {
            boolean isMirror = this.mIVideoPlayer.toggleMirror();
            if (null != this.mController) {
                this.mController.onMirror(isMirror);
            }
            if (null != this.mOnPlayerActionListener) {
                this.mOnPlayerActionListener.onMirror(isMirror);
            }
            return isMirror;
        }
        return false;
    }

    @Override
    public void setPlayCompletionRestoreDirection(boolean restoreDirection) {
        this.mRestoreDirection = restoreDirection;
    }

    @Override
    public void setMobileNetwork(boolean mobileNetwork) {
        if (null != this.mIVideoPlayer) {
            this.mIVideoPlayer.setMobileNetwork(mobileNetwork);
        }
    }

    @Override
    public void setInterceptTAudioFocus(boolean interceptTAudioFocus) {
        if (null != this.mIVideoPlayer) {
            this.mIVideoPlayer.setInterceptTAudioFocus(interceptTAudioFocus);
        } else {
            IVideoManager.getInstance().setInterceptTAudioFocus(interceptTAudioFocus);
        }
    }

    @Override
    public void prepareAsync() {
        this.togglePlay();
    }

    @Override
    public void startPlay() {
        this.togglePlay();
    }

    @Override
    public void play() {
        this.togglePlay();
    }

    @Override
    public void pause() {
        this.togglePlay();
    }

    @Override
    public void rePlay() {
        this.togglePlay();
    }

    @Override
    public void togglePlay() {
        this.playOrPause();
    }

    @Override
    public void playOrPause() {
        this.playOrPause(this.getDataSource());
    }

    @Override
    public void playOrPause(Object dataSource) {
        if (null != this.mIVideoPlayer) {
            this.mIVideoPlayer.playOrPause(dataSource);
        }
    }

    @Override
    public void startFullScreen() {
        this.startFullScreen(Color.parseColor((String)"#000000"));
    }

    @Override
    public void startFullScreen(int bgColor) {
        if (this.mScreenOrientation == 1) {
            return;
        }
        Activity activity = PlayerUtils.getInstance().getActivity(this.getTargetContext());
        if (null != activity && !activity.isFinishing()) {
            ViewGroup viewGroup = (ViewGroup)activity.getWindow().getDecorView();
            if (null == viewGroup) {
                return;
            }
            this.mPlayerParams = new int[3];
            this.mPlayerParams[0] = this.getMeasuredWidth();
            this.mPlayerParams[1] = this.getMeasuredHeight();
            if (null != this.getParent() && this.getParent() instanceof ViewGroup) {
                this.mParent = (ViewGroup)this.getParent();
                this.mPlayerParams[2] = this.mParent.indexOfChild((View)this);
            }
            PlayerUtils.getInstance().removeViewFromParent((View)this);
            activity.setRequestedOrientation(6);
            this.setScreenOrientation(1);
            this.findViewById(R.id.player_surface).setBackgroundColor(bgColor != 0 ? bgColor : Color.parseColor((String)"#000000"));
            this.hideSystemBar(viewGroup);
            viewGroup.addView((View)this, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
        }
    }

    @Override
    public void quitFullScreen() {
        Activity activity = PlayerUtils.getInstance().getActivity(this.getTargetContext());
        if (null != activity && !activity.isFinishing()) {
            ViewGroup viewGroup = (ViewGroup)activity.getWindow().getDecorView();
            if (null == viewGroup) {
                return;
            }
            PlayerUtils.getInstance().removeViewFromParent((View)this);
            activity.setRequestedOrientation(1);
            this.setScreenOrientation(0);
            this.findViewById(R.id.player_surface).setBackgroundColor(Color.parseColor((String)"#00000000"));
            this.showSysBar(viewGroup);
            if (null != this.mParent) {
                if (null != this.mPlayerParams && this.mPlayerParams.length > 0) {
                    this.mParent.addView((View)this, this.mPlayerParams[2], (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.mPlayerParams[0], this.mPlayerParams[1]));
                } else {
                    this.mParent.addView((View)this, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                }
            } else {
                this.onDestroy();
            }
        }
    }

    @Override
    public void toggleFullScreen() {
        if (this.mScreenOrientation == 1) {
            this.quitFullScreen();
            return;
        }
        if (null != this.mIVideoPlayer && !this.mIVideoPlayer.isWork()) {
            return;
        }
        this.startFullScreen();
    }

    @Override
    public void startWindow() {
        this.startWindow(0, 0, 0.0f, 0.0f);
    }

    @Override
    public void startWindow(float radius, int bgColor) {
        this.startWindow(0, 0, 0.0f, 0.0f, radius, bgColor);
    }

    @Override
    public void startWindow(int width, int height, float startX, float startY) {
        this.startWindow(width, height, startX, startY, 0.0f);
    }

    @Override
    public void startWindow(int width, int height, float startX, float startY, float radius) {
        this.startWindow(width, height, startX, startY, radius, Color.parseColor((String)"#99000000"));
    }

    @Override
    public void startWindow(int width, int height, float startX, float startY, float radius, int bgColor) {
        ILogger.d(TAG, "startWindow-->width:" + width + ",height:" + height + ",startX:" + startX + ",startY:" + startY + ",radius:" + radius + ",bgColor:" + bgColor + ",windowProperty:" + this.mIsActivityWindow + ",screenOrientation:" + this.mScreenOrientation);
        if (this.mIsActivityWindow || this.mScreenOrientation == 1) {
            return;
        }
        Activity activity = PlayerUtils.getInstance().getActivity(this.getTargetContext());
        if (null != activity && !activity.isFinishing()) {
            ViewGroup viewGroup = (ViewGroup)activity.getWindow().getDecorView();
            if (null == viewGroup) {
                return;
            }
            int[] screenLocation = new int[2];
            this.mPlayerParams = new int[3];
            this.mPlayerParams[0] = this.getMeasuredWidth();
            this.mPlayerParams[1] = this.getMeasuredHeight();
            if (null != this.getParent() && this.getParent() instanceof ViewGroup) {
                this.mParent = (ViewGroup)this.getParent();
                this.mParent.getLocationInWindow(screenLocation);
                this.mPlayerParams[2] = this.mParent.indexOfChild((View)this);
            }
            PlayerUtils.getInstance().removeViewFromParent((View)this);
            this.setWindowPropertyPlayer(true, false);
            if (width <= 0) {
                width = PlayerUtils.getInstance().getScreenWidth(this.getContext()) / 2 + PlayerUtils.getInstance().dpToPxInt(30.0f);
                height = width * 9 / 16;
            }
            if (startX <= 0.0f && null != this.mParent) {
                startX = PlayerUtils.getInstance().getScreenWidth(this.getContext()) / 2 - PlayerUtils.getInstance().dpToPxInt(30.0f) - PlayerUtils.getInstance().dpToPxInt(15.0f);
                startY = screenLocation[1] + this.mParent.getHeight() + PlayerUtils.getInstance().dpToPxInt(15.0f);
            }
            if (startX <= 0.0f) {
                startX = PlayerUtils.getInstance().getScreenWidth(this.getContext()) / 2 - PlayerUtils.getInstance().dpToPxInt(30.0f) - PlayerUtils.getInstance().dpToPxInt(15.0f);
                startY = PlayerUtils.getInstance().dpToPxInt(60.0f);
            }
            ILogger.d(TAG, "startWindow-->final:width:" + width + ",height:" + height + ",startX:" + startX + ",startY:" + startY);
            WindowPlayerFloatView container = new WindowPlayerFloatView(viewGroup.getContext());
            container.setOnWindowActionListener(new OnWindowActionListener(){

                @Override
                public void onMovie(float x, float y) {
                }

                @Override
                public void onClick(BasePlayer basePlayer, Object coustomParams) {
                }

                @Override
                public void onClose() {
                    BasePlayer.this.quitWindow();
                }
            });
            container.setId(R.id.player_window);
            container.addPlayerView(this, width, height, startX, startY, radius, bgColor);
            viewGroup.addView((View)container, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
        }
    }

    @Override
    public void quitWindow() {
        Activity activity = PlayerUtils.getInstance().getActivity(this.getTargetContext());
        if (null != activity && !activity.isFinishing()) {
            ViewGroup viewGroup = (ViewGroup)activity.getWindow().getDecorView();
            if (null == viewGroup) {
                return;
            }
            View playerView = viewGroup.findViewById(R.id.player_window);
            PlayerUtils.getInstance().removeViewFromParent(playerView);
            PlayerUtils.getInstance().removeViewFromParent((View)this);
            this.setWindowPropertyPlayer(false, false);
            if (null != this.mParent) {
                if (null != this.mPlayerParams && this.mPlayerParams.length > 0) {
                    this.mParent.addView((View)this, this.mPlayerParams[2], (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.mPlayerParams[0], this.mPlayerParams[1]));
                } else {
                    this.mParent.addView((View)this, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                }
            } else {
                this.onDestroy();
            }
        }
    }

    @Override
    public void toggleWindow() {
        if (this.mIsActivityWindow) {
            this.quitWindow();
            return;
        }
        if (null != this.mIVideoPlayer && !this.mIVideoPlayer.isWork()) {
            return;
        }
        this.startWindow();
    }

    @Override
    public boolean startGlobalWindow() {
        return this.startGlobalWindow(0, 0, 0.0f, 0.0f);
    }

    @Override
    public boolean startGlobalWindow(float radius, int bgColor) {
        return this.startGlobalWindow(0, 0, 0.0f, 0.0f, radius, bgColor);
    }

    @Override
    public boolean startGlobalWindow(int width, int height, float startX, float startY) {
        return this.startGlobalWindow(width, height, startX, startY, 0.0f);
    }

    @Override
    public boolean startGlobalWindow(int width, int height, float startX, float startY, float radius) {
        return this.startGlobalWindow(width, height, startX, startY, radius, Color.parseColor((String)"#99000000"));
    }

    @Override
    public boolean startGlobalWindow(int width, int height, float startX, float startY, float radius, int bgColor) {
        ILogger.d(TAG, "startGlobalWindow-->width:" + width + ",height:" + height + ",startX:" + startX + ",startY:" + startY + ",radius:" + radius + ",bgColor:" + bgColor + ",screenOrientation:" + this.mScreenOrientation);
        if (this.mScreenOrientation == 1) {
            return false;
        }
        boolean existPermission = PlayerUtils.getInstance().existPermission(this.getContext(), "android.permission.SYSTEM_ALERT_WINDOW");
        boolean hasPermission = PlayerUtils.getInstance().checkWindowsPermission(this.getContext());
        if (!existPermission) {
            Toast.makeText((Context)this.getContext(), (CharSequence)this.getContext().getResources().getString(R.string.player_window_permission), (int)0).show();
            return false;
        }
        if (hasPermission) {
            Activity activity = PlayerUtils.getInstance().getActivity(this.getTargetContext());
            if (null != activity && !activity.isFinishing()) {
                try {
                    int[] screenLocation = new int[2];
                    ViewGroup parent = null;
                    if (null != this.getParent() && this.getParent() instanceof ViewGroup) {
                        parent = (ViewGroup)this.getParent();
                        parent.getLocationInWindow(screenLocation);
                    }
                    PlayerUtils.getInstance().removeViewFromParent((View)this);
                    if (width <= 0) {
                        width = PlayerUtils.getInstance().getScreenWidth(this.getContext()) / 2 + PlayerUtils.getInstance().dpToPxInt(30.0f);
                        height = width * 9 / 16;
                    }
                    if (startX <= 0.0f && null != parent) {
                        startX = PlayerUtils.getInstance().getScreenWidth(this.getContext()) / 2 - PlayerUtils.getInstance().dpToPxInt(30.0f) - PlayerUtils.getInstance().dpToPxInt(15.0f);
                        startY = screenLocation[1] + parent.getHeight() + PlayerUtils.getInstance().dpToPxInt(15.0f);
                    }
                    if (startX <= 0.0f) {
                        startX = PlayerUtils.getInstance().getScreenWidth(this.getContext()) / 2 - PlayerUtils.getInstance().dpToPxInt(30.0f) - PlayerUtils.getInstance().dpToPxInt(15.0f);
                        startY = PlayerUtils.getInstance().dpToPxInt(60.0f);
                    }
                    ILogger.d(TAG, "startGlobalWindow-->final:width:" + width + ",height:" + height + ",startX:" + startX + ",startY:" + startY);
                    boolean success = IWindowManager.getInstance().addGolbalWindow(this.getContext(), this, width, height, startX, startY, radius, bgColor);
                    if (success) {
                        this.setWindowPropertyPlayer(false, true);
                    }
                    return success;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        } else {
            try {
                Intent intent = new Intent();
                intent.addFlags(0x10000000);
                if (Build.VERSION.SDK_INT >= 23) {
                    intent.setAction("android.settings.action.MANAGE_OVERLAY_PERMISSION");
                    intent.setData(Uri.parse((String)("package:" + PlayerUtils.getInstance().getPackageName(this.getContext().getApplicationContext()))));
                } else {
                    intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
                    intent.setData(Uri.fromParts((String)"package", (String)PlayerUtils.getInstance().getPackageName(this.getContext().getApplicationContext()), null));
                }
                this.getContext().getApplicationContext().startActivity(intent);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public void quitGlobaWindow() {
        IWindowManager.getInstance().quitGlobaWindow();
        this.setWindowPropertyPlayer(false, false);
    }

    @Override
    public void toggleGlobaWindow() {
        if (this.mIsGlobalWindow) {
            this.quitGlobaWindow();
            return;
        }
        if (null != this.mIVideoPlayer && !this.mIVideoPlayer.isWork()) {
            return;
        }
        this.startGlobalWindow();
    }

    @Override
    public void enterPipWindow() {
        if (null != this.mController) {
            this.mController.enterPipWindow();
        }
    }

    @Override
    public void quitPipWindow() {
        if (null != this.mController) {
            this.mController.quitPipWindow();
        }
    }

    @Override
    public void onCompletion() {
        if (null != this.mIVideoPlayer) {
            this.mIVideoPlayer.onCompletion();
        }
    }

    @Override
    public void setContinuityPlay(boolean continuityPlay) {
        this.mContinuityPlay = continuityPlay;
    }

    @Override
    public int getVideoWidth() {
        if (null != this.mIVideoPlayer) {
            return this.mIVideoPlayer.getVideoWidth();
        }
        return 0;
    }

    @Override
    public int getVideoHeight() {
        if (null != this.mIVideoPlayer) {
            return this.mIVideoPlayer.getVideoHeight();
        }
        return 0;
    }

    @Override
    public long getDuration() {
        if (null != this.mIVideoPlayer) {
            return this.mIVideoPlayer.getDurtion();
        }
        return 0L;
    }

    @Override
    public long getCurrentPosition() {
        if (null != this.mIVideoPlayer) {
            return this.mIVideoPlayer.getCurrentPosition();
        }
        return 0L;
    }

    @Override
    public int getBuffer() {
        if (null != this.mIVideoPlayer) {
            return this.mIVideoPlayer.getBuffer();
        }
        return 0;
    }

    @Override
    public void setTimeout(int prepareTimeout, int readTimeout) {
        if (null != this.mIVideoPlayer) {
            this.mIVideoPlayer.setTimeout(prepareTimeout, readTimeout);
        }
    }

    @Override
    public void seekTo(long msec) {
        this.seekTo(msec, true);
    }

    @Override
    public void seekTo(long msec, boolean accurate) {
        if (null != this.mIVideoPlayer) {
            this.mIVideoPlayer.seekTo(msec, accurate);
        }
    }

    @Override
    public boolean isWorking() {
        if (null != this.mIVideoPlayer) {
            return this.mIVideoPlayer.isWork();
        }
        return false;
    }

    @Override
    public boolean isPlaying() {
        if (null != this.mIVideoPlayer) {
            return this.mIVideoPlayer.isPlaying();
        }
        return false;
    }

    @Override
    public void setParentContext(Context context) {
        this.mParentContext = context;
    }

    @Override
    public Context getParentContext() {
        return this.mParentContext;
    }

    public void setController(BaseController controller) {
        PlayerUtils.getInstance().removeViewFromParent((View)this.mController);
        this.mController = controller;
        PlayerUtils.getInstance().removeViewFromParent((View)controller);
        FrameLayout controllerView = (FrameLayout)this.findViewById(R.id.player_controller);
        if (null != controllerView) {
            controllerView.removeAllViews();
            if (null != this.mController) {
                this.mController.attachedPlayer(this);
                controllerView.addView((View)this.mController, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.mController.onCreate();
            }
        }
    }

    @Override
    public BaseController getController() {
        return this.mController;
    }

    @Override
    public boolean isBackPressed() {
        if (this.mScreenOrientation == 1) {
            this.quitFullScreen();
            return false;
        }
        if (this.mIsActivityWindow) {
            this.quitWindow();
            return false;
        }
        return true;
    }

    @Override
    public void onResume() {
        if (null != this.mController) {
            this.mController.onResume();
        }
        if (null != this.mIVideoPlayer) {
            this.mIVideoPlayer.onResume();
        }
    }

    @Override
    public void onPause() {
        if (null != this.mIVideoPlayer) {
            this.mIVideoPlayer.onPause();
        }
        if (null != this.mController) {
            this.mController.onResume();
        }
    }

    @Override
    public void onStop() {
        if (null != this.mIVideoPlayer) {
            this.mIVideoPlayer.onStop();
        }
    }

    @Override
    public void onRecover() {
        this.setScreenOrientation(0);
        this.setWindowPropertyPlayer(false, false);
    }

    @Override
    public void onReset() {
        this.mDataSource = null;
        this.mAssetsSource = null;
        if (null != this.mIVideoPlayer) {
            this.mIVideoPlayer.onReset();
        }
    }

    @Override
    public void onRelease() {
        this.onDestroy();
    }

    @Override
    public void onDestroy() {
        if (null != this.mController) {
            this.mController.onDestroy();
        }
        if (null != this.mIVideoPlayer) {
            this.mIVideoPlayer.onDestroy();
            this.mIVideoPlayer = null;
        }
        if (null != this.mParent) {
            this.mParent.removeAllViews();
            this.mParent = null;
        }
        this.mIsActivityWindow = false;
        this.mContinuityPlay = false;
        this.mDataSource = null;
        this.mAssetsSource = null;
        this.mOnPlayerActionListener = null;
        this.mScreenOrientation = 0;
    }
}

