/*
 * Decompiled with CFR 0.152.
 */
package com.android.iplayer.video.cache;

import android.content.Context;
import com.android.iplayer.video.cache.task.PreloadTask;
import com.danikula.videocache.HttpProxyCacheServer;
import com.danikula.videocache.StorageUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class VideoCache {
    private static volatile VideoCache mInstance;
    private HttpProxyCacheServer mCacheServer;
    private long mMaxSize = 0x20000000L;
    private File mCacheDirectory;
    private int mPreloadLength = 0x100000;
    private boolean mIsStartPreload = true;
    private ExecutorService mExecutorService = Executors.newSingleThreadExecutor();
    private LinkedHashMap<String, PreloadTask> mPreloadTasks = new LinkedHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized VideoCache getInstance() {
        Class<VideoCache> clazz = VideoCache.class;
        synchronized (VideoCache.class) {
            if (null == mInstance) {
                mInstance = new VideoCache();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private Context getThreadContext() {
        try {
            Class<?> ActivityThread = Class.forName("android.app.ActivityThread");
            Method method = ActivityThread.getMethod("currentActivityThread", new Class[0]);
            Object currentActivityThread = method.invoke(ActivityThread, new Object[0]);
            Method method2 = currentActivityThread.getClass().getMethod("getApplication", new Class[0]);
            return (Context)method2.invoke(currentActivityThread, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public VideoCache setCacheDirectory(File cacheDirectory) {
        this.mCacheDirectory = cacheDirectory;
        return mInstance;
    }

    public VideoCache setMaxSize(long maxSize) {
        this.mMaxSize = maxSize;
        return mInstance;
    }

    public VideoCache setPreloadLength(int preloadLength) {
        this.mPreloadLength = preloadLength;
        return mInstance;
    }

    public void initCache(Context context) {
        this.initCache(context, this.mMaxSize, this.mCacheDirectory);
    }

    public void initCache(Context context, long maxSize, File cacheDirectory) {
        if (null == this.mCacheServer) {
            this.mCacheDirectory = cacheDirectory;
            this.creatProxy(context, maxSize, cacheDirectory);
        }
    }

    private HttpProxyCacheServer creatProxy(Context context, long maxSize, File cacheDirectory) {
        return this.mCacheServer == null ? (this.mCacheServer = this.newProxy(context, maxSize, cacheDirectory)) : this.mCacheServer;
    }

    private HttpProxyCacheServer newProxy(Context context, long maxSize, File cacheDirectory) {
        if (null != cacheDirectory) {
            return new HttpProxyCacheServer.Builder(context).maxCacheSize(maxSize > 0L ? maxSize : 0x20000000L).cacheDirectory(cacheDirectory).build();
        }
        return new HttpProxyCacheServer.Builder(context).maxCacheSize(maxSize).build();
    }

    public HttpProxyCacheServer getProxy() {
        return this.creatProxy(this.getThreadContext(), this.mMaxSize, this.mCacheDirectory);
    }

    public boolean clearAllCache() {
        return StorageUtils.deleteFiles(this.getProxy().getCacheRoot());
    }

    public boolean clearDefaultCache(String rawUrl) {
        File pathTmp = this.getProxy().getTempCacheFile(rawUrl);
        File path = this.getProxy().getCacheFile(rawUrl);
        return StorageUtils.deleteFile(pathTmp.getAbsolutePath()) && StorageUtils.deleteFile(path.getAbsolutePath());
    }

    public String getPlayUrl(String rawUrl) {
        return this.getPlayUrl(null, rawUrl);
    }

    public String getPlayUrl(Context context, String rawUrl) {
        PreloadTask task;
        if (null == this.mCacheServer && null != context) {
            this.initCache(context);
        }
        if ((task = this.mPreloadTasks.get(rawUrl)) != null) {
            task.cancel();
        }
        return this.getProxy().getProxyUrl(rawUrl);
    }

    public void startPreloadTask(String rawUrl) {
        this.startPreloadTask(rawUrl, this.mPreloadLength);
    }

    public void startPreloadTask(String rawUrl, int preloadLength) {
        this.startPreloadTask(rawUrl, -1, preloadLength);
    }

    public void startPreloadTask(String rawUrl, int position, int preloadLength) {
        if (this.isPreloaded(rawUrl)) {
            return;
        }
        if (preloadLength > 0) {
            this.mPreloadLength = preloadLength;
        }
        PreloadTask task = new PreloadTask(rawUrl, position, preloadLength);
        this.mPreloadTasks.put(rawUrl, task);
        if (this.mIsStartPreload) {
            task.executeOn(this.mExecutorService);
        }
    }

    public boolean isPreloaded(String rawUrl) {
        File cacheFile = this.getProxy().getCacheFile(rawUrl);
        if (cacheFile.exists()) {
            if (cacheFile.length() >= 1024L) {
                return true;
            }
            cacheFile.delete();
            return false;
        }
        File tempCacheFile = this.getProxy().getTempCacheFile(rawUrl);
        if (tempCacheFile.exists()) {
            return tempCacheFile.length() >= (long)this.mPreloadLength;
        }
        return false;
    }

    public boolean isCache(String rawUrl) {
        return this.getProxy().isCached(rawUrl);
    }

    public void pausePreload() {
        this.mIsStartPreload = false;
        try {
            for (Map.Entry<String, PreloadTask> next : this.mPreloadTasks.entrySet()) {
                PreloadTask task = next.getValue();
                task.cancel();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void pausePreload(int position, boolean isReverseScroll) {
        this.mIsStartPreload = false;
        try {
            for (Map.Entry<String, PreloadTask> next : this.mPreloadTasks.entrySet()) {
                PreloadTask task = next.getValue();
                if (isReverseScroll) {
                    if (task.getPosition() < position) continue;
                    task.cancel();
                    continue;
                }
                if (task.getPosition() > position) continue;
                task.cancel();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void resumePreload() {
        this.mIsStartPreload = true;
        try {
            for (Map.Entry<String, PreloadTask> next : this.mPreloadTasks.entrySet()) {
                PreloadTask task = next.getValue();
                if (this.isPreloaded(task.getRawUrl())) continue;
                task.executeOn(this.mExecutorService);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void resumePreload(int position, boolean isReverseScroll) {
        try {
            for (Map.Entry<String, PreloadTask> next : this.mPreloadTasks.entrySet()) {
                PreloadTask task = next.getValue();
                if (isReverseScroll) {
                    if (task.getPosition() >= position || this.isPreloaded(task.getRawUrl())) continue;
                    task.executeOn(this.mExecutorService);
                    continue;
                }
                if (task.getPosition() <= position || this.isPreloaded(task.getRawUrl())) continue;
                task.executeOn(this.mExecutorService);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void removePreloadTask(String rawUrl) {
        PreloadTask task = this.mPreloadTasks.get(rawUrl);
        if (task != null) {
            task.cancel();
            this.mPreloadTasks.remove(rawUrl);
        }
    }

    public void stopllPreloadTask() {
        this.removeAllPreloadTask();
    }

    public void removeAllPreloadTask() {
        try {
            Iterator<Map.Entry<String, PreloadTask>> iterator = this.mPreloadTasks.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, PreloadTask> next = iterator.next();
                PreloadTask task = next.getValue();
                task.cancel();
                iterator.remove();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getPlayPreloadUrl(String rawUrl) {
        return this.getPlayPreloadUrl(null, rawUrl);
    }

    public String getPlayPreloadUrl(Context context, String rawUrl) {
        PreloadTask task;
        if (null == this.mCacheServer && null != context) {
            this.initCache(context);
        }
        if ((task = this.mPreloadTasks.get(rawUrl)) != null) {
            task.cancel();
        }
        if (this.isPreloaded(rawUrl)) {
            return this.getProxy().getProxyUrl(rawUrl);
        }
        return rawUrl;
    }
}

