/*
 * Decompiled with CFR 0.152.
 */
package com.hss01248.dialog.view;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.Nullable;
import com.hss01248.dialog.R;
import com.hss01248.dialog.ScreenUtil;
import com.hss01248.dialog.Tool;
import com.hss01248.dialog.adapter.SuperLvHolder;
import com.hss01248.dialog.config.ConfigBean;

public class AdXHolder
extends SuperLvHolder<ConfigBean> {
    RelativeLayout relativeLayout;
    ImageView iv_close;
    RelativeLayout ivCloseContainer;
    FrameLayout adContainer;

    public AdXHolder(Context context) {
        super(context);
    }

    @Override
    protected void findViews() {
        this.relativeLayout = (RelativeLayout)this.rootView;
        this.iv_close = (ImageView)this.rootView.findViewById(R.id.iv_close_ad_real);
        this.ivCloseContainer = (RelativeLayout)this.rootView.findViewById(R.id.rl_close_ad_container);
        this.adContainer = (FrameLayout)this.rootView.findViewById(R.id.fl_ad_container);
    }

    @Override
    protected int setLayoutRes() {
        return R.layout.dialog_ad_x;
    }

    @Override
    public void assingDatasAndEvents(Context context, final @Nullable ConfigBean bean) {
        View customView = bean.customView;
        if (customView == null && bean.customContentHolder != null) {
            customView = bean.customContentHolder.rootView;
        }
        if (customView == null) {
            return;
        }
        this.adContainer.addView(customView);
        this.resetCloseBtnPosition(bean);
        this.ivCloseContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Tool.dismiss(bean);
                bean.listener.onFirst();
            }
        });
    }

    private void resetCloseBtnPosition(ConfigBean bean) {
        RelativeLayout.LayoutParams params;
        if (bean.xResId != 0) {
            this.iv_close.setImageResource(bean.xResId);
        }
        if (bean.xWidth > 0) {
            params = (RelativeLayout.LayoutParams)this.iv_close.getLayoutParams();
            params.height = params.width = ScreenUtil.dip2px(bean.xWidth);
            this.iv_close.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        params = (RelativeLayout.LayoutParams)this.ivCloseContainer.getLayoutParams();
        if (bean.xGravity == 53) {
            ((RelativeLayout.LayoutParams)this.adContainer.getLayoutParams()).addRule(3, R.id.rl_close_ad_container);
            params.bottomMargin = ScreenUtil.dip2px(bean.xMarginTB);
            if (bean.xMarginLR > 0) {
                params.rightMargin = ScreenUtil.dip2px(bean.xMarginLR);
            }
            params.addRule(7, R.id.fl_ad_container);
            ((RelativeLayout.LayoutParams)this.iv_close.getLayoutParams()).addRule(11);
            ((RelativeLayout.LayoutParams)this.iv_close.getLayoutParams()).addRule(12);
        } else if (bean.xGravity == 49) {
            params.addRule(14);
            ((RelativeLayout.LayoutParams)this.adContainer.getLayoutParams()).addRule(3, R.id.rl_close_ad_container);
            params.bottomMargin = ScreenUtil.dip2px(bean.xMarginTB);
            ((RelativeLayout.LayoutParams)this.iv_close.getLayoutParams()).addRule(12);
        } else if (bean.xGravity == 51) {
            ((RelativeLayout.LayoutParams)this.adContainer.getLayoutParams()).addRule(3, R.id.rl_close_ad_container);
            params.bottomMargin = ScreenUtil.dip2px(bean.xMarginTB);
            if (bean.xMarginLR > 0) {
                params.rightMargin = ScreenUtil.dip2px(bean.xMarginLR);
            }
            params.addRule(5, R.id.fl_ad_container);
            ((RelativeLayout.LayoutParams)this.iv_close.getLayoutParams()).addRule(9);
            ((RelativeLayout.LayoutParams)this.iv_close.getLayoutParams()).addRule(12);
        } else if (bean.xGravity == 85) {
            params.addRule(3, R.id.fl_ad_container);
            params.topMargin = ScreenUtil.dip2px(bean.xMarginTB);
            if (bean.xMarginLR > 0) {
                params.rightMargin = ScreenUtil.dip2px(bean.xMarginLR);
            }
            params.addRule(7, R.id.fl_ad_container);
            ((RelativeLayout.LayoutParams)this.iv_close.getLayoutParams()).addRule(11);
            ((RelativeLayout.LayoutParams)this.iv_close.getLayoutParams()).addRule(10);
        } else if (bean.xGravity == 81) {
            params.addRule(14);
            params.addRule(3, R.id.fl_ad_container);
            params.topMargin = ScreenUtil.dip2px(bean.xMarginTB);
            ((RelativeLayout.LayoutParams)this.iv_close.getLayoutParams()).addRule(10);
        } else if (bean.xGravity == 83) {
            if (bean.xMarginLR > 0) {
                params.rightMargin = ScreenUtil.dip2px(bean.xMarginLR);
            }
            params.addRule(3, R.id.fl_ad_container);
            params.topMargin = ScreenUtil.dip2px(bean.xMarginTB);
            params.addRule(5, R.id.fl_ad_container);
            ((RelativeLayout.LayoutParams)this.iv_close.getLayoutParams()).addRule(9);
            ((RelativeLayout.LayoutParams)this.iv_close.getLayoutParams()).addRule(10);
        } else {
            params.addRule(14);
            params.addRule(3, R.id.fl_ad_container);
            params.topMargin = ScreenUtil.dip2px(bean.xMarginTB);
            ((RelativeLayout.LayoutParams)this.iv_close.getLayoutParams()).addRule(10);
        }
        this.ivCloseContainer.setLayoutParams((ViewGroup.LayoutParams)params);
        this.relativeLayout.requestLayout();
    }
}

