/*
 * Decompiled with CFR 0.152.
 */
package com.hss01248.dialog.material;

import android.content.Context;
import android.text.TextUtils;
import android.util.SparseBooleanArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ScrollView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.hss01248.dialog.R;
import com.hss01248.dialog.Tool;
import com.hss01248.dialog.adapter.SuperLvAdapter;
import com.hss01248.dialog.adapter.SuperLvHolder;
import com.hss01248.dialog.config.ChooseBean;
import com.hss01248.dialog.config.ConfigBean;
import com.hss01248.dialog.material.MdInputHolder;
import com.hss01248.dialog.material.MultiChooseHolder;
import com.hss01248.dialog.material.SingleChooseHolder;
import java.util.ArrayList;

public class MaterialDialogHolder
extends SuperLvHolder<ConfigBean> {
    private LinearLayout materialBackground;
    private LinearLayout contentView;
    private TextView title;
    private ScrollView messageContentRoot;
    private LinearLayout messageContentView;
    private TextView message;
    private Button btnP;
    private LinearLayout buttonLayout;
    private Button btnN;
    MdInputHolder mdInputHolder;

    public MaterialDialogHolder(Context context) {
        super(context);
    }

    @Override
    protected void findViews() {
        this.materialBackground = (LinearLayout)this.rootView.findViewById(R.id.material_background);
        this.contentView = (LinearLayout)this.rootView.findViewById(R.id.contentView);
        this.title = (TextView)this.rootView.findViewById(R.id.title);
        this.messageContentRoot = (ScrollView)this.rootView.findViewById(R.id.message_content_root);
        this.messageContentView = (LinearLayout)this.rootView.findViewById(R.id.message_content_view);
        this.message = (TextView)this.rootView.findViewById(R.id.message);
        this.btnP = (Button)this.rootView.findViewById(R.id.btn_p);
        this.buttonLayout = (LinearLayout)this.rootView.findViewById(R.id.buttonLayout);
        this.btnN = (Button)this.rootView.findViewById(R.id.btn_n);
    }

    @Override
    protected int setLayoutRes() {
        return R.layout.layout_material_dialog;
    }

    @Override
    public void assingDatasAndEvents(Context context, @Nullable ConfigBean bean) {
        if (bean == null) {
            return;
        }
        this.setTitleStyle(bean);
        this.setContentStyle(context, bean);
        this.setBtnStyleAndEvent(context, bean);
    }

    private void setBtnStyleAndEvent(Context context, final ConfigBean bean) {
        if (TextUtils.isEmpty((CharSequence)bean.text2)) {
            this.btnN.setVisibility(8);
        } else {
            this.btnN.setVisibility(0);
            this.btnN.setText(bean.text2);
            this.btnN.setTextColor(Tool.getColor(bean.context, bean.btn2Color));
            this.btnN.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Tool.dismiss(bean);
                    if (bean.listener != null) {
                        bean.listener.onSecond();
                    }
                }
            });
        }
        if (TextUtils.isEmpty((CharSequence)bean.text1)) {
            this.btnP.setVisibility(8);
        } else {
            this.btnP.setVisibility(0);
            this.btnP.setText(bean.text1);
            this.btnP.setTextColor(Tool.getColor(bean.context, bean.btn1Color));
            if (bean.type == 4) {
                return;
            }
            this.btnP.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (bean.type == 16) {
                        boolean isvalid = bean.listener.onInputValid(MaterialDialogHolder.this.mdInputHolder.getTxt1(), MaterialDialogHolder.this.mdInputHolder.getTxt2(), MaterialDialogHolder.this.mdInputHolder.getEt1(), MaterialDialogHolder.this.mdInputHolder.getEt2());
                        if (!isvalid) {
                            return;
                        }
                        bean.listener.onGetInput(MaterialDialogHolder.this.mdInputHolder.getTxt1(), MaterialDialogHolder.this.mdInputHolder.getTxt2());
                    }
                    Tool.dismiss(bean, true);
                    if (bean.listener != null) {
                        bean.listener.onFirst();
                    }
                }
            });
        }
    }

    private void setContentStyle(Context context, ConfigBean bean) {
        if (bean.type == 16) {
            this.message.setVisibility(8);
            this.mdInputHolder = new MdInputHolder(context);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
            this.mdInputHolder.rootView.setLayoutParams((ViewGroup.LayoutParams)params);
            this.messageContentView.addView(this.mdInputHolder.rootView);
            bean.needSoftKeyboard = true;
            this.mdInputHolder.assingDatasAndEvents(context, bean);
            return;
        }
        if (bean.type == 3) {
            this.message.setVisibility(8);
            this.buildChoose(context, bean);
            return;
        }
        if (bean.type == 4) {
            this.message.setVisibility(8);
            this.buildChoose(context, bean);
            return;
        }
        if (bean.customContentHolder != null) {
            this.message.setVisibility(8);
            this.messageContentView.addView(bean.customContentHolder.rootView);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)bean.msg)) {
            this.message.setVisibility(8);
        } else {
            this.message.setVisibility(0);
            this.message.setText(bean.msg);
            this.message.setTextSize((float)bean.msgTxtSize);
            this.message.setTextColor(Tool.getColor(bean.context, bean.msgTxtColor));
        }
    }

    private void buildChoose(Context context, final ConfigBean bean) {
        this.messageContentRoot.setVisibility(8);
        final ListView listView = new ListView(context);
        listView.setDivider(null);
        SuperLvAdapter adapter = this.buildAdapterByType(bean);
        listView.setAdapter((ListAdapter)adapter);
        adapter.addAll(bean.chooseBeans);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        listView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.contentView.addView((View)listView, 1);
        if (bean.type == 3) {
            listView.setChoiceMode(1);
            listView.setSelection(bean.defaultChosen);
            listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    if (bean.listener != null) {
                        bean.listener.onGetChoose(position, bean.chooseBeans.get((int)position).txt);
                    }
                    if (bean.itemListener != null) {
                        bean.itemListener.onItemClick(bean.chooseBeans.get((int)position).txt, position);
                    }
                    Tool.dismiss(bean);
                }
            });
        } else {
            listView.setChoiceMode(2);
            this.btnP.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SparseBooleanArray booleanArray = listView.getCheckedItemPositions();
                    ArrayList<Integer> selectedIndexs = new ArrayList<Integer>(booleanArray.size());
                    ArrayList<CharSequence> selectStrs = new ArrayList<CharSequence>(booleanArray.size());
                    boolean[] states = new boolean[bean.chooseBeans.size()];
                    for (int i = 0; i < booleanArray.size(); ++i) {
                        Boolean selected = booleanArray.get(i);
                        if (selected.booleanValue()) {
                            selectedIndexs.add(i);
                            selectStrs.add(bean.chooseBeans.get((int)i).txt);
                        }
                        states[i] = selected;
                    }
                    bean.listener.onChoosen(selectedIndexs, selectStrs, states);
                    Tool.dismiss(bean);
                }
            });
        }
        for (int i = 0; i < bean.chooseBeans.size(); ++i) {
            ChooseBean chooseBean = bean.chooseBeans.get(i);
            listView.setItemChecked(i, chooseBean.choosen);
        }
    }

    private SuperLvAdapter buildAdapterByType(final ConfigBean bean) {
        SuperLvAdapter adapter = null;
        if (bean.type == 3) {
            adapter = new SuperLvAdapter(bean.context){

                @Override
                protected SuperLvHolder generateNewHolder(Context context, int itemViewType) {
                    return new SingleChooseHolder(bean.context);
                }
            };
        } else if (bean.type == 4) {
            adapter = new SuperLvAdapter(bean.context){

                @Override
                protected SuperLvHolder generateNewHolder(Context context, int itemViewType) {
                    return new MultiChooseHolder(bean.context);
                }
            };
        }
        return adapter;
    }

    private void setTitleStyle(ConfigBean bean) {
        if (TextUtils.isEmpty((CharSequence)bean.title)) {
            this.title.setVisibility(8);
        } else {
            this.title.setVisibility(0);
            this.title.setText(bean.title);
            if (bean.titleTxtColor > 0) {
                this.title.setTextColor(Tool.getColor(bean.context, bean.titleTxtColor));
            }
            if (bean.titleTxtSize > 0) {
                this.title.setTextSize((float)bean.titleTxtSize);
            }
        }
    }
}

