/*
 * Decompiled with CFR 0.152.
 */
package com.hss01248.dialog.ios;

import android.content.Context;
import android.text.TextUtils;
import android.text.method.HideReturnsTransformationMethod;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import com.hss01248.dialog.R;
import com.hss01248.dialog.Tool;
import com.hss01248.dialog.adapter.SuperLvHolder;
import com.hss01248.dialog.config.ConfigBean;

public class IosAlertDialogHolder
extends SuperLvHolder<ConfigBean> {
    protected TextView tvTitle;
    public TextView tvMsg;
    public EditText et1;
    public EditText et2;
    protected View line;
    protected TextView btn1;
    protected View lineBtn2;
    protected TextView btn2;
    protected View lineBtn3;
    protected TextView btn3;
    protected LinearLayout llContainerHorizontal;
    protected TextView btn1Vertical;
    protected View lineBtn2Vertical;
    protected TextView btn2Vertical;
    protected View lineBtn3Vertical;
    protected TextView btn3Vertical;
    protected LinearLayout llContainerVertical;
    protected ScrollView sv;
    protected LinearLayout llContainerContent;
    ConfigBean bean;

    public IosAlertDialogHolder(Context context) {
        super(context);
    }

    @Override
    protected void findViews() {
        this.tvTitle = (TextView)this.rootView.findViewById(R.id.tv_title);
        this.tvMsg = (TextView)this.rootView.findViewById(R.id.tv_msg);
        this.et1 = (EditText)this.rootView.findViewById(R.id.et_1);
        this.et2 = (EditText)this.rootView.findViewById(R.id.et_2);
        this.line = this.rootView.findViewById(R.id.line);
        this.btn1 = (TextView)this.rootView.findViewById(R.id.btn_1);
        this.lineBtn2 = this.rootView.findViewById(R.id.line_btn2);
        this.btn2 = (TextView)this.rootView.findViewById(R.id.btn_2);
        this.lineBtn3 = this.rootView.findViewById(R.id.line_btn3);
        this.btn3 = (TextView)this.rootView.findViewById(R.id.btn_3);
        this.llContainerHorizontal = (LinearLayout)this.rootView.findViewById(R.id.ll_container_horizontal);
        this.btn1Vertical = (TextView)this.rootView.findViewById(R.id.btn_1_vertical);
        this.lineBtn2Vertical = this.rootView.findViewById(R.id.line_btn2_vertical);
        this.btn2Vertical = (TextView)this.rootView.findViewById(R.id.btn_2_vertical);
        this.lineBtn3Vertical = this.rootView.findViewById(R.id.line_btn3_vertical);
        this.btn3Vertical = (TextView)this.rootView.findViewById(R.id.btn_3_vertical);
        this.llContainerVertical = (LinearLayout)this.rootView.findViewById(R.id.ll_container_vertical);
        this.sv = (ScrollView)this.rootView.findViewById(R.id.sv);
        this.llContainerContent = (LinearLayout)this.rootView.findViewById(R.id.ll_container);
    }

    public void showOnlyTitleAndMsg(String title, String msg) {
        this.et2.setVisibility(8);
        this.et1.setVisibility(8);
        this.llContainerHorizontal.setVisibility(8);
        this.llContainerVertical.setVisibility(8);
        this.line.setVisibility(8);
        this.tvTitle.setText((CharSequence)title);
        this.tvMsg.setText((CharSequence)msg);
    }

    @Override
    protected int setLayoutRes() {
        return R.layout.dialog_ios_alert;
    }

    @Override
    public void assingDatasAndEvents(Context context, ConfigBean bean) {
        this.bean = bean;
        bean.viewHolder = this;
        this.setBtnsSytle(context, bean);
        this.setTitleStyle(context, bean);
        if (bean.customContentHolder == null) {
            this.setMsgStyleAndTxt(bean);
            this.setInputStyle(context, bean);
        } else {
            this.addCustomView(bean, context);
        }
        this.setBtnTxt(context, bean);
        if (bean.isVertical) {
            this.setBtnEventVertical(bean, context);
        } else {
            this.setBtnEventH(context, bean);
        }
    }

    private void addCustomView(ConfigBean bean, Context context) {
        this.tvMsg.setVisibility(8);
        this.et1.setVisibility(8);
        this.et2.setVisibility(8);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        SuperLvHolder holder = bean.customContentHolder;
        holder.rootView.setLayoutParams((ViewGroup.LayoutParams)params);
        if (holder.rootView.getParent() == null) {
            this.llContainerContent.addView(holder.rootView);
        } else {
            ((ViewGroup)holder.rootView.getParent()).removeView(holder.rootView);
            this.llContainerContent.addView(holder.rootView);
        }
    }

    private void setBtnEventH(Context context, final ConfigBean bean) {
        this.btn1.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (bean.type == 9) {
                    boolean needDismiss = bean.listener.onInputValid(IosAlertDialogHolder.this.et1.getText().toString().trim(), IosAlertDialogHolder.this.et2.getText().toString().trim(), IosAlertDialogHolder.this.et1, IosAlertDialogHolder.this.et2);
                    if (!needDismiss) {
                        return;
                    }
                    bean.listener.onGetInput(IosAlertDialogHolder.this.et1.getText().toString().trim(), IosAlertDialogHolder.this.et2.getText().toString().trim());
                }
                Tool.dismiss(bean, true);
                bean.listener.onFirst();
            }
        });
        this.btn2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Tool.dismiss(bean);
                bean.listener.onSecond();
            }
        });
        this.btn3.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Tool.dismiss(bean);
                bean.listener.onThird();
            }
        });
    }

    private void setBtnEventVertical(final ConfigBean bean, Context context) {
        this.btn1Vertical.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (bean.type == 9) {
                    boolean needDismiss = bean.listener.onInputValid(IosAlertDialogHolder.this.et1.getText().toString().trim(), IosAlertDialogHolder.this.et2.getText().toString().trim(), IosAlertDialogHolder.this.et1, IosAlertDialogHolder.this.et2);
                    if (!needDismiss) {
                        return;
                    }
                    bean.listener.onGetInput(IosAlertDialogHolder.this.et1.getText().toString().trim(), IosAlertDialogHolder.this.et2.getText().toString().trim());
                }
                Tool.dismiss(bean, true);
                bean.listener.onFirst();
            }
        });
        this.btn2Vertical.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Tool.dismiss(bean);
                bean.listener.onSecond();
            }
        });
        this.btn3Vertical.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Tool.dismiss(bean);
                bean.listener.onThird();
            }
        });
    }

    private void setMsgStyleAndTxt(ConfigBean bean) {
        if (TextUtils.isEmpty((CharSequence)bean.msg)) {
            this.tvMsg.setVisibility(8);
        } else {
            this.tvMsg.setVisibility(0);
            this.tvMsg.setText(bean.msg);
            this.tvMsg.setTextColor(Tool.getColor(this.tvMsg.getContext(), bean.msgTxtColor));
            this.tvMsg.setTextSize((float)bean.msgTxtSize);
            if (bean.msg.toString().startsWith("{") && bean.msg.toString().endsWith("}")) {
                return;
            }
            if (bean.msg.toString().startsWith("[") && bean.msg.toString().endsWith("]")) {
                return;
            }
            this.tvMsg.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    int lineCount = IosAlertDialogHolder.this.tvMsg.getLineCount();
                    if (lineCount > 0) {
                        IosAlertDialogHolder.this.tvMsg.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        Log.w((String)"check", (String)("tvMsg.getMeasuredWidth()-" + IosAlertDialogHolder.this.tvMsg.getMeasuredWidth() + "-llContainerContent.getMeasuredWidth()-" + IosAlertDialogHolder.this.llContainerContent.getMeasuredWidth()));
                        if ((double)IosAlertDialogHolder.this.tvMsg.getMeasuredWidth() * 1.4 < (double)IosAlertDialogHolder.this.llContainerContent.getMeasuredWidth() || lineCount == 1) {
                            IosAlertDialogHolder.this.tvMsg.setGravity(17);
                            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)IosAlertDialogHolder.this.tvMsg.getLayoutParams();
                            layoutParams.gravity = 17;
                            IosAlertDialogHolder.this.tvMsg.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                        }
                    }
                }
            });
        }
    }

    private void setBtnTxt(Context context, ConfigBean bean) {
        if (TextUtils.isEmpty((CharSequence)bean.text3)) {
            if (bean.isVertical) {
                this.btn3Vertical.setVisibility(8);
                this.lineBtn3Vertical.setVisibility(8);
            } else {
                this.btn3.setVisibility(8);
                this.lineBtn3.setVisibility(8);
            }
        } else if (bean.isVertical) {
            this.btn3Vertical.setVisibility(0);
            this.lineBtn3Vertical.setVisibility(0);
            this.btn3Vertical.setText(bean.text3);
        } else {
            this.btn3.setVisibility(0);
            this.lineBtn3.setVisibility(0);
            this.btn3.setText(bean.text3);
        }
        if (TextUtils.isEmpty((CharSequence)bean.text2)) {
            if (bean.isVertical) {
                this.btn2Vertical.setVisibility(8);
                this.lineBtn2Vertical.setVisibility(8);
            } else {
                this.btn2.setVisibility(8);
                this.lineBtn2.setVisibility(8);
            }
        } else if (bean.isVertical) {
            this.btn2Vertical.setVisibility(0);
            this.lineBtn2Vertical.setVisibility(0);
            this.btn2Vertical.setText(bean.text2);
        } else {
            this.btn2.setVisibility(0);
            this.lineBtn2.setVisibility(0);
            this.btn2.setText(bean.text2);
        }
        if (bean.isVertical) {
            this.btn1Vertical.setText(bean.text1);
        } else {
            this.btn1.setText(bean.text1);
        }
    }

    private void setTitleStyle(Context context, ConfigBean bean) {
        if (TextUtils.isEmpty((CharSequence)bean.title)) {
            this.tvTitle.setVisibility(8);
        } else {
            this.tvTitle.setVisibility(0);
            this.tvTitle.setText(bean.title);
            this.tvTitle.setTextColor(Tool.getColor(this.tvTitle.getContext(), bean.titleTxtColor));
            this.tvTitle.setTextSize((float)bean.titleTxtSize);
        }
    }

    private void setBtnsSytle(Context context, ConfigBean bean) {
        this.btn3Vertical.setTextSize((float)bean.btnTxtSize);
        this.btn2Vertical.setTextSize((float)bean.btnTxtSize);
        this.btn1Vertical.setTextSize((float)bean.btnTxtSize);
        this.btn3.setTextSize((float)bean.btnTxtSize);
        this.btn2.setTextSize((float)bean.btnTxtSize);
        this.btn1.setTextSize((float)bean.btnTxtSize);
        this.btn1.setTextColor(Tool.getColor(this.btn1.getContext(), bean.btn1Color));
        this.btn2.setTextColor(Tool.getColor(this.btn1.getContext(), bean.btn2Color));
        this.btn3.setTextColor(Tool.getColor(this.btn1.getContext(), bean.btn3Color));
        this.btn1Vertical.setTextColor(Tool.getColor(this.btn1.getContext(), bean.btn1Color));
        this.btn2Vertical.setTextColor(Tool.getColor(this.btn1.getContext(), bean.btn2Color));
        this.btn3Vertical.setTextColor(Tool.getColor(this.btn1.getContext(), bean.btn3Color));
        if (bean.isVertical) {
            this.llContainerVertical.setVisibility(0);
            this.llContainerHorizontal.setVisibility(8);
        } else {
            this.llContainerVertical.setVisibility(8);
            this.llContainerHorizontal.setVisibility(0);
        }
    }

    private void setInputStyle(Context context, ConfigBean bean) {
        if (TextUtils.isEmpty((CharSequence)bean.hint1)) {
            this.et1.setVisibility(8);
        } else {
            bean.setNeedSoftKeyboard(true);
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.sv.getLayoutParams();
            params.height = -2;
            params.weight = 0.0f;
            this.sv.setLayoutParams((ViewGroup.LayoutParams)params);
            this.et1.setVisibility(0);
            this.et1.setHint(bean.hint1);
            this.et1.setTextColor(Tool.getColor(this.et1.getContext(), bean.inputTxtColor));
            this.et1.setTextSize((float)bean.inputTxtSize);
            if (!TextUtils.isEmpty((CharSequence)bean.inputText1)) {
                this.et1.setText(bean.inputText1);
                this.et1.setSelection(bean.inputText1.length());
            }
        }
        if (TextUtils.isEmpty((CharSequence)bean.hint2)) {
            this.et2.setVisibility(8);
        } else {
            bean.setNeedSoftKeyboard(true);
            this.et2.setVisibility(0);
            this.et2.setHint(bean.hint2);
            this.et2.setTextColor(Tool.getColor(this.et2.getContext(), bean.inputTxtColor));
            this.et2.setTextSize((float)bean.inputTxtSize);
            if (bean.isInput2HideAsPassword) {
                this.et2.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
            } else {
                this.et2.setTransformationMethod((TransformationMethod)HideReturnsTransformationMethod.getInstance());
            }
            if (!TextUtils.isEmpty((CharSequence)bean.inputText2)) {
                this.et2.setText(bean.inputText2);
                this.et2.setSelection(bean.inputText2.length());
            }
        }
    }

    @Override
    public void showKeyBoard() {
        if (TextUtils.isEmpty((CharSequence)this.bean.hint2) && !TextUtils.isEmpty((CharSequence)this.bean.hint1)) {
            Tool.showKeyBoard((View)this.et1);
        } else if (TextUtils.isEmpty((CharSequence)this.bean.hint1) && !TextUtils.isEmpty((CharSequence)this.bean.hint2)) {
            Tool.showKeyBoard((View)this.et2);
        } else if (!TextUtils.isEmpty((CharSequence)this.bean.hint2) && !TextUtils.isEmpty((CharSequence)this.bean.hint1)) {
            Tool.showKeyBoard((View)this.et1);
        }
    }

    @Override
    public void hideKeyBoard() {
        if (TextUtils.isEmpty((CharSequence)this.bean.hint2) && !TextUtils.isEmpty((CharSequence)this.bean.hint1)) {
            Tool.hideKeyBoard((View)this.et1);
        } else if (TextUtils.isEmpty((CharSequence)this.bean.hint1) && !TextUtils.isEmpty((CharSequence)this.bean.hint2)) {
            Tool.hideKeyBoard((View)this.et2);
        } else if (!TextUtils.isEmpty((CharSequence)this.bean.hint2) && !TextUtils.isEmpty((CharSequence)this.bean.hint1)) {
            Tool.hideKeyBoard((View)this.et1);
        }
    }
}

