/*
 * Decompiled with CFR 0.152.
 */
package com.hss01248.dialog.config;

import android.view.View;
import androidx.annotation.DrawableRes;

public class WindowConfig {
    private int gravity;
    private boolean needSoftKeyboard;
    private float forceWidthPercent;
    private float maxWidthPercent;
    private float forceHeightPercent;
    private float maxHeightPercent;
    private boolean cancelable = true;
    private boolean outsideCancelable = false;
    private float dimAmount = 0.7f;
    @DrawableRes
    private int bgRes;
    private boolean showAsActivity;
    private boolean showAsFragment;
    private boolean showAsToast;
    private boolean showAsDialog;
    private int flags;
    private int windowType;
    private int x;
    private int y;
    private View rootView;

    public int getGravity() {
        return this.gravity;
    }

    public boolean isNeedSoftKeyboard() {
        return this.needSoftKeyboard;
    }

    public float getForceWidthPercent() {
        return this.forceWidthPercent;
    }

    public float getMaxWidthPercent() {
        return this.maxWidthPercent;
    }

    public float getForceHeightPercent() {
        return this.forceHeightPercent;
    }

    public float getMaxHeightPercent() {
        return this.maxHeightPercent;
    }

    public boolean isCancelable() {
        return this.cancelable;
    }

    public boolean isOutsideCancelable() {
        return this.outsideCancelable;
    }

    public float getDimAmount() {
        return this.dimAmount;
    }

    public int getBgRes() {
        return this.bgRes;
    }

    public boolean isShowAsActivity() {
        return this.showAsActivity;
    }

    public boolean isShowAsFragment() {
        return this.showAsFragment;
    }

    public boolean isShowAsToast() {
        return this.showAsToast;
    }

    public boolean isShowAsDialog() {
        return this.showAsDialog;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getWindowType() {
        return this.windowType;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public View getRootView() {
        return this.rootView;
    }

    private WindowConfig(Builder builder) {
        this.gravity = builder.gravity;
        this.needSoftKeyboard = builder.needSoftKeyboard;
        this.forceWidthPercent = builder.forceWidthPercent;
        this.maxWidthPercent = builder.maxWidthPercent;
        this.forceHeightPercent = builder.forceHeightPercent;
        this.maxHeightPercent = builder.maxHeightPercent;
        this.cancelable = builder.cancelable;
        this.outsideCancelable = builder.outsideCancelable;
        this.dimAmount = builder.dimAmount;
        this.bgRes = builder.bgRes;
        this.showAsActivity = builder.showAsActivity;
        this.showAsFragment = builder.showAsFragment;
        this.showAsToast = builder.showAsToast;
        this.showAsDialog = builder.showAsDialog;
        this.flags = builder.flags;
        this.windowType = builder.windowType;
        this.x = builder.x;
        this.y = builder.y;
        this.rootView = builder.rootView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(WindowConfig copy) {
        Builder builder = new Builder();
        builder.gravity = copy.getGravity();
        builder.needSoftKeyboard = copy.isNeedSoftKeyboard();
        builder.forceWidthPercent = copy.getForceWidthPercent();
        builder.maxWidthPercent = copy.getMaxWidthPercent();
        builder.forceHeightPercent = copy.getForceHeightPercent();
        builder.maxHeightPercent = copy.getMaxHeightPercent();
        builder.cancelable = copy.isCancelable();
        builder.outsideCancelable = copy.isOutsideCancelable();
        builder.dimAmount = copy.getDimAmount();
        builder.bgRes = copy.getBgRes();
        builder.showAsActivity = copy.isShowAsActivity();
        builder.showAsFragment = copy.isShowAsFragment();
        builder.showAsToast = copy.isShowAsToast();
        builder.showAsDialog = copy.isShowAsDialog();
        builder.flags = copy.getFlags();
        builder.windowType = copy.getWindowType();
        builder.x = copy.getX();
        builder.y = copy.getY();
        builder.rootView = copy.getRootView();
        return builder;
    }

    public static final class Builder {
        private int gravity;
        private boolean needSoftKeyboard;
        private float forceWidthPercent;
        private float maxWidthPercent;
        private float forceHeightPercent;
        private float maxHeightPercent;
        private boolean cancelable;
        private boolean outsideCancelable;
        private float dimAmount;
        private int bgRes;
        private boolean showAsActivity;
        private boolean showAsFragment;
        private boolean showAsToast;
        private boolean showAsDialog;
        private int flags;
        private int windowType;
        private int x;
        private int y;
        private View rootView;

        private Builder() {
        }

        public Builder gravity(int gravity) {
            this.gravity = gravity;
            return this;
        }

        public Builder needSoftKeyboard(boolean needSoftKeyboard) {
            this.needSoftKeyboard = needSoftKeyboard;
            return this;
        }

        public Builder forceWidthPercent(float forceWidthPercent) {
            this.forceWidthPercent = forceWidthPercent;
            return this;
        }

        public Builder maxWidthPercent(float maxWidthPercent) {
            this.maxWidthPercent = maxWidthPercent;
            return this;
        }

        public Builder forceHeightPercent(float forceHeightPercent) {
            this.forceHeightPercent = forceHeightPercent;
            return this;
        }

        public Builder maxHeightPercent(float maxHeightPercent) {
            this.maxHeightPercent = maxHeightPercent;
            return this;
        }

        public Builder cancelable(boolean cancelable) {
            this.cancelable = cancelable;
            return this;
        }

        public Builder outsideCancelable(boolean outsideCancelable) {
            this.outsideCancelable = outsideCancelable;
            return this;
        }

        public Builder dimAmount(float dimAmount) {
            this.dimAmount = dimAmount;
            return this;
        }

        public Builder bgRes(int bgRes) {
            this.bgRes = bgRes;
            return this;
        }

        public Builder showAsActivity(boolean showAsActivity) {
            this.showAsActivity = showAsActivity;
            return this;
        }

        public Builder showAsFragment(boolean showAsFragment) {
            this.showAsFragment = showAsFragment;
            return this;
        }

        public Builder showAsToast(boolean showAsToast) {
            this.showAsToast = showAsToast;
            return this;
        }

        public Builder showAsDialog(boolean showAsDialog) {
            this.showAsDialog = showAsDialog;
            return this;
        }

        public Builder flags(int flags) {
            this.flags = flags;
            return this;
        }

        public Builder windowType(int windowType) {
            this.windowType = windowType;
            return this;
        }

        public Builder x(int x) {
            this.x = x;
            return this;
        }

        public Builder y(int y) {
            this.y = y;
            return this;
        }

        public Builder rootView(View rootView) {
            this.rootView = rootView;
            return this;
        }

        public WindowConfig build() {
            return new WindowConfig(this);
        }
    }
}

