/*
 * Decompiled with CFR 0.152.
 */
package com.hss01248.dialog.bottomsheet;

import android.content.Context;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.hss01248.dialog.R;
import com.hss01248.dialog.ScreenUtil;
import com.hss01248.dialog.adapter.SuperLvHolder;
import com.hss01248.dialog.bottomsheet.BottomSheetBean;
import com.hss01248.dialog.config.BottomSheetStyle;

public class BsGvHolder
extends SuperLvHolder<BottomSheetBean> {
    public ImageView ivIcon;
    public TextView mTextView;

    public BsGvHolder(Context context) {
        super(context);
    }

    @Override
    protected void findViews() {
        this.ivIcon = (ImageView)this.rootView.findViewById(R.id.iv_icon);
        this.mTextView = (TextView)this.rootView.findViewById(R.id.tv_msg);
    }

    public void setStyle(BottomSheetStyle style2) {
        this.mTextView.setTextSize((float)style2.txtSizeSp);
        this.mTextView.setTextColor(this.mTextView.getContext().getResources().getColor(style2.txtColor));
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.ivIcon.getLayoutParams();
        if (params == null) {
            params = new LinearLayout.LayoutParams(-1, -1);
        }
        params.bottomMargin = ScreenUtil.dip2px(style2.txtMarginTopDp);
        params.width = ScreenUtil.dip2px(style2.iconSizeDp);
        params.height = ScreenUtil.dip2px(style2.iconSizeDp);
        this.ivIcon.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    @Override
    protected int setLayoutRes() {
        return R.layout.item_bottomsheet_gv;
    }

    @Override
    public void assingDatasAndEvents(Context context, BottomSheetBean bean) {
        if (bean.icon <= 0) {
            this.ivIcon.setVisibility(8);
        } else {
            this.ivIcon.setImageResource(bean.icon);
            this.ivIcon.setVisibility(0);
        }
        this.mTextView.setText((CharSequence)bean.text);
    }
}

