/*
 * Decompiled with CFR 0.152.
 */
package com.hss01248.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.hss01248.dialog.ActivityStackManager;
import com.hss01248.dialog.DialogsMaintainer;
import com.hss01248.dialog.R;
import com.hss01248.dialog.ScreenUtil;
import com.hss01248.dialog.StyledDialog;
import com.hss01248.dialog.adapter.SuperLvHolder;
import com.hss01248.dialog.config.ConfigBean;
import com.hss01248.dialog.config.DefaultConfig;
import com.hss01248.dialog.ios.IosAlertDialogHolder;
import com.hss01248.dialog.material.MdInputHolder;
import com.hss01248.dialog.view.DialogUtil_DialogActivity;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class Tool {
    private static Handler mainHandler;

    public static void dismiss(ConfigBean bean, boolean isAfterResult) {
        if (isAfterResult && !bean.dismissAfterResultCallback) {
            return;
        }
        Tool.hideKeyBorad(bean);
        if (bean.showAsActivity) {
            Activity activity = ActivityStackManager.getInstance().getTopActivity(DialogUtil_DialogActivity.class);
            if (activity != null) {
                activity.finish();
            }
            return;
        }
        if (bean.showAsFragment && bean.mDialogFragment != null) {
            bean.mDialogFragment.dismiss();
            return;
        }
        if (bean.dialog != null) {
            bean.dialog.dismiss();
        }
        if (bean.alertDialog != null) {
            bean.alertDialog.dismiss();
        }
    }

    public static void dismiss(ConfigBean bean) {
        Tool.dismiss(bean, false);
    }

    public static Handler getMainHandler() {
        if (mainHandler == null) {
            mainHandler = new Handler(Looper.getMainLooper());
        }
        return mainHandler;
    }

    public static void showDialog(final Dialog dialog, final ConfigBean bean) {
        StyledDialog.getMainHandler().post(new Runnable(){

            @Override
            public void run() {
                try {
                    dialog.show();
                    Tool.adjustWindow(dialog, bean);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void setListener(final Dialog dialog, final ConfigBean bean) {
        if (dialog == null) {
            return;
        }
        dialog.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface dialog0) {
                if (bean.alertDialog != null) {
                    Tool.setMdBtnStytle(bean);
                    Tool.setTitleMessageStyle((Dialog)bean.alertDialog, bean);
                }
                bean.listener.onShow();
                DialogsMaintainer.addWhenShow(bean.context, dialog);
                if (bean.type == 14 || bean.type == 1) {
                    DialogsMaintainer.addLoadingDialog(bean.context, dialog);
                }
            }
        });
        dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog0) {
                IosAlertDialogHolder iosAlertDialogHolder;
                if (bean.type == 9 && (iosAlertDialogHolder = (IosAlertDialogHolder)bean.viewHolder) != null) {
                    iosAlertDialogHolder.hideKeyBoard();
                }
                if (bean.listener != null) {
                    bean.listener.onCancle();
                }
            }
        });
        dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog0) {
                if (bean.listener != null) {
                    bean.listener.onDismiss();
                }
                DialogsMaintainer.removeWhenDismiss(dialog);
                if (bean.type == 14 || bean.type == 1) {
                    DialogsMaintainer.dismissLoading(dialog);
                }
            }
        });
    }

    private static void setTitleMessageStyle(Dialog dialog, ConfigBean bean) {
        try {
            Field mAlert = AlertDialog.class.getDeclaredField("mAlert");
            mAlert.setAccessible(true);
            Object mAlertController = mAlert.get(dialog);
            Field mMessage = mAlertController.getClass().getDeclaredField("mMessageView");
            mMessage.setAccessible(true);
            TextView tvMessage = (TextView)mMessage.get(mAlertController);
            if (bean.msgTxtColor != 0) {
                tvMessage.setTextColor(Tool.getColor(bean.context, bean.msgTxtColor));
            }
            if (bean.msgTxtSize != 0) {
                tvMessage.setTextSize((float)bean.msgTxtSize);
            }
            Field titleView = mAlertController.getClass().getDeclaredField("mTitleView");
            titleView.setAccessible(true);
            TextView tvTitle = (TextView)titleView.get(mAlertController);
            if (bean.titleTxtColor != 0) {
                tvTitle.setTextColor(Tool.getColor(bean.context, bean.titleTxtColor));
            }
            if (bean.titleTxtSize != 0) {
                tvTitle.setTextSize((float)bean.titleTxtSize);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void adjustWindow(final Dialog dialog, final ConfigBean bean) {
        dialog.getWindow().getDecorView().getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                Tool.setBottomSheetDialogPeekHeight(bean);
                Tool.adjustWH(dialog, bean);
                dialog.getWindow().getDecorView().getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
    }

    public static void setWindowAnimation(Window window, ConfigBean bean) {
        int gravity = bean.gravity;
        if (gravity == 80 || gravity == 81) {
            window.setWindowAnimations(R.style.ani_bottom);
        } else if (gravity == 17) {
            // empty if block
        }
    }

    public static void runOnUIThread(Runnable runnable) {
        if (mainHandler == null) {
            mainHandler = new Handler(Looper.getMainLooper());
        }
        mainHandler.post(runnable);
    }

    public static void runOnUIThreadDelayed(Runnable runnable) {
        if (mainHandler == null) {
            mainHandler = new Handler(Looper.getMainLooper());
        }
        mainHandler.postDelayed(runnable, 500L);
    }

    public static void showSoftKeyBoardDelayed(boolean sholudShouldKeyBoard, SuperLvHolder holder) {
        if (!sholudShouldKeyBoard) {
            return;
        }
        if (holder == null) {
            return;
        }
        holder.showKeyBoard();
    }

    public static void setMdBtnStytle(final ConfigBean bean) {
        Button btnPositive = bean.alertDialog.getButton(-1);
        Button btnNegative = bean.alertDialog.getButton(-2);
        Button btnNatural = bean.alertDialog.getButton(-3);
        if (btnPositive != null) {
            btnPositive.setAllCaps(false);
            if (!TextUtils.isEmpty((CharSequence)bean.text1)) {
                btnPositive.setText(bean.text1);
            }
            if (bean.btn1Color > 0) {
                btnPositive.setTextColor(Tool.getColor(bean.context, bean.btn1Color));
            }
            if (bean.btnTxtSize > 0) {
                btnPositive.setTextSize((float)bean.btnTxtSize);
            }
            btnPositive.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (bean.type == 16) {
                        MdInputHolder holder = (MdInputHolder)bean.viewHolder;
                        boolean isvalid = bean.listener.onInputValid(holder.getTxt1(), holder.getTxt2(), holder.getEt1(), holder.getEt2());
                        if (!isvalid) {
                            return;
                        }
                        bean.listener.onGetInput(holder.getTxt1(), holder.getTxt2());
                    } else if (bean.type != 3 && bean.type == 4) {
                        bean.listener.onGetChoose(bean.checkedItems);
                        ArrayList<Integer> selectedIndex = new ArrayList<Integer>();
                        ArrayList<CharSequence> selectedStrs = new ArrayList<CharSequence>();
                        for (int j = 0; j < bean.checkedItems.length; ++j) {
                            if (!bean.checkedItems[j]) continue;
                            selectedIndex.add(j);
                            selectedStrs.add(bean.wordsMd[j]);
                        }
                        bean.listener.onChoosen(selectedIndex, selectedStrs, bean.checkedItems);
                    }
                    bean.listener.onFirst();
                    Tool.dismiss(bean, true);
                }
            });
        }
        if (btnNegative != null) {
            btnNegative.setAllCaps(false);
            if (!TextUtils.isEmpty((CharSequence)bean.text2)) {
                btnNegative.setText(bean.text2);
            }
            if (bean.btn2Color > 0) {
                if (bean.btn2Color == DefaultConfig.iosBtnColor) {
                    btnNegative.setTextColor(Tool.getColor(bean.context, R.color.dialogutil_text_gray));
                } else {
                    btnNegative.setTextColor(Tool.getColor(bean.context, bean.btn2Color));
                }
            }
            if (bean.btnTxtSize > 0) {
                btnNegative.setTextSize((float)bean.btnTxtSize);
            }
        }
        if (btnNatural != null) {
            btnNatural.setAllCaps(false);
            if (!TextUtils.isEmpty((CharSequence)bean.text3)) {
                btnNatural.setText(bean.text3);
            }
            if (bean.btn3Color > 0) {
                btnNatural.setTextColor(Tool.getColor((Context)ActivityStackManager.getInstance().getTopActivity(), bean.btn3Color));
            }
            if (bean.btnTxtSize > 0) {
                btnNatural.setTextSize((float)bean.btnTxtSize);
            }
        }
    }

    public static ConfigBean fixContext(ConfigBean bean) {
        Activity activity1 = null;
        if (!(bean.context instanceof Activity)) {
            Activity activity = ActivityStackManager.getInstance().getTopActivity();
            if (Tool.isUsable(activity)) {
                activity1 = activity;
            }
        } else {
            Activity activity = (Activity)bean.context;
            if (Tool.isUsable(activity)) {
                activity1 = activity;
            }
        }
        bean.context = activity1 != null ? activity1 : StyledDialog.context;
        Log.e((String)"tool", (String)("fixContext:" + bean.context));
        return bean;
    }

    public static boolean isUsable(Activity activity) {
        if (activity == null) {
            return false;
        }
        if (activity.isFinishing()) {
            return false;
        }
        return Build.VERSION.SDK_INT < 17 || !activity.isDestroyed();
    }

    public static ConfigBean newCustomDialog(ConfigBean bean) {
        Dialog dialog = new Dialog(bean.context);
        dialog.requestWindowFeature(1);
        bean.dialog = dialog;
        return bean;
    }

    public static ConfigBean setCancelable(ConfigBean bean) {
        if (bean.alertDialog != null) {
            bean.alertDialog.setCancelable(bean.cancelable);
            bean.alertDialog.setCanceledOnTouchOutside(bean.outsideTouchable);
        } else if (bean.dialog != null) {
            bean.dialog.setCancelable(bean.cancelable);
            bean.dialog.setCanceledOnTouchOutside(bean.outsideTouchable);
        }
        return bean;
    }

    public static void adjustStyle(final ConfigBean bean) {
        Tool.setBg(bean);
        Tool.setDim(bean);
        AlertDialog dialog = bean.dialog == null ? bean.alertDialog : bean.dialog;
        Window window = dialog.getWindow();
        window.setGravity(bean.gravity);
        if (!(bean.context instanceof Activity)) {
            window.setType(2005);
            WindowManager.LayoutParams params = window.getAttributes();
            if (params == null) {
                params = new WindowManager.LayoutParams(-2, -2);
            }
            params.format = 1;
            params.flags = 0x10440000;
            params.dimAmount = 0.2f;
            window.setAttributes(params);
            window.getDecorView().setOnKeyListener(new View.OnKeyListener(){

                public boolean onKey(View v, int keyCode, KeyEvent event) {
                    if (keyCode == 4 || event.getKeyCode() == 176) {
                        StyledDialog.dismiss(new Dialog[]{bean.alertDialog, bean.dialog});
                        return true;
                    }
                    return false;
                }
            });
            Tool.setHomeKeyListener(window, bean);
            window.setDimAmount(0.2f);
        }
    }

    private static void setHomeKeyListener(final Window window, final ConfigBean bean) {
        IntentFilter homeFilter = new IntentFilter("android.intent.action.CLOSE_SYSTEM_DIALOGS");
        bean.homeKeyReceiver = new BroadcastReceiver(){
            final String SYSTEM_DIALOG_REASON_KEY = "reason";
            final String SYSTEM_DIALOG_REASON_HOME_KEY = "homekey";

            public void onReceive(Context context, Intent intent) {
                String reason;
                String action = intent.getAction();
                if (action.equals("android.intent.action.CLOSE_SYSTEM_DIALOGS") && (reason = intent.getStringExtra("reason")) != null && reason.equals("homekey")) {
                    if (bean.type == 9) {
                        Tool.hideKeyBoard(window);
                    }
                    if (!(bean.context instanceof Activity)) {
                        Tool.dismiss(bean);
                    }
                    context.unregisterReceiver((BroadcastReceiver)this);
                }
            }
        };
        bean.context.registerReceiver(bean.homeKeyReceiver, homeFilter);
    }

    private static void setDim(ConfigBean bean) {
        if (bean.type == 14) {
            bean.isTransparentBehind = true;
        }
        if (bean.alertDialog != null) {
            if (bean.isTransparentBehind) {
                bean.alertDialog.getWindow().setDimAmount(0.0f);
            }
        } else if (bean.isTransparentBehind) {
            bean.dialog.getWindow().setDimAmount(0.0f);
        }
    }

    private static void setBg(ConfigBean bean) {
        if (bean.type == 13 && bean.hasBehaviour || bean.type == 12 || bean.type == 11 || bean.type == 15) {
            return;
        }
        if (bean.alertDialog != null) {
            if (bean.useTheShadowBg) {
                bean.alertDialog.getWindow().setBackgroundDrawableResource(R.drawable.shadow);
            } else if (bean.bgRes > 0) {
                bean.alertDialog.getWindow().setBackgroundDrawableResource(bean.bgRes);
            } else {
                bean.alertDialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            }
        } else {
            bean.dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        }
    }

    public static void adjustWH(Dialog dialog, ConfigBean bean) {
        if (dialog == null) {
            return;
        }
        Window window = dialog.getWindow();
        View rootView = window.getDecorView();
        WindowManager.LayoutParams wl = window.getAttributes();
        int width = window.getWindowManager().getDefaultDisplay().getWidth();
        int height = window.getWindowManager().getDefaultDisplay().getHeight();
        int measuredHeight = rootView.getMeasuredHeight();
        int measuredWidth = rootView.getMeasuredWidth();
        float widthRatio = 0.85f;
        float heightRatio = 0.0f;
        if (bean.type == 7) {
            widthRatio = 0.95f;
        } else if (bean.type == 8) {
            widthRatio = 0.9f;
        }
        if (width > height) {
            widthRatio = 0.5f;
        }
        if (bean.forceWidthPercent > 0.0f && bean.forceWidthPercent <= 1.0f) {
            widthRatio = bean.forceWidthPercent;
        }
        if ((float)measuredHeight > bean.maxHeightPercent * (float)height) {
            heightRatio = bean.maxHeightPercent;
        }
        if (bean.forceHeightPercent > 0.0f && bean.forceHeightPercent <= 1.0f) {
            heightRatio = bean.forceHeightPercent;
        }
        if (!Tool.istheTypeOfNotAdjust(bean)) {
            wl.width = (int)((float)width * widthRatio);
            if (heightRatio > 0.0f) {
                wl.height = (int)((float)height * heightRatio);
            }
            if (bean.type == 13 && !bean.hasBehaviour) {
                wl.height = measuredHeight;
            }
        }
        dialog.onWindowAttributesChanged(wl);
    }

    public static boolean istheTypeOfNotAdjust(ConfigBean bean) {
        switch (bean.type) {
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                return true;
            }
            case 13: {
                return bean.hasBehaviour;
            }
        }
        return false;
    }

    private static boolean isCustomType(ConfigBean bean) {
        switch (bean.type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public static void measureView(View child) {
        ViewGroup.LayoutParams p = child.getLayoutParams();
        if (p == null) {
            p = new ViewGroup.LayoutParams(-1, -2);
        }
        int lpHeight = p.height;
        int lpWidth = p.width;
        int childHeightSpec = lpHeight > 0 ? View.MeasureSpec.makeMeasureSpec((int)lpHeight, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int childWidthSpec = lpWidth > 0 ? View.MeasureSpec.makeMeasureSpec((int)lpHeight, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        child.measure(childWidthSpec, childHeightSpec);
    }

    public static int mesureHeight(View root, int id2) {
        View view;
        Tool.measureView(root);
        int height = root.getMeasuredHeight();
        int heightExtra = 0;
        if (id2 > 0 && (view = root.findViewById(id2)) != null) {
            Tool.measureView(view);
            heightExtra = view.getMeasuredHeight();
        }
        return height + heightExtra;
    }

    public static int mesureHeight(View root, View ... subViews) {
        Tool.measureView(root);
        int height = root.getMeasuredHeight();
        int heightExtra = 0;
        if (subViews != null && subViews.length > 0) {
            for (View view : subViews) {
                if (view.getVisibility() != 0) continue;
                Tool.measureView(view);
                heightExtra += view.getMeasuredHeight();
            }
        }
        return height + heightExtra;
    }

    public static int getColor(Context context, int colorRes) {
        if (context == null) {
            context = StyledDialog.context;
        }
        try {
            int color2 = context.getResources().getColor(colorRes);
            return color2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static void handleScrollInBottomSheetDialog(final AdapterView listView) {
        listView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (!listView.canScrollVertically(-1)) {
                    listView.requestDisallowInterceptTouchEvent(false);
                } else {
                    listView.requestDisallowInterceptTouchEvent(true);
                }
                return false;
            }
        });
    }

    public static void setBottomSheetDialogPeekHeight(final ConfigBean bean) {
        if (bean.hasBehaviour && bean.dialog instanceof BottomSheetDialog) {
            View view = bean.dialog.getWindow().findViewById(R.id.design_bottom_sheet);
            if (view == null) {
                return;
            }
            final BottomSheetBehavior bottomSheetBehavior = BottomSheetBehavior.from((View)view);
            bottomSheetBehavior.setBottomSheetCallback(new BottomSheetBehavior.BottomSheetCallback(){

                public void onStateChanged(@NonNull View bottomSheet, int newState) {
                    if (newState == 5) {
                        Tool.dismiss(bean);
                        bottomSheetBehavior.setState(4);
                    }
                }

                public void onSlide(@NonNull View bottomSheet, float slideOffset) {
                }
            });
            if (bean.bottomSheetDialogMaxHeightPercent > 0.0f && bean.bottomSheetDialogMaxHeightPercent < 1.0f) {
                int peekHeight = (int)(bean.bottomSheetDialogMaxHeightPercent * (float)ScreenUtil.getScreenHeight());
                bottomSheetBehavior.setPeekHeight(peekHeight);
            }
        }
    }

    public static void showKeyBoard(View edCount) {
        edCount.setFocusable(true);
        edCount.setFocusableInTouchMode(true);
        edCount.requestFocus();
        InputMethodManager imm = (InputMethodManager)StyledDialog.context.getSystemService("input_method");
        imm.showSoftInput(edCount, 2);
    }

    public static void hideKeyBorad(ConfigBean bean) {
        if (!bean.needSoftKeyboard) {
            return;
        }
        if (bean.viewHolder != null) {
            bean.viewHolder.hideKeyBoard();
        }
        if (bean.customContentHolder != null) {
            bean.customContentHolder.hideKeyBoard();
        }
    }

    public static void hideKeyBoard(View view) {
        InputMethodManager imm = (InputMethodManager)StyledDialog.context.getSystemService("input_method");
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static void hideKeyBoard(Window window) {
        InputMethodManager imm = (InputMethodManager)StyledDialog.context.getSystemService("input_method");
        imm.hideSoftInputFromWindow(window.getDecorView().getWindowToken(), 0);
    }

    public static void removeFromParent(View customView) {
        ViewParent parent = customView.getParent();
        if (parent != null) {
            ViewGroup group = (ViewGroup)parent;
            group.removeView(customView);
        }
    }
}

