/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.hash.core.bs;

import com.github.houbb.hash.api.IHash;
import com.github.houbb.hash.api.IHashContext;
import com.github.houbb.hash.api.IHashResult;
import com.github.houbb.hash.api.IHashResultHandler;
import com.github.houbb.hash.core.core.handler.HashResultHandlers;
import com.github.houbb.hash.core.core.hash.Hashes;
import com.github.houbb.hash.core.core.hash.context.HashContext;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class HashBs {
    private IHash hash = Hashes.md5();
    private int times = 1;
    private byte[] salt;
    private IHashContext hashContext;
    private Charset charset = StandardCharsets.UTF_8;

    private HashBs() {
    }

    public static HashBs newInstance() {
        return new HashBs();
    }

    public HashBs hash(IHash hash) {
        ArgUtil.notNull((Object)hash, (String)"hash");
        this.hash = hash;
        return this;
    }

    public HashBs times(int times) {
        this.times = times;
        return this;
    }

    public HashBs salt(byte[] salt) {
        this.salt = salt;
        return this;
    }

    public HashBs charset(Charset charset) {
        ArgUtil.notNull((Object)charset, (String)"charset");
        this.charset = charset;
        return this;
    }

    public synchronized HashBs init() {
        this.hashContext = HashContext.newInstance().salt(this.salt).times(this.times).charset(this.charset);
        return this;
    }

    public <T> T execute(byte[] source, IHashResultHandler<T> handler) {
        if (this.hashContext == null) {
            this.init();
        }
        IHashResult result = this.hash.hash(source, this.hashContext);
        return (T)handler.handle(result);
    }

    public <T> T execute(String source, IHashResultHandler<T> handler) {
        byte[] bytes = null;
        if (StringUtil.isNotEmpty((String)source)) {
            bytes = source.getBytes(this.charset);
        }
        return this.execute(bytes, handler);
    }

    public String execute(String source) {
        return this.execute(source, HashResultHandlers.hex());
    }
}

