/*
 * Decompiled with CFR 0.152.
 */
package com.hosopy.actioncable;

import com.hosopy.actioncable.Connection;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ConnectionMonitor {
    private static final int STALE_THRESHOLD = 6;
    private final Connection connection;
    private final ScheduledExecutorService pollExecutorService;
    private final boolean reconnection;
    private final int reconnectionMaxAttempts;
    private final int reconnectionDelay;
    private final int reconnectionDelayMax;
    private long pingedAt = 0L;
    private long disconnectedAt = 0L;
    private long startedAt = 0L;
    private long stoppedAt = 0L;
    private int reconnectAttempts = 0;

    ConnectionMonitor(Connection connection, Connection.Options options) {
        this.connection = connection;
        this.pollExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.reconnection = options.reconnection;
        this.reconnectionMaxAttempts = options.reconnectionMaxAttempts;
        this.reconnectionDelay = options.reconnectionDelay;
        this.reconnectionDelayMax = options.reconnectionDelayMax;
    }

    void recordConnect() {
        this.reset();
        this.pingedAt = ConnectionMonitor.now();
        this.disconnectedAt = 0L;
    }

    void recordDisconnect() {
        this.disconnectedAt = ConnectionMonitor.now();
    }

    void recordPing() {
        this.pingedAt = ConnectionMonitor.now();
    }

    void start() {
        this.reset();
        this.stoppedAt = 0L;
        this.startedAt = ConnectionMonitor.now();
        this.poll();
    }

    void stop() {
        this.stoppedAt = ConnectionMonitor.now();
    }

    private void reset() {
        this.reconnectAttempts = 0;
    }

    private void poll() {
        this.pollExecutorService.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (ConnectionMonitor.this.stoppedAt == 0L) {
                    ConnectionMonitor.this.reconnectIfStale();
                }
            }
        }, this.getInterval(), this.getInterval(), TimeUnit.MILLISECONDS);
    }

    private void reconnectIfStale() {
        if (this.reconnection && this.connectionIsStale() && this.reconnectAttempts < this.reconnectionMaxAttempts) {
            ++this.reconnectAttempts;
            if (!this.disconnectedRecently()) {
                this.connection.reopen();
            }
        }
    }

    private boolean connectionIsStale() {
        return ConnectionMonitor.secondsSince(this.pingedAt > 0L ? this.pingedAt : this.startedAt) > 6L;
    }

    private boolean disconnectedRecently() {
        return this.disconnectedAt != 0L && ConnectionMonitor.secondsSince(this.disconnectedAt) < 6L;
    }

    private long getInterval() {
        double interval = 5.0 * Math.log(this.reconnectAttempts + 1);
        return (long)ConnectionMonitor.clamp(interval, this.reconnectionDelay, this.reconnectionDelayMax) * 1000L;
    }

    private static long secondsSince(long time) {
        return (ConnectionMonitor.now() - time) / 1000L;
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    private static double clamp(double number, int min, int max) {
        return Math.max((double)min, Math.min((double)max, number));
    }
}

