/*
 * Decompiled with CFR 0.152.
 */
package com.hosopy.actioncable;

import com.hosopy.concurrent.EventLoop;
import com.hosopy.util.QueryStringUtils;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ws.WebSocket;
import com.squareup.okhttp.ws.WebSocketCall;
import com.squareup.okhttp.ws.WebSocketListener;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.URI;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import okio.Buffer;
import okio.BufferedSource;

public class Connection {
    private State state = State.CONNECTING;
    private URI uri;
    private Options options;
    private Listener listener;
    private WebSocket webSocket;
    private boolean isReopening = false;
    private WebSocketListener webSocketListener = new WebSocketListener(){

        public void onOpen(WebSocket webSocket, Response response) {
            Connection.this.state = State.OPEN;
            Connection.this.webSocket = webSocket;
            EventLoop.execute(new Runnable(){

                @Override
                public void run() {
                    if (Connection.this.listener != null) {
                        Connection.this.listener.onOpen();
                    }
                }
            });
        }

        public void onFailure(final IOException e, Response response) {
            EventLoop.execute(new Runnable(){

                @Override
                public void run() {
                    Connection.this.state = State.CLOSED;
                    if (Connection.this.listener != null) {
                        Connection.this.listener.onFailure(e);
                    }
                }
            });
        }

        public void onMessage(BufferedSource payload, WebSocket.PayloadType type) throws IOException {
            switch (type) {
                case TEXT: {
                    final String text = payload.readUtf8();
                    EventLoop.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (text != null && Connection.this.listener != null) {
                                Connection.this.listener.onMessage(text);
                            }
                        }
                    });
                }
            }
            payload.close();
        }

        public void onPong(Buffer payload) {
        }

        public void onClose(int code, String reason) {
            Connection.this.state = State.CLOSED;
            EventLoop.execute(new Runnable(){

                @Override
                public void run() {
                    Connection.this.state = State.CLOSED;
                    if (Connection.this.listener != null) {
                        Connection.this.listener.onClose();
                    }
                    if (Connection.this.isReopening) {
                        Connection.this.isReopening = false;
                        Connection.this.open();
                    }
                }
            });
        }
    };

    Connection(URI uri, Options options) {
        this.uri = uri;
        this.options = options;
    }

    void setListener(Listener listener) {
        this.listener = listener;
    }

    void open() {
        EventLoop.execute(new Runnable(){

            @Override
            public void run() {
                if (Connection.this.isOpen()) {
                    Connection.this.fireOnFailure(new IllegalStateException("Must close existing connection before opening"));
                } else {
                    Connection.this.doOpen();
                }
            }
        });
    }

    void close() {
        EventLoop.execute(new Runnable(){

            @Override
            public void run() {
                if (Connection.this.webSocket != null) {
                    try {
                        if (!Connection.this.isState(new State[]{State.CLOSING, State.CLOSED})) {
                            Connection.this.webSocket.close(1000, "connection closed manually");
                            Connection.this.state = State.CLOSING;
                        }
                    }
                    catch (IOException e) {
                        Connection.this.fireOnFailure(e);
                    }
                    catch (IllegalStateException e) {
                        Connection.this.fireOnFailure(e);
                    }
                }
            }
        });
    }

    void reopen() {
        if (this.isState(State.CLOSED)) {
            this.open();
        } else {
            this.isReopening = true;
            this.close();
        }
    }

    boolean isOpen() {
        return this.webSocket != null && this.isState(State.OPEN);
    }

    boolean send(final String data) {
        if (this.isOpen()) {
            EventLoop.execute(new Runnable(){

                @Override
                public void run() {
                    Connection.this.doSend(data);
                }
            });
            return true;
        }
        return false;
    }

    private void doOpen() {
        this.state = State.CONNECTING;
        OkHttpClient client = this.options.okHttpClientFactory != null ? this.options.okHttpClientFactory.createOkHttpClient() : new OkHttpClient();
        if (this.options.sslContext != null) {
            SSLSocketFactory factory = this.options.sslContext.getSocketFactory();
            client.setSslSocketFactory(factory);
        }
        if (this.options.hostnameVerifier != null) {
            client.setHostnameVerifier(this.options.hostnameVerifier);
        }
        if (this.options.cookieHandler != null) {
            client.setCookieHandler(this.options.cookieHandler);
        }
        String url = this.uri.toString();
        if (this.options.query != null) {
            url = url + "?" + QueryStringUtils.encode(this.options.query);
        }
        Request.Builder builder = new Request.Builder().url(url);
        if (this.options.headers != null) {
            for (Map.Entry<String, String> entry : this.options.headers.entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        Request request = builder.build();
        WebSocketCall webSocketCall = WebSocketCall.create((OkHttpClient)client, (Request)request);
        webSocketCall.enqueue(this.webSocketListener);
        client.getDispatcher().getExecutorService().shutdown();
    }

    private void doSend(String data) {
        block3: {
            if (this.webSocket != null) {
                try {
                    this.webSocket.sendMessage(WebSocket.PayloadType.TEXT, new Buffer().writeUtf8(data));
                }
                catch (IOException e) {
                    if (this.listener == null) break block3;
                    this.listener.onFailure(e);
                }
            }
        }
    }

    private boolean isState(State ... states) {
        for (State state : states) {
            if (this.state != state) continue;
            return true;
        }
        return false;
    }

    private void fireOnFailure(Exception e) {
        if (this.listener != null) {
            this.listener.onFailure(e);
        }
    }

    public static class Options {
        public SSLContext sslContext;
        public HostnameVerifier hostnameVerifier;
        public CookieHandler cookieHandler;
        public Map<String, String> query;
        public Map<String, String> headers;
        public boolean reconnection = false;
        public int reconnectionMaxAttempts = 30;
        public int reconnectionDelay = 3;
        public int reconnectionDelayMax = 30;
        public OkHttpClientFactory okHttpClientFactory;

        public static interface OkHttpClientFactory {
            public OkHttpClient createOkHttpClient();
        }
    }

    static interface Listener {
        public void onOpen();

        public void onFailure(Exception var1);

        public void onMessage(String var1);

        public void onClose();
    }

    private static enum State {
        CONNECTING,
        OPEN,
        CLOSING,
        CLOSED;

    }
}

