/*
 * Decompiled with CFR 0.152.
 */
package treeminer.scopelists.elements;

import java.util.List;
import treeminer.Scope;
import treeminer.scopelists.elements.SimpleScopeListElement;

public class ScopeVectorListElement
extends SimpleScopeListElement {
    private List<Scope> scopes;

    public ScopeVectorListElement(int tree, List<Scope> scopes) {
        super(tree);
        this.scopes = scopes;
    }

    public Scope getLastElement() {
        return this.scopes.get(this.scopes.size() - 1);
    }

    public List<Scope> getScopes() {
        return this.scopes;
    }

    @Override
    public int compareTo(SimpleScopeListElement o) {
        int compare = super.compareTo(o);
        if (compare == 0) {
            ScopeVectorListElement other = (ScopeVectorListElement)o;
            for (int i = 0; i < this.scopes.size(); ++i) {
                if (other.scopes.size() < i + 1) {
                    return -1;
                }
                int compareScopes = this.scopes.get(i).compareTo(other.scopes.get(i));
                if (compareScopes == 0) continue;
                return compareScopes;
            }
            return 0;
        }
        return compare;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ScopeVectorListElement)) {
            return false;
        }
        return this.compareTo((ScopeVectorListElement)other) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = result * 31 + this.scopes.hashCode();
        return result;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        builder.append(super.toString());
        builder.append(", ");
        builder.append(this.scopes);
        builder.append(")");
        return builder.toString();
    }
}

