/*
 * Decompiled with CFR 0.152.
 */
package treeminer.initialization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import treeminer.EquivalenceClass;
import treeminer.initialization.TreeMinerDistinctInitializer;
import treeminer.initialization.TreeMinerNonDistinctInitializer;

public class TreeMinerGeneralInitializer {
    private TreeMinerGeneralInitializer() {
    }

    public static EquivalenceClass findFrequentF1Subtrees(List<String> trees, int minSupport) {
        HashMap<String, Integer> labelFrequencies = new HashMap<String, Integer>();
        for (String tree : trees) {
            String[] labels;
            for (String label2 : labels = tree.split(" ")) {
                if (label2.equals("-")) continue;
                if (labelFrequencies.containsKey(label2)) {
                    labelFrequencies.put(label2, (Integer)labelFrequencies.get(label2) + 1);
                    continue;
                }
                labelFrequencies.put(label2, 1);
            }
        }
        TreeSet elementList = new TreeSet();
        labelFrequencies.forEach((label, frequency) -> {
            if (frequency >= minSupport) {
                elementList.add(new ImmutablePair(label, (Object)-1));
            }
        });
        return new EquivalenceClass("", new ArrayList<Pair<String, Integer>>(elementList));
    }

    public static List<EquivalenceClass> findFrequentF2Subtrees(EquivalenceClass f1, List<String> trees, boolean countMultipleOccurrences, int minSupport) {
        if (countMultipleOccurrences) {
            return TreeMinerNonDistinctInitializer.initialize(f1, trees, minSupport);
        }
        return TreeMinerDistinctInitializer.initialize(f1, trees, minSupport);
    }

    public static List<EquivalenceClass> generateCandidateEquivalenceClassesF2(EquivalenceClass f1) {
        ArrayList<EquivalenceClass> candidateEquivalenceClasses = new ArrayList<EquivalenceClass>();
        List<Pair<String, Integer>> f1Elements = f1.getElementList();
        for (int i = 0; i < f1Elements.size(); ++i) {
            ArrayList<Pair<String, Integer>> elementList = new ArrayList<Pair<String, Integer>>();
            for (int j = 0; j < f1Elements.size(); ++j) {
                elementList.add((Pair<String, Integer>)new ImmutablePair(f1Elements.get(j).getLeft(), (Object)0));
            }
            candidateEquivalenceClasses.add(new EquivalenceClass((String)f1Elements.get(i).getLeft(), elementList));
        }
        return candidateEquivalenceClasses;
    }
}

