/*
 * Decompiled with CFR 0.152.
 */
package treeminer.initialization;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.tuple.Pair;
import treeminer.EquivalenceClass;
import treeminer.Scope;
import treeminer.initialization.TreeMinerGeneralInitializer;
import treeminer.scopelists.elements.ScopeVectorListElement;
import treeminer.scopelists.elements.SimpleScopeListElement;
import treeminer.scopelists.representation.AScopeListRepresentation;
import treeminer.scopelists.representation.ScopeVectorListRepresentation;
import treeminer.util.TreeRepresentationUtils;

public class TreeMinerDistinctInitializer {
    private TreeMinerDistinctInitializer() {
    }

    public static List<EquivalenceClass> initialize(EquivalenceClass f1, List<String> trees, int minSupport) {
        TreeMap<String, AScopeListRepresentation<ScopeVectorListElement>> mapF2PatternToOccurence = new TreeMap<String, AScopeListRepresentation<ScopeVectorListElement>>();
        TreeMap<String, AScopeListRepresentation<ScopeVectorListElement>> mapF1PatternToOccurence = new TreeMap<String, AScopeListRepresentation<ScopeVectorListElement>>();
        TreeMinerDistinctInitializer.generateCandidateScopeListsF1F2NoMatchLabel(f1, mapF2PatternToOccurence, mapF1PatternToOccurence);
        mapF1PatternToOccurence.forEach(f1::addScopeListFor);
        for (int i = 0; i < trees.size(); ++i) {
            TreeMinerDistinctInitializer.findPatternsInTreeNoMatchLabel(trees.get(i), mapF2PatternToOccurence, mapF1PatternToOccurence, i);
        }
        List<EquivalenceClass> candidateEquivalenceClasses = TreeMinerGeneralInitializer.generateCandidateEquivalenceClassesF2(f1);
        return TreeMinerDistinctInitializer.filterF2CandidateClassesByPatternOccurrencesNoMatchLabel(candidateEquivalenceClasses, mapF2PatternToOccurence, minSupport);
    }

    private static void generateCandidateScopeListsF1F2NoMatchLabel(EquivalenceClass f1, TreeMap<String, AScopeListRepresentation<ScopeVectorListElement>> f2ScopeLists, TreeMap<String, AScopeListRepresentation<ScopeVectorListElement>> f1ScopeLists) {
        f1.getElementList().forEach(pairX -> {
            f1ScopeLists.put((String)pairX.getLeft(), new ScopeVectorListRepresentation());
            f1.getElementList().forEach(pairY -> {
                String pattern = String.format("%s%s%s%s%s", pairX.getLeft(), " ", pairY.getLeft(), " ", "-");
                ScopeVectorListRepresentation occurrences = new ScopeVectorListRepresentation();
                f2ScopeLists.put(pattern, occurrences);
            });
        });
    }

    private static void findPatternsInTreeNoMatchLabel(String tree, TreeMap<String, AScopeListRepresentation<ScopeVectorListElement>> mapF2PatternToOccurence, TreeMap<String, AScopeListRepresentation<ScopeVectorListElement>> mapF1PatternToOccurence, int i) {
        String[] treeRepresentation = tree.split(" ");
        Scope[] nodeScopes = new Scope[(int)Math.ceil((double)treeRepresentation.length / 2.0)];
        TreeMinerDistinctInitializer.findNodeScopesNoMatchLabel(treeRepresentation, nodeScopes);
        TreeMinerDistinctInitializer.findCandidateFrequenciesNoMatchLabel(mapF2PatternToOccurence, mapF1PatternToOccurence, i, treeRepresentation, nodeScopes);
    }

    private static void findNodeScopesNoMatchLabel(String[] treeRepresentation, Scope[] nodeScopes) {
        for (int j = 0; j < nodeScopes.length; ++j) {
            nodeScopes[j] = new Scope();
        }
        int atNode = -1;
        ArrayList<Integer> openScopes = new ArrayList<Integer>();
        for (String treeElement : treeRepresentation) {
            if (!treeElement.equals("-")) {
                nodeScopes[++atNode].setLowerBound(atNode);
                openScopes.add(atNode);
                continue;
            }
            int closeScopeIndex = (Integer)openScopes.get(openScopes.size() - 1);
            nodeScopes[closeScopeIndex].setUpperBound(atNode);
            openScopes.remove(openScopes.get(openScopes.size() - 1));
        }
        nodeScopes[0].setUpperBound(nodeScopes.length - 1);
    }

    private static void findCandidateFrequenciesNoMatchLabel(TreeMap<String, AScopeListRepresentation<ScopeVectorListElement>> mapF2PatternToOccurence, TreeMap<String, AScopeListRepresentation<ScopeVectorListElement>> mapF1PatternToOccurence, int i, String[] treeRepresentation, Scope[] nodeScopes) {
        int atNode = -1;
        for (int j = 0; j < treeRepresentation.length; ++j) {
            String treeElement = treeRepresentation[j];
            if (treeElement.equals("-")) continue;
            TreeMinerDistinctInitializer.addNewPatternNoMatchLabel(mapF1PatternToOccurence, i, nodeScopes, ++atNode, treeElement);
            TreeMinerDistinctInitializer.checkForDoublePatternNoMatchLabel(mapF2PatternToOccurence, i, treeRepresentation, nodeScopes, atNode, j, treeElement);
        }
    }

    private static void addNewPatternNoMatchLabel(TreeMap<String, AScopeListRepresentation<ScopeVectorListElement>> mapF1PatternToOccurence, int i, Scope[] nodeScopes, int atNode, String treeElement) {
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        scopes.add(nodeScopes[atNode]);
        ScopeVectorListElement entry = new ScopeVectorListElement(i, scopes);
        if (mapF1PatternToOccurence.get(treeElement) != null) {
            mapF1PatternToOccurence.get(treeElement).add(entry);
        }
    }

    private static void checkForDoublePatternNoMatchLabel(TreeMap<String, AScopeListRepresentation<ScopeVectorListElement>> mapF2PatternToOccurence, int i, String[] treeRepresentation, Scope[] nodeScopes, int atNode, int j, String treeElement) {
        int childLevel = 0;
        int childNumber = 0;
        for (int k = j + 1; k < treeRepresentation.length; ++k) {
            String potentialChild = treeRepresentation[k];
            if (!potentialChild.equals("-")) {
                ++childLevel;
                ArrayList<Scope> scopes = new ArrayList<Scope>();
                scopes.add(nodeScopes[atNode]);
                scopes.add(nodeScopes[atNode + ++childNumber]);
                ScopeVectorListElement f2entry = new ScopeVectorListElement(i, scopes);
                AScopeListRepresentation<ScopeVectorListElement> list = mapF2PatternToOccurence.get(String.format("%s%s%s%s%s", treeElement, " ", treeRepresentation[k], " ", "-"));
                if (list == null) continue;
                list.add(f2entry);
                continue;
            }
            if (--childLevel == -1) break;
        }
    }

    public static List<EquivalenceClass> filterF2CandidateClassesByPatternOccurrencesNoMatchLabel(List<EquivalenceClass> candidateEquivalenceClasses, SortedMap<String, AScopeListRepresentation<ScopeVectorListElement>> mapF2PatternToOccurence, int minSupport) {
        ArrayList<EquivalenceClass> newEquivalenceClasses = new ArrayList<EquivalenceClass>();
        candidateEquivalenceClasses.forEach(equivalenceClass -> {
            TreeMap<String, AScopeListRepresentation<? extends SimpleScopeListElement>> scopeLists = new TreeMap<String, AScopeListRepresentation<? extends SimpleScopeListElement>>();
            equivalenceClass.getElementList().forEach(element -> {
                String label = TreeRepresentationUtils.addNodeToTree(equivalenceClass.getPrefix(), (Pair<String, Integer>)element);
                AScopeListRepresentation scopeList = (AScopeListRepresentation)mapF2PatternToOccurence.get(label);
                scopeLists.put(label, scopeList);
            });
            equivalenceClass.setScopeLists(scopeLists);
            equivalenceClass.discardNonFrequentElements(minSupport);
            if (!equivalenceClass.getElementList().isEmpty()) {
                newEquivalenceClasses.add((EquivalenceClass)equivalenceClass);
            }
        });
        return newEquivalenceClasses;
    }
}

