/*
 * Decompiled with CFR 0.152.
 */
package treeminer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.tuple.Pair;
import treeminer.scopelists.elements.SimpleScopeListElement;
import treeminer.scopelists.representation.AScopeListRepresentation;
import treeminer.util.TreeRepresentationUtils;

public class EquivalenceClass {
    private String prefix;
    private List<Pair<String, Integer>> elementList;
    private SortedMap<String, AScopeListRepresentation<? extends SimpleScopeListElement>> scopeLists;

    public EquivalenceClass(String prefix, List<Pair<String, Integer>> elementList) {
        this.prefix = prefix;
        this.elementList = elementList;
        this.scopeLists = new TreeMap<String, AScopeListRepresentation<? extends SimpleScopeListElement>>();
    }

    public EquivalenceClass(String prefix) {
        this.prefix = prefix;
        this.elementList = new ArrayList<Pair<String, Integer>>();
        this.scopeLists = new TreeMap<String, AScopeListRepresentation<? extends SimpleScopeListElement>>();
    }

    public void discardNonFrequentElements(int minSupport) {
        TreeMap<String, AScopeListRepresentation<? extends SimpleScopeListElement>> newScopeLists = new TreeMap<String, AScopeListRepresentation<? extends SimpleScopeListElement>>();
        this.scopeLists.forEach((label, list) -> {
            if (list.size() >= minSupport) {
                HashSet distinctOccurrences = new HashSet();
                list.forEach(scope -> distinctOccurrences.add(scope.getTreeIndex()));
                if (distinctOccurrences.size() >= minSupport) {
                    newScopeLists.put((String)label, (AScopeListRepresentation<? extends SimpleScopeListElement>)list);
                }
            }
        });
        this.scopeLists = newScopeLists;
        ArrayList<Pair<String, Integer>> newElementList = new ArrayList<Pair<String, Integer>>();
        this.elementList.forEach(element -> {
            String subTree = TreeRepresentationUtils.addNodeToTree(this.prefix, (Pair<String, Integer>)element);
            if (this.scopeLists.get(subTree) != null && !((AScopeListRepresentation)this.scopeLists.get(subTree)).isEmpty()) {
                newElementList.add((Pair<String, Integer>)element);
            }
        });
        this.elementList = newElementList;
    }

    public List<Pair<String, Integer>> getElementList() {
        return this.elementList;
    }

    public void setElementList(List<Pair<String, Integer>> elementList) {
        this.elementList = elementList;
    }

    public void addElement(Pair<String, Integer> element) {
        this.elementList.add(element);
    }

    public AScopeListRepresentation<? extends SimpleScopeListElement> getScopeListFor(String subtree) {
        return (AScopeListRepresentation)this.scopeLists.get(subtree);
    }

    public void addScopeListFor(String subtree, AScopeListRepresentation<? extends SimpleScopeListElement> scopeList) {
        this.scopeLists.put(subtree, scopeList);
    }

    public SortedMap<String, AScopeListRepresentation<? extends SimpleScopeListElement>> getScopeLists() {
        return this.scopeLists;
    }

    public void setScopeLists(SortedMap<String, AScopeListRepresentation<? extends SimpleScopeListElement>> scopeLists) {
        this.scopeLists = scopeLists;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Equivalence Class with Prefix: ");
        builder.append(this.prefix);
        builder.append("\n");
        builder.append("Elements: \n");
        this.elementList.forEach(pair -> {
            builder.append(pair);
            builder.append(" ");
        });
        builder.append("\nScopes: \n");
        this.scopeLists.forEach((label, scopeList) -> {
            builder.append((String)label);
            builder.append(" ");
            builder.append(scopeList);
            builder.append("\n");
        });
        return builder.toString();
    }
}

