/*
 * Decompiled with CFR 0.152.
 */
package me.hgj.jetpackmvvm.core.net.interception;

import android.util.Log;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.hgj.jetpackmvvm.core.net.interception.logging.DefaultFormatPrinter;
import me.hgj.jetpackmvvm.core.net.interception.logging.FormatPrinter;
import me.hgj.jetpackmvvm.core.net.interception.logging.util.CharacterHandler;
import me.hgj.jetpackmvvm.core.net.interception.logging.util.UrlEncoderUtils;
import me.hgj.jetpackmvvm.core.net.interception.logging.util.ZipHelper;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bB\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0013\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J&\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lme/hgj/jetpackmvvm/core/net/interception/LogInterceptor;", "Lokhttp3/Interceptor;", "<init>", "()V", "printLevel", "Lme/hgj/jetpackmvvm/core/net/interception/LogInterceptor$Level;", "(Lme/hgj/jetpackmvvm/core/net/interception/LogInterceptor$Level;)V", "mPrinter", "Lme/hgj/jetpackmvvm/core/net/interception/logging/FormatPrinter;", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "printResult", "", "request", "Lokhttp3/Request;", "response", "logResponse", "", "parseContent", "responseBody", "Lokhttp3/ResponseBody;", "encoding", "clone", "Lokio/Buffer;", "Level", "Companion", "JetpackMvvm_release"})
public final class LogInterceptor
implements Interceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FormatPrinter mPrinter = new DefaultFormatPrinter();
    @NotNull
    private final Level printLevel = Level.ALL;

    public LogInterceptor() {
    }

    public LogInterceptor(@Nullable Level printLevel) {
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        block11: {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            request = chain.request();
            v0 = logRequest = this.printLevel == Level.ALL || this.printLevel != Level.NONE && this.printLevel == Level.REQUEST;
            if (!logRequest) break block11;
            if (request.body() == null) ** GOTO lbl-1000
            v1 = request.body();
            Intrinsics.checkNotNull((Object)v1);
            if (LogInterceptor.Companion.isParseable(v1.contentType())) {
                this.mPrinter.printJsonRequest(request, LogInterceptor.Companion.parseParams(request));
            } else lbl-1000:
            // 2 sources

            {
                this.mPrinter.printFileRequest(request);
            }
        }
        logResponse = this.printLevel == Level.ALL || this.printLevel != Level.NONE && this.printLevel == Level.RESPONSE;
        t1 = logResponse != false ? System.nanoTime() : 0L;
        originalResponse = null;
        try {
            var8_7 = chain.proceed(request);
        }
        catch (Exception e) {
            v2 = e.getMessage();
            if (v2 == null) {
                v2 = "";
            }
            Log.d((String)"Http Error: %s", (String)v2);
            throw e;
        }
        originalResponse = var8_7;
        t2 = logResponse != false ? System.nanoTime() : 0L;
        responseBody = originalResponse.body();
        bodyString = null;
        if (responseBody != null && LogInterceptor.Companion.isParseable(responseBody.contentType())) {
            bodyString = this.printResult(request, originalResponse, logResponse);
        }
        if (logResponse) {
            segmentList = request.url().encodedPathSegments();
            if (originalResponse.networkResponse() == null) {
                v3 = originalResponse.headers().toString();
            } else {
                v4 = originalResponse.networkResponse();
                Intrinsics.checkNotNull((Object)v4);
                v3 = v4.request().headers().toString();
            }
            header = v3;
            code = originalResponse.code();
            isSuccessful = originalResponse.isSuccessful();
            message = originalResponse.message();
            url = originalResponse.request().url().toString();
            if (responseBody != null && LogInterceptor.Companion.isParseable(responseBody.contentType())) {
                this.mPrinter.printJsonResponse(TimeUnit.NANOSECONDS.toMillis(t2 - t1), isSuccessful, code, header, responseBody.contentType(), bodyString, segmentList, message, url);
            } else {
                this.mPrinter.printFileResponse(TimeUnit.NANOSECONDS.toMillis(t2 - t1), isSuccessful, code, header, segmentList, message, url);
            }
        }
        return originalResponse;
    }

    private final String printResult(Request request, Response response, boolean logResponse) throws IOException {
        Object object;
        try {
            ResponseBody responseBody;
            ResponseBody responseBody2 = responseBody = response.newBuilder().build().body();
            Intrinsics.checkNotNull((Object)responseBody2);
            BufferedSource source = responseBody2.source();
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.buffer();
            String encoding = response.headers().get("Content-Encoding");
            Buffer clone = buffer.clone();
            object = this.parseContent(responseBody, encoding, clone);
        }
        catch (IOException e) {
            e.printStackTrace();
            object = "{\"error\": \"" + e.getMessage() + "\"}";
        }
        return object;
    }

    private final String parseContent(ResponseBody responseBody, String encoding, Buffer clone) {
        String string2;
        Charset charset = Charset.forName("UTF-8");
        ResponseBody responseBody2 = responseBody;
        Intrinsics.checkNotNull((Object)responseBody2);
        MediaType contentType = responseBody2.contentType();
        if (contentType != null) {
            charset = contentType.charset(charset);
        }
        if (StringsKt.equals((String)"gzip", (String)encoding, (boolean)true)) {
            string2 = ZipHelper.Companion.decompressForGzip(clone.readByteArray(), Companion.convertCharset(charset));
        } else if (StringsKt.equals((String)"zlib", (String)encoding, (boolean)true)) {
            string2 = ZipHelper.Companion.decompressToStringForZlib(clone.readByteArray(), Companion.convertCharset(charset));
        } else {
            Charset charset2 = charset;
            Intrinsics.checkNotNull((Object)charset2);
            string2 = clone.readString(charset2);
        }
        return string2;
    }

    @JvmStatic
    public static final boolean isJson(@Nullable MediaType mediaType) {
        return Companion.isJson(mediaType);
    }

    @JvmStatic
    public static final boolean isXml(@Nullable MediaType mediaType) {
        return Companion.isXml(mediaType);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\f\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\r\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0012\u0010\u000e\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\u0012\u0010\u000f\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\u0010\u0010\u0010\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\u0011\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a8\u0006\u0015"}, d2={"Lme/hgj/jetpackmvvm/core/net/interception/LogInterceptor$Companion;", "", "<init>", "()V", "parseParams", "", "request", "Lokhttp3/Request;", "isParseable", "", "mediaType", "Lokhttp3/MediaType;", "isText", "isPlain", "isJson", "isXml", "isHtml", "isForm", "convertCharset", "charset", "Ljava/nio/charset/Charset;", "JetpackMvvm_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String parseParams(@NotNull Request request) throws UnsupportedEncodingException {
            Object object;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            try {
                String json;
                RequestBody requestBody = request.newBuilder().build().body();
                if (requestBody == null) {
                    return "";
                }
                RequestBody body = requestBody;
                Buffer requestbuffer = new Buffer();
                body.writeTo((BufferedSink)requestbuffer);
                Charset charset = Charset.forName("UTF-8");
                MediaType contentType = body.contentType();
                if (contentType != null) {
                    charset = contentType.charset(charset);
                }
                Charset charset2 = charset;
                Intrinsics.checkNotNull((Object)charset2);
                String string2 = json = requestbuffer.readString(charset2);
                Intrinsics.checkNotNull((Object)string2);
                if (UrlEncoderUtils.Companion.hasUrlEncoded(string2)) {
                    String string3 = URLDecoder.decode(json, this.convertCharset(charset));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"decode(...)");
                    json = string3;
                }
                object = CharacterHandler.Companion.jsonFormat(json);
            }
            catch (IOException e) {
                e.printStackTrace();
                object = "{\"error\": \"" + e.getMessage() + "\"}";
            }
            return object;
        }

        public final boolean isParseable(@Nullable MediaType mediaType) {
            MediaType mediaType2 = mediaType;
            return (mediaType2 != null ? mediaType2.type() : null) == null ? false : this.isText(mediaType) || this.isPlain(mediaType) || this.isJson(mediaType) || this.isForm(mediaType) || this.isHtml(mediaType) || this.isXml(mediaType);
        }

        public final boolean isText(@Nullable MediaType mediaType) {
            MediaType mediaType2 = mediaType;
            return (mediaType2 != null ? mediaType2.type() : null) == null ? false : Intrinsics.areEqual((Object)"text", (Object)mediaType.type());
        }

        public final boolean isPlain(@Nullable MediaType mediaType) {
            boolean bl;
            MediaType mediaType2 = mediaType;
            if ((mediaType2 != null ? mediaType2.subtype() : null) == null) {
                bl = false;
            } else {
                String string2 = mediaType.subtype().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                bl = StringsKt.contains$default((CharSequence)string2, (CharSequence)"plain", (boolean)false, (int)2, null);
            }
            return bl;
        }

        @JvmStatic
        public final boolean isJson(@Nullable MediaType mediaType) {
            boolean bl;
            MediaType mediaType2 = mediaType;
            if ((mediaType2 != null ? mediaType2.subtype() : null) == null) {
                bl = false;
            } else {
                String string2 = mediaType.subtype();
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                bl = StringsKt.contains$default((CharSequence)string3, (CharSequence)"json", (boolean)false, (int)2, null);
            }
            return bl;
        }

        @JvmStatic
        public final boolean isXml(@Nullable MediaType mediaType) {
            boolean bl;
            MediaType mediaType2 = mediaType;
            if ((mediaType2 != null ? mediaType2.subtype() : null) == null) {
                bl = false;
            } else {
                String string2 = mediaType.subtype();
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                bl = StringsKt.contains$default((CharSequence)string3, (CharSequence)"xml", (boolean)false, (int)2, null);
            }
            return bl;
        }

        public final boolean isHtml(@Nullable MediaType mediaType) {
            boolean bl;
            MediaType mediaType2 = mediaType;
            if ((mediaType2 != null ? mediaType2.subtype() : null) == null) {
                bl = false;
            } else {
                String string2 = mediaType.subtype();
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                bl = StringsKt.contains$default((CharSequence)string3, (CharSequence)"html", (boolean)false, (int)2, null);
            }
            return bl;
        }

        public final boolean isForm(@Nullable MediaType mediaType) {
            boolean bl;
            MediaType mediaType2 = mediaType;
            if ((mediaType2 != null ? mediaType2.subtype() : null) == null) {
                bl = false;
            } else {
                String string2 = mediaType.subtype();
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                bl = StringsKt.contains$default((CharSequence)string3, (CharSequence)"x-www-form-urlencoded", (boolean)false, (int)2, null);
            }
            return bl;
        }

        @NotNull
        public final String convertCharset(@Nullable Charset charset) {
            String string2;
            String s = String.valueOf(charset);
            int i = StringsKt.indexOf$default((CharSequence)s, (String)"[", (int)0, (boolean)false, (int)6, null);
            if (i == -1) {
                string2 = s;
            } else {
                String string3 = s.substring(i + 1, s.length() - 1);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            }
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lme/hgj/jetpackmvvm/core/net/interception/LogInterceptor$Level;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "REQUEST", "RESPONSE", "ALL", "JetpackMvvm_release"})
    public static final class Level
    extends Enum<Level> {
        public static final /* enum */ Level NONE = new Level();
        public static final /* enum */ Level REQUEST = new Level();
        public static final /* enum */ Level RESPONSE = new Level();
        public static final /* enum */ Level ALL = new Level();
        private static final /* synthetic */ Level[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Level[] values() {
            return (Level[])$VALUES.clone();
        }

        public static Level valueOf(String value) {
            return Enum.valueOf(Level.class, value);
        }

        @NotNull
        public static EnumEntries<Level> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = levelArray = new Level[]{Level.NONE, Level.REQUEST, Level.RESPONSE, Level.ALL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

