/*
 * Decompiled with CFR 0.152.
 */
package com.obsez.android.lib.filechooser.internals;

import com.obsez.android.lib.filechooser.internals.FileUtil;
import java.io.File;
import java.io.FileFilter;

public class ExtFileFilter
implements FileFilter {
    boolean m_allowHidden;
    boolean m_onlyDirectory;
    String[] m_ext;

    public ExtFileFilter() {
        this(false, false, new String[0]);
    }

    public ExtFileFilter(String ... ext_list) {
        this(false, false, ext_list);
    }

    public ExtFileFilter(boolean dirOnly, boolean hidden, String ... ext_list) {
        this.m_allowHidden = hidden;
        this.m_onlyDirectory = dirOnly;
        this.m_ext = ext_list;
    }

    @Override
    public boolean accept(File pathname) {
        if (!this.m_allowHidden && pathname.isHidden()) {
            return false;
        }
        if (this.m_onlyDirectory && !pathname.isDirectory()) {
            return false;
        }
        if (this.m_ext == null) {
            return true;
        }
        if (pathname.isDirectory()) {
            return true;
        }
        String ext = FileUtil.getExtensionWithoutDot(pathname);
        for (String e : this.m_ext) {
            if (!ext.equalsIgnoreCase(e)) continue;
            return true;
        }
        return false;
    }
}

