/*
 * Decompiled with CFR 0.152.
 */
package com.obsez.android.lib.filechooser.permissions;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import com.obsez.android.lib.filechooser.permissions.PermissionActivity;
import java.util.Random;

public final class PermissionsUtil {
    public static final String TAG = PermissionsUtil.class.getName();
    private static final SparseArray<OnPermissionListener> _permissionListeners = new SparseArray();
    private static final Random _random = new Random();

    public static void checkPermissions(@NonNull Context context, @Nullable OnPermissionListener onPermissionListener, String ... permissions) {
        if (Build.VERSION.SDK_INT < 23 || permissions.length == 0) {
            if (onPermissionListener != null) {
                onPermissionListener.onPermissionGranted(permissions);
            }
            return;
        }
        int requestCode = _random.nextInt(1024);
        _permissionListeners.put(requestCode, (Object)onPermissionListener);
        Intent intent = new Intent(context, PermissionActivity.class);
        intent.putExtra("PERMISSIONS", permissions);
        intent.putExtra("REQUEST_CODE", requestCode);
        context.startActivity(intent);
    }

    static OnPermissionListener getPermissionListener(int requestCode) {
        OnPermissionListener listener = (OnPermissionListener)_permissionListeners.get(requestCode, null);
        _permissionListeners.remove(requestCode);
        return listener;
    }

    public static interface OnPermissionListener {
        public void onPermissionGranted(String[] var1);

        public void onPermissionDenied(String[] var1);

        public void onShouldShowRequestPermissionRationale(String[] var1);
    }
}

