/*
 * Decompiled with CFR 0.152.
 */
package com.obsez.android.lib.filechooser.tool;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;
import com.obsez.android.lib.filechooser.R;
import com.obsez.android.lib.filechooser.internals.FileUtil;
import com.obsez.android.lib.filechooser.internals.UiUtil;
import com.obsez.android.lib.filechooser.internals.WrappedDrawable;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class DirAdapter
extends ArrayAdapter<File> {
    private static SimpleDateFormat _formatter;
    private List<File> _entries;
    private Drawable _defaultFolderIcon = null;
    private Drawable _defaultFileIcon = null;
    private boolean _resolveFileType = false;

    public DirAdapter(Context cxt, List<File> entries, int resId) {
        super(cxt, resId, R.id.text1, entries);
        this.init(entries, null);
    }

    public DirAdapter(Context cxt, List<File> entries, int resId, String dateFormat) {
        super(cxt, resId, R.id.text1, entries);
        this.init(entries, dateFormat);
    }

    public DirAdapter(Context cxt, List<File> entries, int resource, int textViewResourceId) {
        super(cxt, resource, textViewResourceId, entries);
        this.init(entries, null);
    }

    @SuppressLint(value={"SimpleDateFormat"})
    private void init(List<File> entries, String dateFormat) {
        _formatter = new SimpleDateFormat(dateFormat != null && !"".equals(dateFormat.trim()) ? dateFormat.trim() : "yyyy/MM/dd HH:mm:ss");
        this._entries = entries;
        this._defaultFolderIcon = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_folder);
        this._defaultFileIcon = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_file);
    }

    @NonNull
    public View getView(int position, View convertView, @NonNull ViewGroup parent) {
        ViewGroup rl = (ViewGroup)super.getView(position, convertView, parent);
        TextView tvName = (TextView)rl.findViewById(R.id.text1);
        TextView tvSize = (TextView)rl.findViewById(R.id.txt_size);
        TextView tvDate = (TextView)rl.findViewById(R.id.txt_date);
        tvDate.setVisibility(0);
        File file = this._entries.get(position);
        tvName.setText((CharSequence)file.getName());
        if (file.isDirectory()) {
            Drawable folderIcon = this._defaultFolderIcon;
            tvName.setCompoundDrawablesWithIntrinsicBounds(folderIcon, null, null, null);
            tvSize.setText((CharSequence)"");
            if (!this._entries.get(position).getName().trim().equals("..")) {
                tvDate.setText((CharSequence)_formatter.format(new Date(file.lastModified())));
            } else {
                tvDate.setVisibility(8);
            }
        } else {
            Drawable d = null;
            if (this._resolveFileType && (d = UiUtil.resolveFileTypeIcon(this.getContext(), Uri.fromFile((File)file))) != null) {
                d = new WrappedDrawable(d, 24.0f, 24.0f);
            }
            if (d == null) {
                d = this._defaultFileIcon;
            }
            tvName.setCompoundDrawablesWithIntrinsicBounds(d, null, null, null);
            tvSize.setText((CharSequence)FileUtil.getReadableFileSize(file.length()));
            tvDate.setText((CharSequence)_formatter.format(new Date(file.lastModified())));
        }
        return rl;
    }

    public Drawable getDefaultFolderIcon() {
        return this._defaultFolderIcon;
    }

    public void setDefaultFolderIcon(Drawable defaultFolderIcon) {
        this._defaultFolderIcon = defaultFolderIcon;
    }

    public Drawable getDefaultFileIcon() {
        return this._defaultFileIcon;
    }

    public void setDefaultFileIcon(Drawable defaultFileIcon) {
        this._defaultFileIcon = defaultFileIcon;
    }

    public boolean isResolveFileType() {
        return this._resolveFileType;
    }

    public void setResolveFileType(boolean resolveFileType) {
        this._resolveFileType = resolveFileType;
    }
}

