/*
 * Decompiled with CFR 0.152.
 */
package com.obsez.android.lib.filechooser.internals;

import java.io.File;
import java.text.DecimalFormat;

public class FileUtil {
    public static String getExtension(File file) {
        if (file == null) {
            return null;
        }
        int dot = file.getName().lastIndexOf(".");
        if (dot >= 0) {
            return file.getName().substring(dot);
        }
        return "";
    }

    public static String getExtensionWithoutDot(File file) {
        String ext = FileUtil.getExtension(file);
        if (ext.length() == 0) {
            return ext;
        }
        return ext.substring(1);
    }

    public static String getReadableFileSize(long size) {
        int BYTES_IN_KILOBYTES = 1024;
        DecimalFormat dec = new DecimalFormat("###.#");
        String KILOBYTES = " KB";
        String MEGABYTES = " MB";
        String GIGABYTES = " GB";
        float fileSize = 0.0f;
        String suffix = " KB";
        if (size > 1024L && (fileSize = (float)(size / 1024L)) > 1024.0f) {
            if ((fileSize /= 1024.0f) > 1024.0f) {
                fileSize /= 1024.0f;
                suffix = " GB";
            } else {
                suffix = " MB";
            }
        }
        return String.valueOf(dec.format(fileSize) + suffix);
    }
}

