/*
 * Decompiled with CFR 0.152.
 */
package com.hcaptcha.sdk;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.Serializable;

final class HCaptchaCompat {
    private HCaptchaCompat() {
    }

    public static <T extends Serializable> T getSerializable(Bundle bundle, @Nullable String string, Class<T> clazz) {
        if (Build.VERSION.SDK_INT >= 33) {
            return (T)bundle.getSerializable(string, clazz);
        }
        return (T)bundle.getSerializable(string);
    }

    public static <T extends Parcelable> T getParcelable(Bundle bundle, @Nullable String string, Class<T> clazz) {
        if (Build.VERSION.SDK_INT >= 33) {
            return (T)((Parcelable)bundle.getParcelable(string, clazz));
        }
        return (T)bundle.getParcelable(string);
    }

    public static ApplicationInfo getApplicationInfo(@NonNull Context context) {
        if (Build.VERSION.SDK_INT >= 33) {
            return context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.ApplicationInfoFlags.of((long)128L));
        }
        return context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
    }
}

