/*
 * Decompiled with CFR 0.152.
 */
package com.hcaptcha.sdk;

import android.content.Context;
import android.content.pm.PackageManager;
import android.util.AndroidRuntimeException;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import com.hcaptcha.sdk.HCaptchaCompat;
import com.hcaptcha.sdk.HCaptchaConfig;
import com.hcaptcha.sdk.HCaptchaDialogFragment;
import com.hcaptcha.sdk.HCaptchaError;
import com.hcaptcha.sdk.HCaptchaException;
import com.hcaptcha.sdk.HCaptchaHeadlessWebView;
import com.hcaptcha.sdk.HCaptchaInternalConfig;
import com.hcaptcha.sdk.HCaptchaLog;
import com.hcaptcha.sdk.HCaptchaSize;
import com.hcaptcha.sdk.HCaptchaStateListener;
import com.hcaptcha.sdk.HCaptchaTokenResponse;
import com.hcaptcha.sdk.IHCaptcha;
import com.hcaptcha.sdk.IHCaptchaVerifier;
import com.hcaptcha.sdk.tasks.Task;
import lombok.NonNull;

public final class HCaptcha
extends Task<HCaptchaTokenResponse>
implements IHCaptcha {
    public static final String META_SITE_KEY = "com.hcaptcha.sdk.site-key";
    @NonNull
    private final FragmentActivity activity;
    @Nullable
    private IHCaptchaVerifier captchaVerifier;
    @Nullable
    private HCaptchaConfig config;
    @NonNull
    private final HCaptchaInternalConfig internalConfig;

    private HCaptcha(@NonNull FragmentActivity fragmentActivity, @NonNull HCaptchaInternalConfig hCaptchaInternalConfig) {
        if (fragmentActivity != null) {
            if (hCaptchaInternalConfig != null) {
                HCaptcha hCaptcha = this;
                hCaptcha.activity = fragmentActivity;
                hCaptcha.internalConfig = hCaptchaInternalConfig;
                return;
            }
            throw new NullPointerException("internalConfig is marked non-null but is null");
        }
        throw new NullPointerException("activity is marked non-null but is null");
    }

    public static HCaptcha getClient(@NonNull FragmentActivity fragmentActivity) {
        if (fragmentActivity != null) {
            return new HCaptcha(fragmentActivity, HCaptchaInternalConfig.builder().build());
        }
        throw new NullPointerException("activity is marked non-null but is null");
    }

    public static HCaptcha getClient(@NonNull FragmentActivity fragmentActivity, @NonNull HCaptchaInternalConfig hCaptchaInternalConfig) {
        if (fragmentActivity != null) {
            if (hCaptchaInternalConfig != null) {
                return new HCaptcha(fragmentActivity, hCaptchaInternalConfig);
            }
            throw new NullPointerException("internalConfig is marked non-null but is null");
        }
        throw new NullPointerException("activity is marked non-null but is null");
    }

    private HCaptcha startVerification() {
        HCaptcha hCaptcha = this;
        HCaptchaLog.d("HCaptcha.startVerification");
        hCaptcha.handler.removeCallbacksAndMessages(null);
        IHCaptchaVerifier iHCaptchaVerifier = hCaptcha.captchaVerifier;
        if (iHCaptchaVerifier == null) {
            this.setException(new HCaptchaException(HCaptchaError.ERROR));
        } else {
            iHCaptchaVerifier.startVerification(this.activity);
        }
        return this;
    }

    @Override
    public HCaptcha setup() {
        try {
            String string = HCaptchaCompat.getApplicationInfo((Context)this.activity).metaData.getString(META_SITE_KEY);
            if (string != null) {
                return this.setup(string);
            }
            throw new IllegalStateException("The site-key is missing. You can pass it by adding com.hcaptcha.sdk.site-key as meta-data to AndroidManifest.xml or as an argument for setup/verifyWithHCaptcha methods.");
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new IllegalStateException(nameNotFoundException);
        }
    }

    @Override
    public HCaptcha setup(@NonNull String string) {
        if (string != null) {
            return this.setup(HCaptchaConfig.builder().siteKey(string).build());
        }
        throw new NullPointerException("siteKey is marked non-null but is null");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HCaptcha setup(@NonNull HCaptchaConfig hCaptchaConfig) {
        HCaptchaStateListener hCaptchaStateListener;
        if (hCaptchaConfig == null) throw new NullPointerException("inputConfig is marked non-null but is null");
        HCaptchaLog.sDiagnosticsLogEnabled = hCaptchaConfig.getDiagnosticLog();
        HCaptchaLog.d("HCaptcha.setup");
        HCaptchaStateListener hCaptchaStateListener2 = hCaptchaStateListener;
        hCaptchaStateListener = new HCaptchaStateListener(){

            @Override
            public void onOpen() {
                HCaptcha.this.captchaOpened();
            }

            @Override
            public void onSuccess(String string) {
                1 v0 = hCaptcha2;
                HCaptchaLog.d("HCaptcha.onSuccess");
                HCaptcha hCaptcha = v0.HCaptcha.this;
                hCaptcha.scheduleCaptchaExpired(hCaptcha.config.getTokenExpiration());
                HCaptcha hCaptcha2 = v0.HCaptcha.this;
                hCaptcha2.setResult(new HCaptchaTokenResponse(string, hCaptcha2.handler));
            }

            @Override
            public void onFailure(HCaptchaException hCaptchaException) {
                HCaptchaLog.d("HCaptcha.onFailure");
                HCaptcha.this.setException(hCaptchaException);
            }
        };
        try {
            if (Boolean.TRUE.equals(hCaptchaConfig.getHideDialog())) {
                HCaptcha hCaptcha = this;
                hCaptchaConfig = hCaptchaConfig.toBuilder().size(HCaptchaSize.INVISIBLE).loading(Boolean.FALSE).build();
                hCaptcha.config = hCaptchaConfig;
                HCaptcha hCaptcha2 = this;
                FragmentActivity fragmentActivity = hCaptcha2.activity;
                HCaptchaInternalConfig hCaptchaInternalConfig = hCaptcha2.internalConfig;
                hCaptcha.captchaVerifier = new HCaptchaHeadlessWebView(fragmentActivity, hCaptchaConfig, hCaptchaInternalConfig, hCaptchaStateListener2);
                return this;
            }
            this.captchaVerifier = HCaptchaDialogFragment.newInstance(hCaptchaConfig, this.internalConfig, hCaptchaStateListener2);
            this.config = hCaptchaConfig;
            return this;
        }
        catch (AndroidRuntimeException androidRuntimeException) {
            hCaptchaStateListener2.onFailure(new HCaptchaException(HCaptchaError.ERROR));
        }
        return this;
    }

    @Override
    public HCaptcha verifyWithHCaptcha() {
        if (this.captchaVerifier == null) {
            this.setup();
        }
        return this.startVerification();
    }

    @Override
    public HCaptcha verifyWithHCaptcha(@NonNull String string) {
        if (string != null) {
            HCaptchaConfig hCaptchaConfig;
            if (this.captchaVerifier == null || (hCaptchaConfig = this.config) == null || !string.equals(hCaptchaConfig.getSiteKey())) {
                this.setup(string);
            }
            return this.startVerification();
        }
        throw new NullPointerException("siteKey is marked non-null but is null");
    }

    @Override
    public HCaptcha verifyWithHCaptcha(@NonNull HCaptchaConfig hCaptchaConfig) {
        if (hCaptchaConfig != null) {
            if (this.captchaVerifier == null || !hCaptchaConfig.equals(this.config)) {
                this.setup(hCaptchaConfig);
            }
            return this.startVerification();
        }
        throw new NullPointerException("inputConfig is marked non-null but is null");
    }

    @Override
    public void reset() {
        IHCaptchaVerifier iHCaptchaVerifier = this.captchaVerifier;
        if (iHCaptchaVerifier != null) {
            iHCaptchaVerifier.reset();
            this.captchaVerifier = null;
        }
    }
}

