/*
 * Decompiled with CFR 0.152.
 */
package info.mqtt.android.service.room;

import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteConnectionUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteStatement;
import info.mqtt.android.service.QoS;
import info.mqtt.android.service.room.Converters;
import info.mqtt.android.service.room.MqMessageDao;
import info.mqtt.android.service.room.entity.MqMessageEntity;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\bH\u0016J!\u0010\u0017\u001a\u00020\u00162\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0018\"\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0003\u00a2\u0006\u0002\b\u001aJ\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001dH\u0016J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Linfo/mqtt/android/service/room/MqMessageDao_Impl;", "Linfo/mqtt/android/service/room/MqMessageDao;", "__db", "Landroidx/room/RoomDatabase;", "<init>", "(Landroidx/room/RoomDatabase;)V", "all", "", "Linfo/mqtt/android/service/room/entity/MqMessageEntity;", "getAll", "()Ljava/util/List;", "__insertAdapterOfMqMessageEntity", "Landroidx/room/EntityInsertAdapter;", "__converters", "Linfo/mqtt/android/service/room/Converters;", "__deleteAdapterOfMqMessageEntity", "Landroidx/room/EntityDeleteOrUpdateAdapter;", "__updateAdapterOfMqMessageEntity", "insert", "", "mqMessageEntity", "delete", "", "updateAll", "", "([Linfo/mqtt/android/service/room/entity/MqMessageEntity;)V", "_privateGetAll", "allArrived", "clientHandle", "", "deleteId", "", "id", "deleteClientHandle", "Companion", "serviceLibrary_release"})
public final class MqMessageDao_Impl
implements MqMessageDao {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RoomDatabase __db;
    @NotNull
    private final EntityInsertAdapter<MqMessageEntity> __insertAdapterOfMqMessageEntity;
    @NotNull
    private final Converters __converters;
    @NotNull
    private final EntityDeleteOrUpdateAdapter<MqMessageEntity> __deleteAdapterOfMqMessageEntity;
    @NotNull
    private final EntityDeleteOrUpdateAdapter<MqMessageEntity> __updateAdapterOfMqMessageEntity;

    public MqMessageDao_Impl(@NotNull RoomDatabase __db) {
        Intrinsics.checkNotNullParameter((Object)__db, (String)"__db");
        this.__converters = new Converters();
        this.__db = __db;
        this.__insertAdapterOfMqMessageEntity = (EntityInsertAdapter)new EntityInsertAdapter<MqMessageEntity>(){

            protected String createQuery() {
                return "INSERT OR REPLACE INTO `MqMessageEntity` (`messageId`,`clientHandle`,`topic`,`mqttMessage`,`qos`,`retained`,`duplicate`,`timestamp`) VALUES (?,?,?,?,?,?,?,?)";
            }

            protected void bind(SQLiteStatement statement, MqMessageEntity entity) {
                Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                statement.bindText(1, entity.getMessageId());
                statement.bindText(2, entity.getClientHandle());
                statement.bindText(3, entity.getTopic());
                String _tmp = __converters.fromMqttMessage(entity.getMqttMessage());
                statement.bindText(4, _tmp);
                int _tmp_1 = __converters.fromQoS(entity.getQos());
                statement.bindLong(5, (long)_tmp_1);
                int _tmp_2 = entity.getRetained() ? 1 : 0;
                statement.bindLong(6, (long)_tmp_2);
                int _tmp_3 = entity.getDuplicate() ? 1 : 0;
                statement.bindLong(7, (long)_tmp_3);
                statement.bindLong(8, entity.getTimestamp());
            }
        };
        this.__deleteAdapterOfMqMessageEntity = (EntityDeleteOrUpdateAdapter)new EntityDeleteOrUpdateAdapter<MqMessageEntity>(){

            protected String createQuery() {
                return "DELETE FROM `MqMessageEntity` WHERE `messageId` = ?";
            }

            protected void bind(SQLiteStatement statement, MqMessageEntity entity) {
                Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                statement.bindText(1, entity.getMessageId());
            }
        };
        this.__updateAdapterOfMqMessageEntity = (EntityDeleteOrUpdateAdapter)new EntityDeleteOrUpdateAdapter<MqMessageEntity>(){

            protected String createQuery() {
                return "UPDATE OR ABORT `MqMessageEntity` SET `messageId` = ?,`clientHandle` = ?,`topic` = ?,`mqttMessage` = ?,`qos` = ?,`retained` = ?,`duplicate` = ?,`timestamp` = ? WHERE `messageId` = ?";
            }

            protected void bind(SQLiteStatement statement, MqMessageEntity entity) {
                Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                statement.bindText(1, entity.getMessageId());
                statement.bindText(2, entity.getClientHandle());
                statement.bindText(3, entity.getTopic());
                String _tmp = __converters.fromMqttMessage(entity.getMqttMessage());
                statement.bindText(4, _tmp);
                int _tmp_1 = __converters.fromQoS(entity.getQos());
                statement.bindLong(5, (long)_tmp_1);
                int _tmp_2 = entity.getRetained() ? 1 : 0;
                statement.bindLong(6, (long)_tmp_2);
                int _tmp_3 = entity.getDuplicate() ? 1 : 0;
                statement.bindLong(7, (long)_tmp_3);
                statement.bindLong(8, entity.getTimestamp());
                statement.bindText(9, entity.getMessageId());
            }
        };
    }

    @Override
    @NotNull
    public List<MqMessageEntity> getAll() {
        return this._privateGetAll();
    }

    @Override
    public long insert(@NotNull MqMessageEntity mqMessageEntity) {
        Intrinsics.checkNotNullParameter((Object)mqMessageEntity, (String)"mqMessageEntity");
        return ((Number)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> MqMessageDao_Impl.insert$lambda$0(this, mqMessageEntity, arg_0))).longValue();
    }

    @Override
    public void delete(@NotNull MqMessageEntity mqMessageEntity) {
        Intrinsics.checkNotNullParameter((Object)mqMessageEntity, (String)"mqMessageEntity");
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> MqMessageDao_Impl.delete$lambda$1(this, mqMessageEntity, arg_0));
    }

    @Override
    public void updateAll(MqMessageEntity ... mqMessageEntity) {
        Intrinsics.checkNotNullParameter((Object)mqMessageEntity, (String)"mqMessageEntity");
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> MqMessageDao_Impl.updateAll$lambda$2(this, mqMessageEntity, arg_0));
    }

    @JvmName(name="_privateGetAll")
    private final List<MqMessageEntity> _privateGetAll() {
        String _sql = "SELECT * FROM MQMessageEntity";
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> MqMessageDao_Impl.getAll$lambda$3(_sql, this, arg_0));
    }

    @Override
    @NotNull
    public List<MqMessageEntity> allArrived(@NotNull String clientHandle) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        String _sql = "SELECT * FROM MQMessageEntity WHERE clientHandle = ? ORDER BY timestamp ASC";
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> MqMessageDao_Impl.allArrived$lambda$4(_sql, clientHandle, this, arg_0));
    }

    @Override
    public int deleteId(@NotNull String clientHandle, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String _sql = "DELETE FROM MqMessageEntity WHERE clientHandle = ? AND messageId = ?";
        return ((Number)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> MqMessageDao_Impl.deleteId$lambda$5(_sql, clientHandle, id, arg_0))).intValue();
    }

    @Override
    public int deleteClientHandle(@NotNull String clientHandle) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        String _sql = "DELETE FROM MqMessageEntity WHERE clientHandle = ?";
        return ((Number)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> MqMessageDao_Impl.deleteClientHandle$lambda$6(_sql, clientHandle, arg_0))).intValue();
    }

    private static final long insert$lambda$0(MqMessageDao_Impl this$0, MqMessageEntity $mqMessageEntity, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        long _result = this$0.__insertAdapterOfMqMessageEntity.insertAndReturnId(_connection, (Object)$mqMessageEntity);
        return _result;
    }

    private static final Unit delete$lambda$1(MqMessageDao_Impl this$0, MqMessageEntity $mqMessageEntity, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        this$0.__deleteAdapterOfMqMessageEntity.handle(_connection, (Object)$mqMessageEntity);
        return Unit.INSTANCE;
    }

    private static final Unit updateAll$lambda$2(MqMessageDao_Impl this$0, MqMessageEntity[] $mqMessageEntity, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        this$0.__updateAdapterOfMqMessageEntity.handleMultiple(_connection, (Object[])$mqMessageEntity);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List getAll$lambda$3(String $_sql, MqMessageDao_Impl this$0, SQLiteConnection _connection) {
        List list;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _columnIndexOfMessageId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageId");
            int _columnIndexOfClientHandle = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"clientHandle");
            int _columnIndexOfTopic = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"topic");
            int _columnIndexOfMqttMessage = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mqttMessage");
            int _columnIndexOfQos = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"qos");
            int _columnIndexOfRetained = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"retained");
            int _columnIndexOfDuplicate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"duplicate");
            int _columnIndexOfTimestamp = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"timestamp");
            List _result = new ArrayList();
            while (_stmt.step()) {
                MqMessageEntity _item = null;
                String _tmpMessageId = null;
                _tmpMessageId = _stmt.getText(_columnIndexOfMessageId);
                String _tmpClientHandle = null;
                _tmpClientHandle = _stmt.getText(_columnIndexOfClientHandle);
                String _tmpTopic = null;
                _tmpTopic = _stmt.getText(_columnIndexOfTopic);
                MqttMessage _tmpMqttMessage = null;
                String _tmp = null;
                _tmp = _stmt.getText(_columnIndexOfMqttMessage);
                _tmpMqttMessage = this$0.__converters.toMqttMessage(_tmp);
                QoS _tmpQos = null;
                int _tmp_1 = 0;
                _tmp_1 = (int)_stmt.getLong(_columnIndexOfQos);
                _tmpQos = this$0.__converters.toQoS(_tmp_1);
                boolean _tmpRetained = false;
                int _tmp_2 = 0;
                _tmp_2 = (int)_stmt.getLong(_columnIndexOfRetained);
                _tmpRetained = _tmp_2 != 0;
                boolean _tmpDuplicate = false;
                int _tmp_3 = 0;
                _tmp_3 = (int)_stmt.getLong(_columnIndexOfDuplicate);
                _tmpDuplicate = _tmp_3 != 0;
                long _tmpTimestamp = 0L;
                _tmpTimestamp = _stmt.getLong(_columnIndexOfTimestamp);
                _item = new MqMessageEntity(_tmpMessageId, _tmpClientHandle, _tmpTopic, _tmpMqttMessage, _tmpQos, _tmpRetained, _tmpDuplicate, _tmpTimestamp);
                _result.add(_item);
            }
            list = _result;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List allArrived$lambda$4(String $_sql, String $clientHandle, MqMessageDao_Impl this$0, SQLiteConnection _connection) {
        List list;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindText(_argIndex, $clientHandle);
            int _columnIndexOfMessageId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageId");
            int _columnIndexOfClientHandle = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"clientHandle");
            int _columnIndexOfTopic = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"topic");
            int _columnIndexOfMqttMessage = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mqttMessage");
            int _columnIndexOfQos = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"qos");
            int _columnIndexOfRetained = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"retained");
            int _columnIndexOfDuplicate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"duplicate");
            int _columnIndexOfTimestamp = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"timestamp");
            List _result = new ArrayList();
            while (_stmt.step()) {
                MqMessageEntity _item = null;
                String _tmpMessageId = null;
                _tmpMessageId = _stmt.getText(_columnIndexOfMessageId);
                String _tmpClientHandle = null;
                _tmpClientHandle = _stmt.getText(_columnIndexOfClientHandle);
                String _tmpTopic = null;
                _tmpTopic = _stmt.getText(_columnIndexOfTopic);
                MqttMessage _tmpMqttMessage = null;
                String _tmp = null;
                _tmp = _stmt.getText(_columnIndexOfMqttMessage);
                _tmpMqttMessage = this$0.__converters.toMqttMessage(_tmp);
                QoS _tmpQos = null;
                int _tmp_1 = 0;
                _tmp_1 = (int)_stmt.getLong(_columnIndexOfQos);
                _tmpQos = this$0.__converters.toQoS(_tmp_1);
                boolean _tmpRetained = false;
                int _tmp_2 = 0;
                _tmp_2 = (int)_stmt.getLong(_columnIndexOfRetained);
                _tmpRetained = _tmp_2 != 0;
                boolean _tmpDuplicate = false;
                int _tmp_3 = 0;
                _tmp_3 = (int)_stmt.getLong(_columnIndexOfDuplicate);
                _tmpDuplicate = _tmp_3 != 0;
                long _tmpTimestamp = 0L;
                _tmpTimestamp = _stmt.getLong(_columnIndexOfTimestamp);
                _item = new MqMessageEntity(_tmpMessageId, _tmpClientHandle, _tmpTopic, _tmpMqttMessage, _tmpQos, _tmpRetained, _tmpDuplicate, _tmpTimestamp);
                _result.add(_item);
            }
            list = _result;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int deleteId$lambda$5(String $_sql, String $clientHandle, String $id, SQLiteConnection _connection) {
        int n;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindText(_argIndex, $clientHandle);
            _argIndex = 2;
            _stmt.bindText(_argIndex, $id);
            _stmt.step();
            n = SQLiteConnectionUtil.getTotalChangedRows((SQLiteConnection)_connection);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int deleteClientHandle$lambda$6(String $_sql, String $clientHandle, SQLiteConnection _connection) {
        int n;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindText(_argIndex, $clientHandle);
            _stmt.step();
            n = SQLiteConnectionUtil.getTotalChangedRows((SQLiteConnection)_connection);
        }
        return n;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a8\u0006\u0007"}, d2={"Linfo/mqtt/android/service/room/MqMessageDao_Impl$Companion;", "", "<init>", "()V", "getRequiredConverters", "", "Lkotlin/reflect/KClass;", "serviceLibrary_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<KClass<?>> getRequiredConverters() {
            return CollectionsKt.emptyList();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

