/*
 * Decompiled with CFR 0.152.
 */
package info.mqtt.android.service;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.PowerManager;
import android.util.Log;
import info.mqtt.android.service.MqttService;
import info.mqtt.android.service.ParcelableMqttMessage;
import info.mqtt.android.service.QoS;
import info.mqtt.android.service.Status;
import info.mqtt.android.service.ping.AlarmPingSender;
import info.mqtt.android.service.room.entity.MqMessageEntity;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.eclipse.paho.client.mqttv3.DisconnectedBufferOptions;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPingSender;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0003\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0000\u0018\u0000 w2\u00020\u0001:\u0002vwBA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ$\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u00010!2\b\u00103\u001a\u0004\u0018\u00010\u00052\b\u00104\u001a\u0004\u0018\u00010#J\u0010\u00105\u001a\u0002012\u0006\u00106\u001a\u000207H\u0002J\u0018\u00108\u001a\u0002012\u0006\u00109\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010:\u001a\u0002012\u0006\u00106\u001a\u000207H\u0002J\u001c\u0010;\u001a\u0002012\u0006\u00106\u001a\u0002072\n\u0010<\u001a\u00060=j\u0002`>H\u0002J\b\u0010?\u001a\u000201H\u0002J$\u0010@\u001a\u0002072\b\u0010A\u001a\u0004\u0018\u00010\u00052\b\u0010B\u001a\u0004\u0018\u00010\u00052\u0006\u0010C\u001a\u00020\u001cH\u0002J\u0006\u0010D\u001a\u000201J \u0010E\u001a\u0002012\u0006\u0010F\u001a\u00020G2\b\u00103\u001a\u0004\u0018\u00010\u00052\u0006\u00104\u001a\u00020#J\u001a\u0010E\u001a\u0002012\b\u00103\u001a\u0004\u0018\u00010\u00052\b\u00104\u001a\u0004\u0018\u00010#J<\u0010J\u001a\u0004\u0018\u00010\u001a2\u0006\u0010B\u001a\u00020\u00052\b\u0010K\u001a\u0004\u0018\u00010L2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020\u000b2\b\u00103\u001a\u0004\u0018\u00010\u00052\u0006\u00104\u001a\u00020#J*\u0010J\u001a\u0004\u0018\u00010\u001a2\u0006\u0010B\u001a\u00020\u00052\u0006\u0010C\u001a\u00020\u001c2\b\u00103\u001a\u0004\u0018\u00010\u00052\u0006\u00104\u001a\u00020#J(\u0010P\u001a\u0002012\u0006\u0010B\u001a\u00020\u00052\u0006\u0010M\u001a\u00020N2\b\u00103\u001a\u0004\u0018\u00010\u00052\u0006\u00104\u001a\u00020#J5\u0010P\u001a\u0002012\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00050Q2\b\u0010M\u001a\u0004\u0018\u00010R2\b\u00103\u001a\u0004\u0018\u00010\u00052\u0006\u00104\u001a\u00020#\u00a2\u0006\u0002\u0010SJI\u0010P\u001a\u0002012\f\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00050Q2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020N0Q2\b\u00103\u001a\u0004\u0018\u00010\u00052\u0006\u00104\u001a\u00020#2\u000e\u0010U\u001a\n\u0012\u0004\u0012\u00020V\u0018\u00010Q\u00a2\u0006\u0002\u0010WJ \u0010X\u001a\u0002012\u0006\u0010B\u001a\u00020\u00052\b\u00103\u001a\u0004\u0018\u00010\u00052\u0006\u00104\u001a\u00020#J+\u0010X\u001a\u0002012\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00050Q2\b\u00103\u001a\u0004\u0018\u00010\u00052\u0006\u00104\u001a\u00020#\u00a2\u0006\u0002\u0010YJ\u0012\u0010]\u001a\u0002012\b\u0010^\u001a\u0004\u0018\u00010_H\u0016J\u0010\u0010`\u001a\u0002012\u0006\u0010a\u001a\u00020\u001aH\u0016J\u0018\u0010b\u001a\u0002012\u0006\u0010B\u001a\u00020\u00052\u0006\u0010C\u001a\u00020\u001cH\u0016J\u0012\u0010c\u001a\u0004\u0018\u0001072\u0006\u0010a\u001a\u00020\u001aH\u0002J4\u0010d\u001a\u0002012\u0006\u0010B\u001a\u00020\u00052\u0006\u0010e\u001a\u00020\u001c2\b\u0010a\u001a\u0004\u0018\u00010\u001a2\b\u00103\u001a\u0004\u0018\u00010\u00052\u0006\u00104\u001a\u00020#H\u0002J\b\u0010f\u001a\u000201H\u0002J\b\u0010g\u001a\u000201H\u0002J\u0006\u0010h\u001a\u000201J\u000e\u00109\u001a\u0002012\u0006\u0010i\u001a\u00020jJ\u0010\u0010k\u001a\u0002012\u0006\u0010*\u001a\u00020\u000bH\u0002J\u0010\u0010l\u001a\u0002012\b\u0010m\u001a\u0004\u0018\u00010/J\u000e\u0010q\u001a\u00020\u001c2\u0006\u0010r\u001a\u00020\rJ\u000e\u0010s\u001a\u0002012\u0006\u0010r\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0011\"\u0004\b\u0017\u0010\u0013R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00050\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u001c0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00050\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00050\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\b\u0018\u00010,R\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010H\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\bH\u0010IR\u0017\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u001a0Q8F\u00a2\u0006\u0006\u001a\u0004\b[\u0010\\R\u0011\u0010n\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\bo\u0010pR\u0011\u0010t\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\bu\u0010p\u00a8\u0006x"}, d2={"Linfo/mqtt/android/service/MqttConnection;", "Lorg/eclipse/paho/client/mqttv3/MqttCallbackExtended;", "service", "Linfo/mqtt/android/service/MqttService;", "serverURI", "", "clientId", "persistence", "Lorg/eclipse/paho/client/mqttv3/MqttClientPersistence;", "clientHandle", "pingLogging", "", "keepPingRecords", "", "<init>", "(Linfo/mqtt/android/service/MqttService;Ljava/lang/String;Ljava/lang/String;Lorg/eclipse/paho/client/mqttv3/MqttClientPersistence;Ljava/lang/String;ZI)V", "getServerURI", "()Ljava/lang/String;", "setServerURI", "(Ljava/lang/String;)V", "getClientId", "setClientId", "getClientHandle", "setClientHandle", "mapTopics", "", "Lorg/eclipse/paho/client/mqttv3/IMqttDeliveryToken;", "mapSentMessages", "Lorg/eclipse/paho/client/mqttv3/MqttMessage;", "mapActivityTokens", "mapInvocationContexts", "wakeLockTag", "connectOptions", "Lorg/eclipse/paho/client/mqttv3/MqttConnectOptions;", "reconnectActivityToken", "Lorg/eclipse/paho/client/mqttv3/IMqttToken;", "myClient", "Lorg/eclipse/paho/client/mqttv3/MqttAsyncClient;", "alarmPingSender", "Linfo/mqtt/android/service/ping/AlarmPingSender;", "disconnected", "cleanSession", "isConnecting", "wakelock", "Landroid/os/PowerManager$WakeLock;", "Landroid/os/PowerManager;", "disconnectedBufferOptions", "Lorg/eclipse/paho/client/mqttv3/DisconnectedBufferOptions;", "connect", "", "options", "invocationContext", "activityToken", "doAfterConnectSuccess", "resultBundle", "Landroid/os/Bundle;", "connectComplete", "reconnect", "doAfterConnectFail", "handleException", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "deliverBacklog", "messageToBundle", "messageId", "topic", "message", "close", "disconnect", "quiesceTimeout", "", "isConnected", "()Z", "publish", "payload", "", "qos", "Linfo/mqtt/android/service/QoS;", "retained", "subscribe", "", "", "([Ljava/lang/String;[ILjava/lang/String;Lorg/eclipse/paho/client/mqttv3/IMqttToken;)V", "topicFilters", "messageListeners", "Lorg/eclipse/paho/client/mqttv3/IMqttMessageListener;", "([Ljava/lang/String;[Linfo/mqtt/android/service/QoS;Ljava/lang/String;Lorg/eclipse/paho/client/mqttv3/IMqttToken;[Lorg/eclipse/paho/client/mqttv3/IMqttMessageListener;)V", "unsubscribe", "([Ljava/lang/String;Ljava/lang/String;Lorg/eclipse/paho/client/mqttv3/IMqttToken;)V", "pendingDeliveryTokens", "getPendingDeliveryTokens", "()[Lorg/eclipse/paho/client/mqttv3/IMqttDeliveryToken;", "connectionLost", "why", "", "deliveryComplete", "messageToken", "messageArrived", "popSendDetails", "storeSendDetailsInMemory", "msg", "acquireWakeLock", "releaseWakeLock", "offline", "context", "Landroid/content/Context;", "setConnectingState", "setBufferOpts", "bufferOpts", "bufferedMessageCount", "getBufferedMessageCount", "()I", "getBufferedMessage", "bufferIndex", "deleteBufferedMessage", "inFlightMessageCount", "getInFlightMessageCount", "MqttConnectionListener", "Companion", "serviceLibrary_release"})
@SourceDebugExtension(value={"SMAP\nMqttConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MqttConnection.kt\ninfo/mqtt/android/service/MqttConnection\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,855:1\n11228#2:856\n11563#2,3:857\n*S KotlinDebug\n*F\n+ 1 MqttConnection.kt\ninfo/mqtt/android/service/MqttConnection\n*L\n500#1:856\n500#1:857,3\n*E\n"})
public final class MqttConnection
implements MqttCallbackExtended {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MqttService service;
    @NotNull
    private String serverURI;
    @NotNull
    private String clientId;
    @Nullable
    private MqttClientPersistence persistence;
    @NotNull
    private String clientHandle;
    private final boolean pingLogging;
    private final int keepPingRecords;
    @NotNull
    private final Map<IMqttDeliveryToken, String> mapTopics;
    @NotNull
    private final Map<IMqttDeliveryToken, MqttMessage> mapSentMessages;
    @NotNull
    private final Map<IMqttDeliveryToken, String> mapActivityTokens;
    @NotNull
    private final Map<IMqttDeliveryToken, String> mapInvocationContexts;
    @NotNull
    private final String wakeLockTag;
    @Nullable
    private MqttConnectOptions connectOptions;
    @Nullable
    private IMqttToken reconnectActivityToken;
    @Nullable
    private MqttAsyncClient myClient;
    @Nullable
    private AlarmPingSender alarmPingSender;
    private volatile boolean disconnected;
    private boolean cleanSession;
    private volatile boolean isConnecting;
    @Nullable
    private PowerManager.WakeLock wakelock;
    @Nullable
    private DisconnectedBufferOptions disconnectedBufferOptions;
    @NotNull
    private static final String TEMP = "MqttConnection";
    @NotNull
    private static final String NOT_CONNECTED = "not connected";

    public MqttConnection(@NotNull MqttService service, @NotNull String serverURI, @NotNull String clientId, @Nullable MqttClientPersistence persistence, @NotNull String clientHandle, boolean pingLogging, int keepPingRecords) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)serverURI, (String)"serverURI");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        this.service = service;
        this.serverURI = serverURI;
        this.clientId = clientId;
        this.persistence = persistence;
        this.clientHandle = clientHandle;
        this.pingLogging = pingLogging;
        this.keepPingRecords = keepPingRecords;
        this.mapTopics = new HashMap();
        this.mapSentMessages = new HashMap();
        this.mapActivityTokens = new HashMap();
        this.mapInvocationContexts = new HashMap();
        this.wakeLockTag = this.getClass().getSimpleName() + " " + this.clientId + " on host " + this.serverURI;
        this.disconnected = true;
        this.cleanSession = true;
    }

    @NotNull
    public final String getServerURI() {
        return this.serverURI;
    }

    public final void setServerURI(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.serverURI = string;
    }

    @NotNull
    public final String getClientId() {
        return this.clientId;
    }

    public final void setClientId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.clientId = string;
    }

    @NotNull
    public final String getClientHandle() {
        return this.clientHandle;
    }

    public final void setClientHandle(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.clientHandle = string;
    }

    public final void connect(@Nullable MqttConnectOptions options, @Nullable String invocationContext, @Nullable IMqttToken activityToken) {
        this.connectOptions = options;
        this.reconnectActivityToken = activityToken;
        MqttConnectOptions mqttConnectOptions = options;
        if (mqttConnectOptions != null) {
            MqttConnectOptions it = mqttConnectOptions;
            boolean bl = false;
            this.cleanSession = it.isCleanSession();
            if (it.isCleanSession()) {
                if (this.service.getMessageDatabase().isOpen()) {
                    BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                        int label;
                        final /* synthetic */ MqttConnection this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    MqttConnection.access$getService$p(this.this$0).getMessageDatabase().persistenceDao().deleteClientHandle(this.this$0.getClientHandle());
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                } else {
                    Timber.Forest.w("Database is closed", new Object[0]);
                }
            }
        }
        this.service.traceDebug("Connecting {" + this.serverURI + "} as {" + this.clientId + "}");
        Bundle resultBundle = new Bundle();
        resultBundle.putString(".activityToken", String.valueOf(activityToken));
        resultBundle.putString(".invocationContext", invocationContext);
        resultBundle.putString(".callbackAction", "connect");
        try {
            if (this.persistence == null) {
                File myDir = null;
                try {
                    myDir = this.service.getDir(TEMP, 0);
                }
                catch (Exception bl) {
                    // empty catch block
                }
                if (myDir == null) {
                    try {
                        myDir = this.service.getFilesDir();
                        if (myDir != null) {
                            String stringBuilder = myDir.getAbsolutePath() + File.separator;
                            myDir = new File(stringBuilder);
                            myDir.mkdirs();
                        }
                    }
                    catch (Exception e) {
                        myDir = null;
                    }
                }
                this.persistence = myDir == null ? (MqttClientPersistence)new MemoryPersistence() : (MqttClientPersistence)new MqttDefaultFilePersistence(myDir.getAbsolutePath());
            }
            IMqttActionListener listener2 = new MqttConnectionListener(this, resultBundle){
                final /* synthetic */ MqttConnection this$0;
                final /* synthetic */ Bundle $resultBundle;
                {
                    this.this$0 = $receiver;
                    this.$resultBundle = $resultBundle;
                    super($resultBundle);
                }

                public void onSuccess(IMqttToken asyncActionToken) {
                    Intrinsics.checkNotNullParameter((Object)asyncActionToken, (String)"asyncActionToken");
                    this.$resultBundle.putBoolean("sessionPresent", asyncActionToken.getSessionPresent());
                    MqttConnection.access$doAfterConnectSuccess(this.this$0, this.$resultBundle);
                    MqttConnection.access$getService$p(this.this$0).traceDebug("connect success!");
                }

                public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                    Throwable throwable = exception;
                    this.$resultBundle.putString(".errorMessage", throwable != null ? throwable.getLocalizedMessage() : null);
                    this.$resultBundle.putSerializable(".exception", (Serializable)exception);
                    Throwable throwable2 = exception;
                    MqttConnection.access$getService$p(this.this$0).traceError("connect fail, call connect to reconnect.reason: " + (throwable2 != null ? throwable2.getMessage() : null));
                    MqttConnection.access$doAfterConnectFail(this.this$0, this.$resultBundle);
                }
            };
            if (this.myClient != null) {
                if (this.isConnecting) {
                    this.service.traceDebug("myClient != null and the client is connecting. Connect return directly.");
                    this.service.traceDebug("Connect return:isConnecting:" + this.isConnecting + ".disconnected:" + this.disconnected);
                } else if (!this.disconnected) {
                    this.service.traceDebug("myClient != null and the client is connected and notify!");
                    this.doAfterConnectSuccess(resultBundle);
                } else {
                    this.service.traceDebug("myClient != null and the client is not connected");
                    this.service.traceDebug("Do Real connect!");
                    this.setConnectingState(true);
                    MqttAsyncClient mqttAsyncClient = this.myClient;
                    Intrinsics.checkNotNull((Object)mqttAsyncClient);
                    mqttAsyncClient.connect(this.connectOptions, (Object)invocationContext, listener2);
                }
            } else {
                this.alarmPingSender = new AlarmPingSender(this.service, this.clientId, this.pingLogging, this.keepPingRecords);
                this.setConnectingState(true);
                MqttAsyncClient mqttAsyncClient = this.myClient = new MqttAsyncClient(this.serverURI, this.clientId, this.persistence, (MqttPingSender)this.alarmPingSender);
                Intrinsics.checkNotNull((Object)mqttAsyncClient);
                mqttAsyncClient.setCallback((MqttCallback)this);
                this.service.traceDebug("Do Real connect!");
                MqttAsyncClient mqttAsyncClient2 = this.myClient;
                Intrinsics.checkNotNull((Object)mqttAsyncClient2);
                mqttAsyncClient2.connect(this.connectOptions, (Object)invocationContext, listener2);
            }
        }
        catch (Exception e) {
            this.service.traceError("Exception occurred attempting to connect: " + e.getMessage());
            this.setConnectingState(false);
            this.handleException(resultBundle, e);
        }
    }

    private final void doAfterConnectSuccess(Bundle resultBundle) {
        this.acquireWakeLock();
        this.service.callbackToActivity(this.clientHandle, Status.OK, resultBundle);
        this.deliverBacklog();
        this.setConnectingState(false);
        this.disconnected = false;
        this.releaseWakeLock();
    }

    public void connectComplete(boolean reconnect2, @NotNull String serverURI) {
        Intrinsics.checkNotNullParameter((Object)serverURI, (String)"serverURI");
        Bundle resultBundle = new Bundle();
        resultBundle.putString(".callbackAction", "connectExtended");
        resultBundle.putBoolean(".reconnect", reconnect2);
        resultBundle.putString(".serverURI", serverURI);
        this.service.callbackToActivity(this.clientHandle, Status.OK, resultBundle);
    }

    private final void doAfterConnectFail(Bundle resultBundle) {
        this.acquireWakeLock();
        this.disconnected = true;
        this.setConnectingState(false);
        this.service.callbackToActivity(this.clientHandle, Status.ERROR, resultBundle);
        this.releaseWakeLock();
    }

    private final void handleException(Bundle resultBundle, Exception e) {
        resultBundle.putString(".errorMessage", e.getLocalizedMessage());
        resultBundle.putSerializable(".exception", (Serializable)e);
        this.service.callbackToActivity(this.clientHandle, Status.ERROR, resultBundle);
    }

    private final void deliverBacklog() {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ MqttConnection this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$forEach$iv;
                        ResultKt.throwOnFailure((Object)object);
                        Iterable iterable = MqttConnection.access$getService$p(this.this$0).getMessageDatabase().persistenceDao().allArrived(this.this$0.getClientHandle());
                        MqttConnection mqttConnection = this.this$0;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            MqMessageEntity it = (MqMessageEntity)element$iv;
                            boolean bl = false;
                            Bundle resultBundle = MqttConnection.access$messageToBundle(mqttConnection, it.getMessageId(), it.getTopic(), it.getMqttMessage());
                            resultBundle.putString(".callbackAction", "messageArrived");
                            MqttConnection.access$getService$p(mqttConnection).callbackToActivity(mqttConnection.getClientHandle(), Status.OK, resultBundle);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Bundle messageToBundle(String messageId, String topic, MqttMessage message) {
        Bundle result = new Bundle();
        result.putString("messageId", messageId);
        result.putString("destinationName", topic);
        result.putParcelable(".PARCEL", (Parcelable)new ParcelableMqttMessage(message));
        return result;
    }

    public final void close() {
        this.service.traceDebug("close()");
        try {
            MqttAsyncClient mqttAsyncClient = this.myClient;
            if (mqttAsyncClient != null) {
                mqttAsyncClient.close();
            }
        }
        catch (MqttException e) {
            this.handleException(new Bundle(), (Exception)((Object)e));
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void disconnect(long quiesceTimeout, @Nullable String invocationContext, @NotNull IMqttToken activityToken) {
        Intrinsics.checkNotNullParameter((Object)activityToken, (String)"activityToken");
        this.service.traceDebug("disconnect()");
        this.disconnected = true;
        resultBundle = new Bundle();
        resultBundle.putString(".activityToken", activityToken.toString());
        resultBundle.putString(".invocationContext", invocationContext);
        resultBundle.putString(".callbackAction", "disconnect");
        if (this.myClient == null) ** GOTO lbl-1000
        v0 = this.myClient;
        Intrinsics.checkNotNull((Object)v0);
        if (v0.isConnected()) {
            listener = new MqttConnectionListener(resultBundle);
            try {
                v1 = this.myClient;
                Intrinsics.checkNotNull((Object)v1);
                var7_6 = v1.disconnect(quiesceTimeout, (Object)invocationContext, listener);
            }
            catch (Exception e) {
                this.handleException(resultBundle, e);
                var7_7 = Unit.INSTANCE;
            }
        } else lbl-1000:
        // 2 sources

        {
            resultBundle.putString(".errorMessage", "not connected");
            this.service.traceError("disconnect not connected");
            this.service.callbackToActivity(this.clientHandle, Status.ERROR, resultBundle);
        }
        if (this.connectOptions != null) {
            v2 = this.connectOptions;
            Intrinsics.checkNotNull((Object)v2);
            if (v2.isCleanSession()) {
                BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ MqttConnection this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                MqttConnection.access$getService$p(this.this$0).getMessageDatabase().persistenceDao().deleteClientHandle(this.this$0.getClientHandle());
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }
        this.releaseWakeLock();
    }

    /*
     * Unable to fully structure code
     */
    public final void disconnect(@Nullable String invocationContext, @Nullable IMqttToken activityToken) {
        this.service.traceDebug("disconnect()");
        this.disconnected = true;
        resultBundle = new Bundle();
        resultBundle.putString(".activityToken", String.valueOf(activityToken));
        resultBundle.putString(".invocationContext", invocationContext);
        resultBundle.putString(".callbackAction", "disconnect");
        if (this.myClient == null) ** GOTO lbl-1000
        v0 = this.myClient;
        Intrinsics.checkNotNull((Object)v0);
        if (v0.isConnected()) {
            listener = new MqttConnectionListener(resultBundle);
            try {
                v1 = this.myClient;
                Intrinsics.checkNotNull((Object)v1);
                var5_5 = v1.disconnect((Object)invocationContext, listener);
            }
            catch (Exception e) {
                this.handleException(resultBundle, e);
                var5_6 = Unit.INSTANCE;
            }
        } else lbl-1000:
        // 2 sources

        {
            resultBundle.putString(".errorMessage", "not connected");
            this.service.traceError("disconnect not connected");
            this.service.callbackToActivity(this.clientHandle, Status.ERROR, resultBundle);
        }
        if (this.connectOptions != null) {
            v2 = this.connectOptions;
            Intrinsics.checkNotNull((Object)v2);
            if (v2.isCleanSession()) {
                BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ MqttConnection this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                MqttConnection.access$getService$p(this.this$0).getMessageDatabase().persistenceDao().deleteClientHandle(this.this$0.getClientHandle());
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }
        this.releaseWakeLock();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isConnected() {
        if (this.myClient == null) return false;
        MqttAsyncClient mqttAsyncClient = this.myClient;
        Intrinsics.checkNotNull((Object)mqttAsyncClient);
        if (!mqttAsyncClient.isConnected()) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final IMqttDeliveryToken publish(@NotNull String topic, @Nullable byte[] payload, @NotNull QoS qos, boolean retained, @Nullable String invocationContext, @NotNull IMqttToken activityToken) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)((Object)qos), (String)"qos");
        Intrinsics.checkNotNullParameter((Object)activityToken, (String)"activityToken");
        Bundle resultBundle = new Bundle();
        resultBundle.putString(".callbackAction", "send");
        resultBundle.putString(".activityToken", activityToken.toString());
        resultBundle.putString(".invocationContext", invocationContext);
        IMqttDeliveryToken sendToken = null;
        if (this.myClient != null) {
            MqttAsyncClient mqttAsyncClient = this.myClient;
            Intrinsics.checkNotNull((Object)mqttAsyncClient);
            if (mqttAsyncClient.isConnected()) {
                IMqttActionListener listener2 = new MqttConnectionListener(resultBundle);
                try {
                    MqttMessage message = new MqttMessage(payload);
                    message.setQos(qos.getValue());
                    message.setRetained(retained);
                    MqttAsyncClient mqttAsyncClient2 = this.myClient;
                    Intrinsics.checkNotNull((Object)mqttAsyncClient2);
                    sendToken = mqttAsyncClient2.publish(topic, payload, qos.getValue(), retained, (Object)invocationContext, listener2);
                    this.storeSendDetailsInMemory(topic, message, sendToken, invocationContext, activityToken);
                    return sendToken;
                }
                catch (Exception e) {
                    this.handleException(resultBundle, e);
                    return sendToken;
                }
            }
        }
        resultBundle.putString(".errorMessage", NOT_CONNECTED);
        this.service.traceError("send not connected");
        this.service.callbackToActivity(this.clientHandle, Status.ERROR, resultBundle);
        return sendToken;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final IMqttDeliveryToken publish(@NotNull String topic, @NotNull MqttMessage message, @Nullable String invocationContext, @NotNull IMqttToken activityToken) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)activityToken, (String)"activityToken");
        Bundle resultBundle = new Bundle();
        resultBundle.putString(".callbackAction", "send");
        resultBundle.putString(".activityToken", activityToken.toString());
        resultBundle.putString(".invocationContext", invocationContext);
        IMqttDeliveryToken sendToken = null;
        if (this.myClient != null) {
            MqttAsyncClient mqttAsyncClient = this.myClient;
            Intrinsics.checkNotNull((Object)mqttAsyncClient);
            if (mqttAsyncClient.isConnected()) {
                IMqttActionListener listener2 = new MqttConnectionListener(resultBundle);
                try {
                    MqttAsyncClient mqttAsyncClient2 = this.myClient;
                    Intrinsics.checkNotNull((Object)mqttAsyncClient2);
                    sendToken = mqttAsyncClient2.publish(topic, message, (Object)invocationContext, listener2);
                    this.storeSendDetailsInMemory(topic, message, sendToken, invocationContext, activityToken);
                    return sendToken;
                }
                catch (Exception e) {
                    this.handleException(resultBundle, e);
                    return sendToken;
                }
            }
        }
        if (this.myClient != null && this.disconnectedBufferOptions != null) {
            DisconnectedBufferOptions disconnectedBufferOptions = this.disconnectedBufferOptions;
            Intrinsics.checkNotNull((Object)disconnectedBufferOptions);
            if (disconnectedBufferOptions.isBufferEnabled()) {
                IMqttActionListener listener3 = new MqttConnectionListener(resultBundle);
                try {
                    MqttAsyncClient mqttAsyncClient = this.myClient;
                    Intrinsics.checkNotNull((Object)mqttAsyncClient);
                    sendToken = mqttAsyncClient.publish(topic, message, (Object)invocationContext, listener3);
                    this.storeSendDetailsInMemory(topic, message, sendToken, invocationContext, activityToken);
                    return sendToken;
                }
                catch (Exception e) {
                    this.handleException(resultBundle, e);
                    return sendToken;
                }
            }
        }
        Timber.Forest.i("Client is not connected, so not sending message", new Object[0]);
        resultBundle.putString(".errorMessage", NOT_CONNECTED);
        this.service.traceError("send not connected");
        this.service.callbackToActivity(this.clientHandle, Status.ERROR, resultBundle);
        return sendToken;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void subscribe(@NotNull String topic, @NotNull QoS qos, @Nullable String invocationContext, @NotNull IMqttToken activityToken) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)((Object)qos), (String)"qos");
        Intrinsics.checkNotNullParameter((Object)activityToken, (String)"activityToken");
        this.service.traceDebug("subscribe({" + topic + "}," + qos + ",{" + invocationContext + "}, {" + activityToken + "}");
        Bundle resultBundle = new Bundle();
        resultBundle.putString(".callbackAction", "subscribe");
        resultBundle.putString(".activityToken", activityToken.toString());
        resultBundle.putString(".invocationContext", invocationContext);
        if (this.myClient != null) {
            MqttAsyncClient mqttAsyncClient = this.myClient;
            Intrinsics.checkNotNull((Object)mqttAsyncClient);
            if (mqttAsyncClient.isConnected()) {
                IMqttActionListener listener2 = new MqttConnectionListener(resultBundle);
                try {
                    MqttAsyncClient mqttAsyncClient2 = this.myClient;
                    Intrinsics.checkNotNull((Object)mqttAsyncClient2);
                    IMqttToken iMqttToken = mqttAsyncClient2.subscribe(topic, qos.getValue(), (Object)invocationContext, listener2);
                    return;
                }
                catch (Exception e) {
                    this.handleException(resultBundle, e);
                    Unit unit = Unit.INSTANCE;
                    return;
                }
            }
        }
        resultBundle.putString(".errorMessage", NOT_CONNECTED);
        this.service.traceError("subscribe not connected");
        this.service.callbackToActivity(this.clientHandle, Status.ERROR, resultBundle);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void subscribe(@NotNull String[] topic, @Nullable int[] qos, @Nullable String invocationContext, @NotNull IMqttToken activityToken) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)activityToken, (String)"activityToken");
        String string = Arrays.toString(topic);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = Arrays.toString(qos);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        this.service.traceDebug("subscribe({" + string + "}," + string2 + ",{" + invocationContext + "}, {" + activityToken + "}");
        Bundle resultBundle = new Bundle();
        resultBundle.putString(".callbackAction", "subscribe");
        resultBundle.putString(".activityToken", activityToken.toString());
        resultBundle.putString(".invocationContext", invocationContext);
        if (this.myClient != null) {
            MqttAsyncClient mqttAsyncClient = this.myClient;
            Intrinsics.checkNotNull((Object)mqttAsyncClient);
            if (mqttAsyncClient.isConnected()) {
                IMqttActionListener listener2 = new MqttConnectionListener(resultBundle);
                try {
                    MqttAsyncClient mqttAsyncClient2 = this.myClient;
                    Intrinsics.checkNotNull((Object)mqttAsyncClient2);
                    IMqttToken iMqttToken = mqttAsyncClient2.subscribe(topic, qos, (Object)invocationContext, listener2);
                    return;
                }
                catch (Exception e) {
                    this.handleException(resultBundle, e);
                    Unit unit = Unit.INSTANCE;
                    return;
                }
            }
        }
        resultBundle.putString(".errorMessage", NOT_CONNECTED);
        this.service.traceError("subscribe not connected");
        this.service.callbackToActivity(this.clientHandle, Status.ERROR, resultBundle);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void subscribe(@NotNull String[] topicFilters, @NotNull QoS[] qos, @Nullable String invocationContext, @NotNull IMqttToken activityToken, @Nullable IMqttMessageListener[] messageListeners) {
        Intrinsics.checkNotNullParameter((Object)topicFilters, (String)"topicFilters");
        Intrinsics.checkNotNullParameter((Object)qos, (String)"qos");
        Intrinsics.checkNotNullParameter((Object)activityToken, (String)"activityToken");
        String string = Arrays.toString(topicFilters);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = Arrays.toString((Object[])qos);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        this.service.traceDebug("subscribe({" + string + "}," + string2 + ",{" + invocationContext + "}, {" + activityToken + "}");
        Bundle resultBundle = new Bundle();
        resultBundle.putString(".callbackAction", "subscribe");
        resultBundle.putString(".activityToken", activityToken.toString());
        resultBundle.putString(".invocationContext", invocationContext);
        if (this.myClient != null) {
            MqttAsyncClient mqttAsyncClient = this.myClient;
            Intrinsics.checkNotNull((Object)mqttAsyncClient);
            if (mqttAsyncClient.isConnected()) {
                IMqttActionListener listener2 = new MqttConnectionListener(resultBundle);
                try {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    MqttAsyncClient mqttAsyncClient2 = this.myClient;
                    Intrinsics.checkNotNull((Object)mqttAsyncClient2);
                    IMqttToken iMqttToken = qos;
                    String[] stringArray = topicFilters;
                    MqttAsyncClient mqttAsyncClient3 = mqttAsyncClient2;
                    boolean $i$f$map = false;
                    void var10_14 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                    boolean $i$f$mapTo = false;
                    int n = 0;
                    int n2 = ((void)$this$mapTo$iv$iv).length;
                    while (true) {
                        void it;
                        void item$iv$iv;
                        Collection<Integer> collection;
                        if (n >= n2) {
                            collection = (List)destination$iv$iv;
                            iMqttToken = mqttAsyncClient3.subscribe(stringArray, CollectionsKt.toIntArray((Collection)collection), null, listener2, messageListeners);
                            return;
                        }
                        void var16_20 = item$iv$iv = $this$mapTo$iv$iv[n];
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getValue());
                        ++n;
                    }
                }
                catch (Exception e) {
                    this.handleException(resultBundle, e);
                    Unit unit = Unit.INSTANCE;
                    return;
                }
            }
        }
        resultBundle.putString(".errorMessage", NOT_CONNECTED);
        this.service.traceError("subscribe not connected");
        this.service.callbackToActivity(this.clientHandle, Status.ERROR, resultBundle);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void unsubscribe(@NotNull String topic, @Nullable String invocationContext, @NotNull IMqttToken activityToken) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)activityToken, (String)"activityToken");
        this.service.traceDebug("unsubscribe({" + topic + "},{" + invocationContext + "}, {" + activityToken + "})");
        Bundle resultBundle = new Bundle();
        resultBundle.putString(".callbackAction", "unsubscribe");
        resultBundle.putString(".activityToken", activityToken.toString());
        resultBundle.putString(".invocationContext", invocationContext);
        if (this.myClient != null) {
            MqttAsyncClient mqttAsyncClient = this.myClient;
            Intrinsics.checkNotNull((Object)mqttAsyncClient);
            if (mqttAsyncClient.isConnected()) {
                IMqttActionListener listener2 = new MqttConnectionListener(resultBundle);
                try {
                    MqttAsyncClient mqttAsyncClient2 = this.myClient;
                    Intrinsics.checkNotNull((Object)mqttAsyncClient2);
                    IMqttToken iMqttToken = mqttAsyncClient2.unsubscribe(topic, (Object)invocationContext, listener2);
                    return;
                }
                catch (Exception e) {
                    this.handleException(resultBundle, e);
                    Unit unit = Unit.INSTANCE;
                    return;
                }
            }
        }
        resultBundle.putString(".errorMessage", NOT_CONNECTED);
        this.service.traceError("subscribe not connected");
        this.service.callbackToActivity(this.clientHandle, Status.ERROR, resultBundle);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void unsubscribe(@NotNull String[] topic, @Nullable String invocationContext, @NotNull IMqttToken activityToken) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)activityToken, (String)"activityToken");
        String string = Arrays.toString(topic);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.service.traceDebug("unsubscribe({" + string + "},{" + invocationContext + "}, {" + activityToken + "})");
        Bundle resultBundle = new Bundle();
        resultBundle.putString(".callbackAction", "unsubscribe");
        resultBundle.putString(".activityToken", activityToken.toString());
        resultBundle.putString(".invocationContext", invocationContext);
        if (this.myClient != null) {
            MqttAsyncClient mqttAsyncClient = this.myClient;
            Intrinsics.checkNotNull((Object)mqttAsyncClient);
            if (mqttAsyncClient.isConnected()) {
                IMqttActionListener listener2 = new MqttConnectionListener(resultBundle);
                try {
                    MqttAsyncClient mqttAsyncClient2 = this.myClient;
                    Intrinsics.checkNotNull((Object)mqttAsyncClient2);
                    IMqttToken iMqttToken = mqttAsyncClient2.unsubscribe(topic, (Object)invocationContext, listener2);
                    return;
                }
                catch (Exception e) {
                    this.handleException(resultBundle, e);
                    Unit unit = Unit.INSTANCE;
                    return;
                }
            }
        }
        resultBundle.putString(".errorMessage", NOT_CONNECTED);
        this.service.traceError("subscribe not connected");
        this.service.callbackToActivity(this.clientHandle, Status.ERROR, resultBundle);
    }

    @NotNull
    public final IMqttDeliveryToken[] getPendingDeliveryTokens() {
        MqttAsyncClient mqttAsyncClient = this.myClient;
        Intrinsics.checkNotNull((Object)mqttAsyncClient);
        IMqttDeliveryToken[] iMqttDeliveryTokenArray = mqttAsyncClient.getPendingDeliveryTokens();
        Intrinsics.checkNotNullExpressionValue((Object)iMqttDeliveryTokenArray, (String)"getPendingDeliveryTokens(...)");
        return iMqttDeliveryTokenArray;
    }

    public void connectionLost(@Nullable Throwable why) {
        if (why != null) {
            this.service.traceDebug("connectionLost(" + why.getMessage() + ")");
        } else {
            this.service.traceDebug("connectionLost(NO_REASON)");
        }
        this.disconnected = true;
        try {
            MqttConnectOptions mqttConnectOptions = this.connectOptions;
            Intrinsics.checkNotNull((Object)mqttConnectOptions);
            if (!mqttConnectOptions.isAutomaticReconnect()) {
                MqttAsyncClient mqttAsyncClient = this.myClient;
                Intrinsics.checkNotNull((Object)mqttAsyncClient);
                mqttAsyncClient.disconnect(null, new IMqttActionListener(){

                    public void onSuccess(IMqttToken asyncActionToken) {
                        Intrinsics.checkNotNullParameter((Object)asyncActionToken, (String)"asyncActionToken");
                    }

                    public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                    }
                });
            } else {
                AlarmPingSender alarmPingSender = this.alarmPingSender;
                Intrinsics.checkNotNull((Object)alarmPingSender);
                alarmPingSender.schedule(100L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Bundle resultBundle = new Bundle();
        resultBundle.putString(".callbackAction", "onConnectionLost");
        if (why != null) {
            resultBundle.putString(".errorMessage", why.getMessage());
            if (why instanceof MqttException) {
                resultBundle.putSerializable(".exception", (Serializable)why);
            }
            resultBundle.putString(".exceptionStack", Log.getStackTraceString((Throwable)why));
        }
        this.service.callbackToActivity(this.clientHandle, Status.OK, resultBundle);
        this.releaseWakeLock();
    }

    public void deliveryComplete(@NotNull IMqttDeliveryToken messageToken) {
        Intrinsics.checkNotNullParameter((Object)messageToken, (String)"messageToken");
        this.service.traceDebug("deliveryComplete(" + messageToken + ")");
        Bundle resultBundle = this.popSendDetails(messageToken);
        if (resultBundle != null) {
            if (Intrinsics.areEqual((Object)"send", (Object)resultBundle.getString(".callbackAction"))) {
                this.service.callbackToActivity(this.clientHandle, Status.OK, resultBundle);
            }
            resultBundle.putString(".callbackAction", "messageDelivered");
            this.service.callbackToActivity(this.clientHandle, Status.OK, resultBundle);
        }
    }

    public void messageArrived(@NotNull String topic, @NotNull MqttMessage message) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.service.traceDebug("messageArrived(" + topic + ",{" + message + "})");
        String messageId = this.service.getMessageDatabase().storeArrived(this.clientHandle, topic, message);
        Bundle resultBundle = this.messageToBundle(messageId, topic, message);
        resultBundle.putString(".callbackAction", "messageArrived");
        resultBundle.putString("messageId", messageId);
        this.service.callbackToActivity(this.clientHandle, Status.OK, resultBundle);
    }

    private final synchronized Bundle popSendDetails(IMqttDeliveryToken messageToken) {
        MqttMessage message = this.mapSentMessages.remove(messageToken);
        if (message != null) {
            String topic = this.mapTopics.remove(messageToken);
            String activityToken = this.mapActivityTokens.remove(messageToken);
            String invocationContext = this.mapInvocationContexts.remove(messageToken);
            Bundle resultBundle = this.messageToBundle(null, topic, message);
            if (activityToken != null) {
                resultBundle.putString(".callbackAction", "send");
                resultBundle.putString(".activityToken", activityToken);
                resultBundle.putString(".invocationContext", invocationContext);
            }
            return resultBundle;
        }
        return null;
    }

    private final synchronized void storeSendDetailsInMemory(String topic, MqttMessage msg, IMqttDeliveryToken messageToken, String invocationContext, IMqttToken activityToken) {
        block0: {
            this.mapTopics.put(messageToken, topic);
            this.mapSentMessages.put(messageToken, msg);
            this.mapActivityTokens.put(messageToken, activityToken.toString());
            String string = invocationContext;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            this.mapInvocationContexts.put(messageToken, it);
        }
    }

    private final void acquireWakeLock() {
        if (this.wakelock == null) {
            Object object = this.service.getSystemService("power");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.os.PowerManager");
            PowerManager pm = (PowerManager)object;
            this.wakelock = pm.newWakeLock(1, this.wakeLockTag);
        }
        PowerManager.WakeLock wakeLock = this.wakelock;
        Intrinsics.checkNotNull((Object)wakeLock);
        wakeLock.acquire(600000L);
    }

    private final void releaseWakeLock() {
        if (this.wakelock != null) {
            PowerManager.WakeLock wakeLock = this.wakelock;
            Intrinsics.checkNotNull((Object)wakeLock);
            if (wakeLock.isHeld()) {
                PowerManager.WakeLock wakeLock2 = this.wakelock;
                Intrinsics.checkNotNull((Object)wakeLock2);
                wakeLock2.release();
            }
        }
    }

    public final void offline() {
        if (!this.disconnected && !this.cleanSession) {
            Exception e = new Exception("Android offline");
            this.connectionLost(e);
        }
    }

    public final synchronized void reconnect(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.myClient == null) {
            this.service.traceError("Reconnect myClient = null. Will not do reconnect");
            return;
        }
        if (this.isConnecting) {
            this.service.traceDebug("The client is connecting. Reconnect return directly.");
            return;
        }
        if (!this.service.isOnline(context)) {
            this.service.traceDebug("The network is not reachable. Will not do reconnect");
            return;
        }
        MqttConnectOptions mqttConnectOptions = this.connectOptions;
        Intrinsics.checkNotNull((Object)mqttConnectOptions);
        if (mqttConnectOptions.isAutomaticReconnect()) {
            Timber.Forest.i("Requesting Automatic reconnect using New Java AC", new Object[0]);
            Bundle resultBundle = new Bundle();
            resultBundle.putString(".activityToken", String.valueOf(this.reconnectActivityToken));
            resultBundle.putString(".invocationContext", null);
            resultBundle.putString(".callbackAction", "connect");
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, resultBundle, null){
                int label;
                final /* synthetic */ MqttConnection this$0;
                final /* synthetic */ Bundle $resultBundle;
                {
                    this.this$0 = $receiver;
                    this.$resultBundle = $resultBundle;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            try {
                                MqttAsyncClient mqttAsyncClient = MqttConnection.access$getMyClient$p(this.this$0);
                                Intrinsics.checkNotNull((Object)mqttAsyncClient);
                                mqttAsyncClient.reconnect();
                            }
                            catch (MqttException ex) {
                                BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(ex, this.this$0, this.$resultBundle, null){
                                    int label;
                                    final /* synthetic */ MqttException $ex;
                                    final /* synthetic */ MqttConnection this$0;
                                    final /* synthetic */ Bundle $resultBundle;
                                    {
                                        this.$ex = $ex;
                                        this.this$0 = $receiver;
                                        this.$resultBundle = $resultBundle;
                                        super(2, $completion);
                                    }

                                    public final Object invokeSuspend(Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                Timber.Forest.e((Throwable)this.$ex, "Exception occurred attempting to reconnect: " + this.$ex.getMessage(), new Object[0]);
                                                MqttConnection.access$setConnectingState(this.this$0, false);
                                                MqttConnection.access$handleException(this.this$0, this.$resultBundle, (Exception)((Object)this.$ex));
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } else if (this.disconnected && !this.cleanSession) {
            this.service.traceDebug("Do Real Reconnect!");
            Bundle resultBundle = new Bundle();
            resultBundle.putString(".activityToken", String.valueOf(this.reconnectActivityToken));
            resultBundle.putString(".invocationContext", null);
            resultBundle.putString(".callbackAction", "connect");
            try {
                IMqttActionListener listener2 = new MqttConnectionListener(this, resultBundle){
                    final /* synthetic */ MqttConnection this$0;
                    final /* synthetic */ Bundle $resultBundle;
                    {
                        this.this$0 = $receiver;
                        this.$resultBundle = $resultBundle;
                        super($resultBundle);
                    }

                    public void onSuccess(IMqttToken asyncActionToken) {
                        Intrinsics.checkNotNullParameter((Object)asyncActionToken, (String)"asyncActionToken");
                        MqttConnection.access$getService$p(this.this$0).traceDebug("Reconnect Success!");
                        MqttConnection.access$getService$p(this.this$0).traceDebug("DeliverBacklog when reconnect.");
                        this.$resultBundle.putBoolean("sessionPresent", asyncActionToken.getSessionPresent());
                        MqttConnection.access$doAfterConnectSuccess(this.this$0, this.$resultBundle);
                    }

                    public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                        Throwable throwable = exception;
                        this.$resultBundle.putString(".errorMessage", throwable != null ? throwable.getLocalizedMessage() : null);
                        this.$resultBundle.putSerializable(".exception", (Serializable)exception);
                        MqttConnection.access$getService$p(this.this$0).callbackToActivity(this.this$0.getClientHandle(), Status.ERROR, this.$resultBundle);
                        MqttConnection.access$doAfterConnectFail(this.this$0, this.$resultBundle);
                    }
                };
                MqttAsyncClient mqttAsyncClient = this.myClient;
                Intrinsics.checkNotNull((Object)mqttAsyncClient);
                mqttAsyncClient.connect(this.connectOptions, null, listener2);
                this.setConnectingState(true);
            }
            catch (MqttException e) {
                this.service.traceError("Cannot reconnect to remote server." + e.getMessage());
                this.setConnectingState(false);
                this.handleException(resultBundle, (Exception)((Object)e));
            }
            catch (Exception e) {
                this.service.traceError("Cannot reconnect to remote server." + e.getMessage());
                this.setConnectingState(false);
                MqttException newEx = new MqttException(6, e.getCause());
                this.handleException(resultBundle, (Exception)((Object)newEx));
            }
        }
    }

    private final synchronized void setConnectingState(boolean isConnecting) {
        this.isConnecting = isConnecting;
    }

    public final void setBufferOpts(@Nullable DisconnectedBufferOptions bufferOpts) {
        this.disconnectedBufferOptions = bufferOpts;
        MqttAsyncClient mqttAsyncClient = this.myClient;
        Intrinsics.checkNotNull((Object)mqttAsyncClient);
        mqttAsyncClient.setBufferOpts(bufferOpts);
    }

    public final int getBufferedMessageCount() {
        MqttAsyncClient mqttAsyncClient = this.myClient;
        Intrinsics.checkNotNull((Object)mqttAsyncClient);
        return mqttAsyncClient.getBufferedMessageCount();
    }

    @NotNull
    public final MqttMessage getBufferedMessage(int bufferIndex) {
        MqttAsyncClient mqttAsyncClient = this.myClient;
        Intrinsics.checkNotNull((Object)mqttAsyncClient);
        MqttMessage mqttMessage = mqttAsyncClient.getBufferedMessage(bufferIndex);
        Intrinsics.checkNotNullExpressionValue((Object)mqttMessage, (String)"getBufferedMessage(...)");
        return mqttMessage;
    }

    public final void deleteBufferedMessage(int bufferIndex) {
        MqttAsyncClient mqttAsyncClient = this.myClient;
        Intrinsics.checkNotNull((Object)mqttAsyncClient);
        mqttAsyncClient.deleteBufferedMessage(bufferIndex);
    }

    public final int getInFlightMessageCount() {
        MqttAsyncClient mqttAsyncClient = this.myClient;
        Intrinsics.checkNotNull((Object)mqttAsyncClient);
        return mqttAsyncClient.getInFlightMessageCount();
    }

    public static final /* synthetic */ void access$doAfterConnectSuccess(MqttConnection $this, Bundle resultBundle) {
        $this.doAfterConnectSuccess(resultBundle);
    }

    public static final /* synthetic */ void access$doAfterConnectFail(MqttConnection $this, Bundle resultBundle) {
        $this.doAfterConnectFail(resultBundle);
    }

    public static final /* synthetic */ Bundle access$messageToBundle(MqttConnection $this, String messageId, String topic, MqttMessage message) {
        return $this.messageToBundle(messageId, topic, message);
    }

    public static final /* synthetic */ MqttAsyncClient access$getMyClient$p(MqttConnection $this) {
        return $this.myClient;
    }

    public static final /* synthetic */ void access$setConnectingState(MqttConnection $this, boolean isConnecting) {
        $this.setConnectingState(isConnecting);
    }

    public static final /* synthetic */ void access$handleException(MqttConnection $this, Bundle resultBundle, Exception e) {
        $this.handleException(resultBundle, e);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Linfo/mqtt/android/service/MqttConnection$Companion;", "", "<init>", "()V", "TEMP", "", "NOT_CONNECTED", "serviceLibrary_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b\u0092\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\n\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Linfo/mqtt/android/service/MqttConnection$MqttConnectionListener;", "Lorg/eclipse/paho/client/mqttv3/IMqttActionListener;", "resultBundle", "Landroid/os/Bundle;", "<init>", "(Linfo/mqtt/android/service/MqttConnection;Landroid/os/Bundle;)V", "onSuccess", "", "asyncActionToken", "Lorg/eclipse/paho/client/mqttv3/IMqttToken;", "onFailure", "exception", "", "serviceLibrary_release"})
    private class MqttConnectionListener
    implements IMqttActionListener {
        @NotNull
        private final Bundle resultBundle;

        public MqttConnectionListener(Bundle resultBundle) {
            Intrinsics.checkNotNullParameter((Object)resultBundle, (String)"resultBundle");
            this.resultBundle = resultBundle;
        }

        public void onSuccess(@NotNull IMqttToken asyncActionToken) {
            Intrinsics.checkNotNullParameter((Object)asyncActionToken, (String)"asyncActionToken");
            MqttConnection.this.service.callbackToActivity(MqttConnection.this.getClientHandle(), Status.OK, this.resultBundle);
        }

        public void onFailure(@Nullable IMqttToken asyncActionToken, @Nullable Throwable exception) {
            Throwable throwable = exception;
            this.resultBundle.putString(".errorMessage", throwable != null ? throwable.getLocalizedMessage() : null);
            this.resultBundle.putSerializable(".exception", (Serializable)exception);
            MqttConnection.this.service.callbackToActivity(MqttConnection.this.getClientHandle(), Status.ERROR, this.resultBundle);
        }
    }
}

