/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.data;

import android.graphics.Paint;
import androidx.annotation.ColorInt;
import info.appdev.charting.data.CandleEntry;
import info.appdev.charting.data.DataSet;
import info.appdev.charting.data.Entry;
import info.appdev.charting.data.LineScatterCandleRadarDataSet;
import info.appdev.charting.interfaces.datasets.ICandleDataSet;
import info.appdev.charting.utils.NumberUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b(\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001f\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00020)H\u0016J\u0010\u0010(\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0000H\u0004J\u0010\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020\u0002H\u0014J\u0010\u0010.\u001a\u00020*2\u0006\u0010-\u001a\u00020\u0002H\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u001e\u0010\u0019\u001a\u00020\u001a8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001e\u0010\u001f\u001a\u00020\u001a8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u001e\u0010\"\u001a\u00020\u001a8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001c\"\u0004\b$\u0010\u001eR\u001e\u0010%\u001a\u00020\u001a8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001c\"\u0004\b'\u0010\u001eR$\u00100\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\u000b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b1\u00102\"\u0004\b3\u00104R$\u00105\u001a\u00020\r2\u0006\u0010/\u001a\u00020\r8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b6\u00107\"\u0004\b8\u00109R$\u0010:\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\u000b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b;\u00102\"\u0004\b<\u00104R$\u0010=\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\u001a8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b>\u0010\u001c\"\u0004\b?\u0010\u001eR$\u0010@\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\u001a8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bA\u0010\u001c\"\u0004\bB\u0010\u001eR$\u0010C\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\u001a8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bD\u0010\u001c\"\u0004\bE\u0010\u001eR$\u0010F\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\u001a8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bG\u0010\u001c\"\u0004\bH\u0010\u001eR(\u0010I\u001a\u0004\u0018\u00010\u00112\b\u0010/\u001a\u0004\u0018\u00010\u00118V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bJ\u0010\u0013\"\u0004\bK\u0010\u0015R(\u0010L\u001a\u0004\u0018\u00010\u00112\b\u0010/\u001a\u0004\u0018\u00010\u00118V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bM\u0010\u0013\"\u0004\bN\u0010\u0015R$\u0010O\u001a\u00020\r2\u0006\u0010/\u001a\u00020\r8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bP\u00107\"\u0004\bQ\u00109\u00a8\u0006R"}, d2={"Linfo/appdev/charting/data/CandleDataSet;", "Linfo/appdev/charting/data/LineScatterCandleRadarDataSet;", "Linfo/appdev/charting/data/CandleEntry;", "Linfo/appdev/charting/interfaces/datasets/ICandleDataSet;", "yVals", "", "label", "", "<init>", "(Ljava/util/List;Ljava/lang/String;)V", "mShadowWidth", "", "mShowCandleBar", "", "mBarSpace", "mShadowColorSameAsCandle", "mIncreasingPaintStyle", "Landroid/graphics/Paint$Style;", "getMIncreasingPaintStyle", "()Landroid/graphics/Paint$Style;", "setMIncreasingPaintStyle", "(Landroid/graphics/Paint$Style;)V", "mDecreasingPaintStyle", "getMDecreasingPaintStyle", "setMDecreasingPaintStyle", "mNeutralColor", "", "getMNeutralColor", "()I", "setMNeutralColor", "(I)V", "mIncreasingColor", "getMIncreasingColor", "setMIncreasingColor", "mDecreasingColor", "getMDecreasingColor", "setMDecreasingColor", "mShadowColor", "getMShadowColor", "setMShadowColor", "copy", "Linfo/appdev/charting/data/DataSet;", "", "candleDataSet", "calcMinMax", "entry", "calcMinMaxY", "value", "barSpace", "getBarSpace", "()F", "setBarSpace", "(F)V", "showCandleBar", "getShowCandleBar", "()Z", "setShowCandleBar", "(Z)V", "shadowWidth", "getShadowWidth", "setShadowWidth", "shadowColor", "getShadowColor", "setShadowColor", "neutralColor", "getNeutralColor", "setNeutralColor", "increasingColor", "getIncreasingColor", "setIncreasingColor", "decreasingColor", "getDecreasingColor", "setDecreasingColor", "increasingPaintStyle", "getIncreasingPaintStyle", "setIncreasingPaintStyle", "decreasingPaintStyle", "getDecreasingPaintStyle", "setDecreasingPaintStyle", "shadowColorSameAsCandle", "getShadowColorSameAsCandle", "setShadowColorSameAsCandle", "chartLib_release"})
public class CandleDataSet
extends LineScatterCandleRadarDataSet<CandleEntry>
implements ICandleDataSet {
    private float mShadowWidth;
    private boolean mShowCandleBar;
    private float mBarSpace;
    private boolean mShadowColorSameAsCandle;
    @Nullable
    private Paint.Style mIncreasingPaintStyle;
    @Nullable
    private Paint.Style mDecreasingPaintStyle;
    @ColorInt
    private int mNeutralColor;
    @ColorInt
    private int mIncreasingColor;
    @ColorInt
    private int mDecreasingColor;
    @ColorInt
    private int mShadowColor;

    public CandleDataSet(@NotNull List<CandleEntry> yVals, @NotNull String label) {
        Intrinsics.checkNotNullParameter(yVals, (String)"yVals");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        super(yVals, label);
        this.mShadowWidth = 3.0f;
        this.mShowCandleBar = true;
        this.mBarSpace = 0.1f;
        this.mIncreasingPaintStyle = Paint.Style.STROKE;
        this.mDecreasingPaintStyle = Paint.Style.FILL;
        this.mNeutralColor = 1122868;
        this.mIncreasingColor = 1122868;
        this.mDecreasingColor = 1122868;
        this.mShadowColor = 1122868;
    }

    public /* synthetic */ CandleDataSet(List list, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        this(list, string);
    }

    @Nullable
    protected final Paint.Style getMIncreasingPaintStyle() {
        return this.mIncreasingPaintStyle;
    }

    protected final void setMIncreasingPaintStyle(@Nullable Paint.Style style) {
        this.mIncreasingPaintStyle = style;
    }

    @Nullable
    protected final Paint.Style getMDecreasingPaintStyle() {
        return this.mDecreasingPaintStyle;
    }

    protected final void setMDecreasingPaintStyle(@Nullable Paint.Style style) {
        this.mDecreasingPaintStyle = style;
    }

    protected final int getMNeutralColor() {
        return this.mNeutralColor;
    }

    protected final void setMNeutralColor(int n) {
        this.mNeutralColor = n;
    }

    protected final int getMIncreasingColor() {
        return this.mIncreasingColor;
    }

    protected final void setMIncreasingColor(int n) {
        this.mIncreasingColor = n;
    }

    protected final int getMDecreasingColor() {
        return this.mDecreasingColor;
    }

    protected final void setMDecreasingColor(int n) {
        this.mDecreasingColor = n;
    }

    protected final int getMShadowColor() {
        return this.mShadowColor;
    }

    protected final void setMShadowColor(int n) {
        this.mShadowColor = n;
    }

    @Override
    @NotNull
    public DataSet<CandleEntry> copy() {
        List entries = new ArrayList();
        int n = ((Collection)this.getMEntries()).size();
        for (int i = 0; i < n; ++i) {
            entries.add(((CandleEntry)this.getMEntries().get(i)).copy());
        }
        CandleDataSet copied = new CandleDataSet(entries, this.getLabel());
        this.copy(copied);
        return copied;
    }

    protected final void copy(@NotNull CandleDataSet candleDataSet) {
        Intrinsics.checkNotNullParameter((Object)candleDataSet, (String)"candleDataSet");
        super.copy(candleDataSet);
        candleDataSet.mShadowWidth = this.mShadowWidth;
        candleDataSet.mShowCandleBar = this.mShowCandleBar;
        candleDataSet.mBarSpace = this.mBarSpace;
        candleDataSet.mShadowColorSameAsCandle = this.mShadowColorSameAsCandle;
        candleDataSet.setHighLightColor(this.getHighLightColor());
        candleDataSet.mIncreasingPaintStyle = this.mIncreasingPaintStyle;
        candleDataSet.mDecreasingPaintStyle = this.mDecreasingPaintStyle;
        candleDataSet.mNeutralColor = this.mNeutralColor;
        candleDataSet.mIncreasingColor = this.mIncreasingColor;
        candleDataSet.mDecreasingColor = this.mDecreasingColor;
        candleDataSet.mShadowColor = this.mShadowColor;
    }

    @Override
    protected void calcMinMax(@NotNull CandleEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        CandleEntry it = entry;
        boolean bl = false;
        if (entry.getLow() < this.getYMin()) {
            this.setYMin(entry.getLow());
        }
        if (entry.getHigh() > this.getYMax()) {
            this.setYMax(entry.getHigh());
        }
        this.calcMinMaxX((Entry)entry);
    }

    @Override
    protected void calcMinMaxY(@NotNull CandleEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        CandleEntry it = entry;
        boolean bl = false;
        if (entry.getHigh() < this.getYMin()) {
            this.setYMin(entry.getHigh());
        }
        if (entry.getHigh() > this.getYMax()) {
            this.setYMax(entry.getHigh());
        }
        if (entry.getLow() < this.getYMin()) {
            this.setYMin(entry.getLow());
        }
        if (entry.getLow() > this.getYMax()) {
            this.setYMax(entry.getLow());
        }
    }

    @Override
    public float getBarSpace() {
        return this.mBarSpace;
    }

    public void setBarSpace(float value) {
        float space = value;
        if (space < 0.0f) {
            space = 0.0f;
        }
        if (space > 0.45f) {
            space = 0.45f;
        }
        this.mBarSpace = space;
    }

    @Override
    public boolean getShowCandleBar() {
        return this.mShowCandleBar;
    }

    public void setShowCandleBar(boolean value) {
        this.mShowCandleBar = value;
    }

    @Override
    public float getShadowWidth() {
        return this.mShadowWidth;
    }

    public void setShadowWidth(float value) {
        this.mShadowWidth = NumberUtilsKt.convertDpToPixel(value);
    }

    @Override
    public int getShadowColor() {
        return this.mShadowColor;
    }

    public void setShadowColor(int value) {
        this.mShadowColor = value;
    }

    @Override
    public int getNeutralColor() {
        return this.mNeutralColor;
    }

    public void setNeutralColor(int value) {
        this.mNeutralColor = value;
    }

    @Override
    public int getIncreasingColor() {
        return this.mIncreasingColor;
    }

    public void setIncreasingColor(int value) {
        this.mIncreasingColor = value;
    }

    @Override
    public int getDecreasingColor() {
        return this.mDecreasingColor;
    }

    public void setDecreasingColor(int value) {
        this.mDecreasingColor = value;
    }

    @Override
    @Nullable
    public Paint.Style getIncreasingPaintStyle() {
        return this.mIncreasingPaintStyle;
    }

    public void setIncreasingPaintStyle(@Nullable Paint.Style value) {
        this.mIncreasingPaintStyle = value;
    }

    @Override
    @Nullable
    public Paint.Style getDecreasingPaintStyle() {
        return this.mDecreasingPaintStyle;
    }

    public void setDecreasingPaintStyle(@Nullable Paint.Style value) {
        this.mDecreasingPaintStyle = value;
    }

    @Override
    public boolean getShadowColorSameAsCandle() {
        return this.mShadowColorSameAsCandle;
    }

    public void setShadowColorSameAsCandle(boolean value) {
        this.mShadowColorSameAsCandle = value;
    }
}

