/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.charts;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.util.AttributeSet;
import info.appdev.charting.charts.PieRadarChartBase;
import info.appdev.charting.components.XAxis;
import info.appdev.charting.data.PieData;
import info.appdev.charting.data.PieEntry;
import info.appdev.charting.highlight.Highlight;
import info.appdev.charting.highlight.PieHighlighter;
import info.appdev.charting.interfaces.datasets.IPieDataSet;
import info.appdev.charting.renderer.DataRenderer;
import info.appdev.charting.renderer.LegendRenderer;
import info.appdev.charting.renderer.PieChartRenderer;
import info.appdev.charting.utils.NumberUtilsKt;
import info.appdev.charting.utils.PointF;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u000e\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001d\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0005\u0010\tB%\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0005\u0010\fJ\b\u0010;\u001a\u00020<H\u0014J\u0010\u0010=\u001a\u00020<2\u0006\u0010>\u001a\u00020?H\u0014J\b\u0010@\u001a\u00020<H\u0016J\b\u0010A\u001a\u00020<H\u0014J\u0010\u0010B\u001a\u00020\u00172\u0006\u0010C\u001a\u00020DH\u0014J\b\u0010E\u001a\u00020<H\u0002J\u000e\u0010F\u001a\u00020\u00122\u0006\u0010G\u001a\u00020\u000bJ\u0018\u0010H\u001a\u00020*2\u0006\u0010\u0016\u001a\u00020*2\u0006\u0010I\u001a\u00020*H\u0002J\u0010\u0010P\u001a\u00020\u000b2\u0006\u0010Q\u001a\u00020*H\u0016J\u000e\u0010R\u001a\u00020\u000b2\u0006\u0010S\u001a\u00020\u000bJ\u000e\u0010T\u001a\u00020<2\u0006\u0010U\u001a\u00020\u000bJ\u0010\u0010e\u001a\u00020<2\b\u0010f\u001a\u0004\u0018\u00010gJ\u000e\u0010h\u001a\u00020<2\u0006\u0010i\u001a\u00020*J\u000e\u0010j\u001a\u00020<2\u0006\u0010k\u001a\u00020*J\u0016\u0010l\u001a\u00020<2\u0006\u0010m\u001a\u00020*2\u0006\u0010n\u001a\u00020*J\u000e\u0010q\u001a\u00020<2\u0006\u0010U\u001a\u00020\u000bJ\u000e\u0010r\u001a\u00020<2\u0006\u0010U\u001a\u00020\u000bJ\u000e\u0010s\u001a\u00020<2\u0006\u0010t\u001a\u00020\u000bJ\u000e\u0010u\u001a\u00020<2\u0006\u0010U\u001a\u00020\u000bJ\u0010\u0010v\u001a\u00020<2\b\u0010w\u001a\u0004\u0018\u00010gJ\u000e\u0010x\u001a\u00020<2\u0006\u0010y\u001a\u00020*J\t\u0010\u0081\u0001\u001a\u00020<H\u0014R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u001a\u0010\u001d\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0013\"\u0004\b\u001e\u0010\u0015R\u001a\u0010\u001f\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0013\"\u0004\b \u0010\u0015R\u001a\u0010!\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0013\"\u0004\b\"\u0010\u0015R\u001a\u0010#\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0013\"\u0004\b$\u0010\u0015R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010)\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010,\"\u0004\b1\u0010.R\u001a\u00102\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u0013\"\u0004\b3\u0010\u0015R\u001a\u00104\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010,\"\u0004\b6\u0010.R\u001a\u00107\u001a\u00020*X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010,\"\u0004\b9\u0010.R\u000e\u0010:\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010J\u001a\u00020K8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\bL\u0010M\u001a\u0004\bN\u0010OR(\u0010W\u001a\u0004\u0018\u00010&2\b\u0010V\u001a\u0004\u0018\u00010&8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bX\u0010Y\"\u0004\bZ\u0010[R\u0014\u0010\\\u001a\u00020*8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b]\u0010,R\u0014\u0010^\u001a\u00020*8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b_\u0010,R\u0014\u0010`\u001a\u00020*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\ba\u0010,R\u0011\u0010b\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\bc\u0010dR\u0011\u0010o\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\bp\u0010dR$\u0010z\u001a\u00020*2\u0006\u0010\u0016\u001a\u00020*8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b{\u0010,\"\u0004\b|\u0010.R%\u0010~\u001a\u00020*2\u0006\u0010}\u001a\u00020*8F@FX\u0086\u000e\u00a2\u0006\r\u001a\u0004\b\u007f\u0010,\"\u0005\b\u0080\u0001\u0010.R\u0018\u0010\u0082\u0001\u001a\u00030\u0083\u00018VX\u0096\u0004\u00a2\u0006\b\u001a\u0006\b\u0084\u0001\u0010\u0085\u0001\u00a8\u0006\u0086\u0001"}, d2={"Linfo/appdev/charting/charts/PieChart;", "Linfo/appdev/charting/charts/PieRadarChartBase;", "Linfo/appdev/charting/data/PieData;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "circleBox", "Landroid/graphics/RectF;", "getCircleBox", "()Landroid/graphics/RectF;", "isDrawEntryLabels", "", "()Z", "setDrawEntryLabels", "(Z)V", "value", "", "drawAngles", "getDrawAngles", "()[F", "absoluteAngles", "getAbsoluteAngles", "isDrawHole", "setDrawHole", "isDrawSlicesUnderHole", "setDrawSlicesUnderHole", "isUsePercentValues", "setUsePercentValues", "isDrawRoundedSlices", "setDrawRoundedSlices", "mCenterText", "", "mCenterTextOffset", "Linfo/appdev/charting/utils/PointF;", "holeRadius", "", "getHoleRadius", "()F", "setHoleRadius", "(F)V", "transparentCircleRadius", "getTransparentCircleRadius", "setTransparentCircleRadius", "isDrawCenterText", "setDrawCenterText", "centerTextRadiusPercent", "getCenterTextRadiusPercent", "setCenterTextRadiusPercent", "mMaxAngle", "getMMaxAngle", "setMMaxAngle", "mMinAngleForSlices", "init", "", "onDraw", "canvas", "Landroid/graphics/Canvas;", "calculateOffsets", "calcMinMax", "getMarkerPosition", "high", "Linfo/appdev/charting/highlight/Highlight;", "calcAngles", "needsHighlight", "index", "calcAngle", "yValueSum", "xAxis", "Linfo/appdev/charting/components/XAxis;", "getXAxis$annotations", "()V", "getXAxis", "()Linfo/appdev/charting/components/XAxis;", "getIndexForAngle", "angle", "getDataSetIndexForIndex", "xIndex", "setHoleColor", "color", "text", "centerText", "getCenterText", "()Ljava/lang/CharSequence;", "setCenterText", "(Ljava/lang/CharSequence;)V", "requiredLegendOffset", "getRequiredLegendOffset", "requiredBaseOffset", "getRequiredBaseOffset", "radius", "getRadius", "centerCircleBox", "getCenterCircleBox", "()Linfo/appdev/charting/utils/PointF;", "setCenterTextTypeface", "t", "Landroid/graphics/Typeface;", "setCenterTextSize", "sizeDp", "setCenterTextSizePixels", "sizePixels", "setCenterTextOffset", "x", "y", "centerTextOffset", "getCenterTextOffset", "setCenterTextColor", "setTransparentCircleColor", "setTransparentCircleAlpha", "alpha", "setEntryLabelColor", "setEntryLabelTypeface", "tf", "setEntryLabelTextSize", "size", "maxAngle", "getMaxAngle", "setMaxAngle", "minAngle", "minAngleForSlices", "getMinAngleForSlices", "setMinAngleForSlices", "onDetachedFromWindow", "accessibilityDescription", "", "getAccessibilityDescription", "()Ljava/lang/String;", "chartLib_release"})
public class PieChart
extends PieRadarChartBase<PieData> {
    @NotNull
    private final RectF circleBox = new RectF();
    private boolean isDrawEntryLabels = true;
    @NotNull
    private float[] drawAngles = new float[1];
    @NotNull
    private float[] absoluteAngles = new float[1];
    private boolean isDrawHole = true;
    private boolean isDrawSlicesUnderHole;
    private boolean isUsePercentValues;
    private boolean isDrawRoundedSlices;
    @NotNull
    private CharSequence mCenterText = "";
    @NotNull
    private final PointF mCenterTextOffset = PointF.Companion.getInstance(0.0f, 0.0f);
    private float holeRadius = 50.0f;
    private float transparentCircleRadius = 55.0f;
    private boolean isDrawCenterText = true;
    private float centerTextRadiusPercent = 100.0f;
    private float mMaxAngle = 360.0f;
    private float mMinAngleForSlices;

    @NotNull
    public final RectF getCircleBox() {
        return this.circleBox;
    }

    public final boolean isDrawEntryLabels() {
        return this.isDrawEntryLabels;
    }

    public final void setDrawEntryLabels(boolean bl) {
        this.isDrawEntryLabels = bl;
    }

    @NotNull
    public final float[] getDrawAngles() {
        return this.drawAngles;
    }

    @NotNull
    public final float[] getAbsoluteAngles() {
        return this.absoluteAngles;
    }

    public final boolean isDrawHole() {
        return this.isDrawHole;
    }

    public final void setDrawHole(boolean bl) {
        this.isDrawHole = bl;
    }

    public final boolean isDrawSlicesUnderHole() {
        return this.isDrawSlicesUnderHole;
    }

    public final void setDrawSlicesUnderHole(boolean bl) {
        this.isDrawSlicesUnderHole = bl;
    }

    public final boolean isUsePercentValues() {
        return this.isUsePercentValues;
    }

    public final void setUsePercentValues(boolean bl) {
        this.isUsePercentValues = bl;
    }

    public final boolean isDrawRoundedSlices() {
        return this.isDrawRoundedSlices;
    }

    public final void setDrawRoundedSlices(boolean bl) {
        this.isDrawRoundedSlices = bl;
    }

    public final float getHoleRadius() {
        return this.holeRadius;
    }

    public final void setHoleRadius(float f) {
        this.holeRadius = f;
    }

    public final float getTransparentCircleRadius() {
        return this.transparentCircleRadius;
    }

    public final void setTransparentCircleRadius(float f) {
        this.transparentCircleRadius = f;
    }

    public final boolean isDrawCenterText() {
        return this.isDrawCenterText;
    }

    public final void setDrawCenterText(boolean bl) {
        this.isDrawCenterText = bl;
    }

    public final float getCenterTextRadiusPercent() {
        return this.centerTextRadiusPercent;
    }

    public final void setCenterTextRadiusPercent(float f) {
        this.centerTextRadiusPercent = f;
    }

    protected final float getMMaxAngle() {
        return this.mMaxAngle;
    }

    protected final void setMMaxAngle(float f) {
        this.mMaxAngle = f;
    }

    public PieChart(@Nullable Context context) {
        super(context);
    }

    public PieChart(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public PieChart(@Nullable Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init() {
        super.init();
        this.setDataRenderer(new PieChartRenderer(this, this.getMAnimator(), this.getViewPortHandler()));
        this.setHighlighter(new PieHighlighter(this));
    }

    @Override
    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        if (this.getMData() == null) {
            return;
        }
        DataRenderer dataRenderer = this.getDataRenderer();
        if (dataRenderer != null) {
            dataRenderer.drawData(canvas);
        }
        if (this.valuesToHighlight()) {
            DataRenderer dataRenderer2 = this.getDataRenderer();
            if (dataRenderer2 != null) {
                Highlight[] highlightArray = this.getHighlighted();
                Intrinsics.checkNotNull((Object)highlightArray);
                dataRenderer2.drawHighlighted(canvas, highlightArray);
            }
        }
        DataRenderer dataRenderer3 = this.getDataRenderer();
        if (dataRenderer3 != null) {
            dataRenderer3.drawExtras(canvas);
        }
        DataRenderer dataRenderer4 = this.getDataRenderer();
        if (dataRenderer4 != null) {
            dataRenderer4.drawValues(canvas);
        }
        LegendRenderer legendRenderer = this.getLegendRenderer();
        if (legendRenderer != null) {
            legendRenderer.renderLegend(canvas);
        }
        this.drawDescription(canvas);
        this.drawMarkers(canvas);
    }

    @Override
    public void calculateOffsets() {
        block0: {
            super.calculateOffsets();
            PieData pieData = (PieData)this.getMData();
            if (pieData == null) break block0;
            PieData data = pieData;
            boolean bl = false;
            float diameter = this.getDiameter();
            float radius = diameter / 2.0f;
            float shift = data.getDataSet().getSelectionShift();
            this.circleBox.set(this.getCenterOffsets().getX() - radius + shift, this.getCenterOffsets().getY() - radius + shift, this.getCenterOffsets().getX() + radius - shift, this.getCenterOffsets().getY() + radius - shift);
            PointF.Companion.recycleInstance(this.getCenterOffsets());
        }
    }

    @Override
    protected void calcMinMax() {
        this.calcAngles();
    }

    @Override
    @NotNull
    protected float[] getMarkerPosition(@NotNull Highlight high) {
        Intrinsics.checkNotNullParameter((Object)high, (String)"high");
        PointF center = this.getCenterCircleBox();
        float r = this.getRadius();
        float off = r / 10.0f * 3.6f;
        if (this.isDrawHole) {
            off = (r - r / 100.0f * this.holeRadius) / 2.0f;
        }
        float rotationAngle = this.getRotationAngle();
        int entryIndex = (int)high.getX();
        float offset = this.drawAngles[entryIndex] / (float)2;
        float x = (float)((double)(r -= off) * Math.cos(Math.toRadians((rotationAngle + this.absoluteAngles[entryIndex] - offset) * this.getMAnimator().getPhaseY())) + (double)center.getX());
        float y = (float)((double)r * Math.sin(Math.toRadians((rotationAngle + this.absoluteAngles[entryIndex] - offset) * this.getMAnimator().getPhaseY())) + (double)center.getY());
        PointF.Companion.recycleInstance(center);
        float[] fArray = new float[]{x, y};
        return fArray;
    }

    private final void calcAngles() {
        block14: {
            int i;
            int i2;
            PieData pieData = (PieData)this.getMData();
            if (pieData == null) break block14;
            PieData data = pieData;
            boolean bl = false;
            int entryCount = data.getEntryCount();
            if (this.drawAngles.length != entryCount) {
                this.drawAngles = new float[entryCount];
            } else {
                for (i2 = 0; i2 < entryCount; ++i2) {
                    this.drawAngles[i2] = 0.0f;
                }
            }
            if (this.absoluteAngles.length != entryCount) {
                this.absoluteAngles = new float[entryCount];
            } else {
                for (i2 = 0; i2 < entryCount; ++i2) {
                    this.absoluteAngles[i2] = 0.0f;
                }
            }
            float yValueSum = data.getYValueSum();
            List<IPieDataSet> dataSets = data.getDataSets();
            boolean hasMinAngle = !(this.mMinAngleForSlices == 0.0f) && (float)entryCount * this.mMinAngleForSlices <= this.mMaxAngle;
            float[] minAngles = new float[entryCount];
            int cnt = 0;
            float offset = 0.0f;
            float diff = 0.0f;
            int n = data.getDataSetCount();
            for (i = 0; i < n; ++i) {
                IPieDataSet set = dataSets.get(i);
                int n2 = set.getEntryCount();
                for (int j = 0; j < n2; ++j) {
                    Object t = set.getEntryForIndex(j);
                    Intrinsics.checkNotNull(t);
                    float drawAngle = this.calcAngle(Math.abs(((PieEntry)t).getY()), yValueSum);
                    if (hasMinAngle) {
                        float temp = drawAngle - this.mMinAngleForSlices;
                        if (temp <= 0.0f) {
                            minAngles[cnt] = this.mMinAngleForSlices;
                            offset -= temp;
                        } else {
                            minAngles[cnt] = drawAngle;
                            diff += temp;
                        }
                    }
                    this.drawAngles[cnt] = drawAngle;
                    this.absoluteAngles[cnt] = cnt == 0 ? this.drawAngles[cnt] : this.absoluteAngles[cnt - 1] + this.drawAngles[cnt];
                    ++cnt;
                }
            }
            if (hasMinAngle) {
                for (i = 0; i < entryCount; ++i) {
                    n = i;
                    minAngles[n] = minAngles[n] - (minAngles[i] - this.mMinAngleForSlices) / diff * offset;
                    if (i == 0) {
                        this.absoluteAngles[0] = minAngles[0];
                        continue;
                    }
                    this.absoluteAngles[i] = this.absoluteAngles[i - 1] + minAngles[i];
                }
                this.drawAngles = minAngles;
            }
        }
    }

    public final boolean needsHighlight(int index) {
        block2: {
            if (!this.valuesToHighlight()) {
                return false;
            }
            Highlight[] highlightArray = this.getHighlighted();
            if (highlightArray == null) break block2;
            Highlight[] it = highlightArray;
            boolean bl = false;
            for (Highlight highlight : it) {
                if ((int)highlight.getX() != index) continue;
                return true;
            }
        }
        return false;
    }

    private final float calcAngle(float value, float yValueSum) {
        return value / yValueSum * this.mMaxAngle;
    }

    @Override
    @NotNull
    public XAxis getXAxis() {
        throw new RuntimeException("PieChart has no XAxis");
    }

    @Deprecated(message="PieChart has no XAxis")
    public static /* synthetic */ void getXAxis$annotations() {
    }

    @Override
    public int getIndexForAngle(float angle) {
        float a = NumberUtilsKt.getNormalizedAngle(angle - this.getRotationAngle());
        int n = this.absoluteAngles.length;
        for (int i = 0; i < n; ++i) {
            if (!(this.absoluteAngles[i] > a)) continue;
            return i;
        }
        return -1;
    }

    public final int getDataSetIndexForIndex(int xIndex) {
        PieData pieData = (PieData)this.getMData();
        List<IPieDataSet> dataSets = pieData != null ? pieData.getDataSets() : null;
        List<IPieDataSet> list = dataSets;
        Intrinsics.checkNotNull(list);
        int n = ((Collection)list).size();
        for (int i = 0; i < n; ++i) {
            if (dataSets.get(i).getEntryForXValue(xIndex, Float.NaN) == null) continue;
            return i;
        }
        return -1;
    }

    public final void setHoleColor(int color) {
        DataRenderer dataRenderer = this.getDataRenderer();
        Intrinsics.checkNotNull((Object)dataRenderer, (String)"null cannot be cast to non-null type info.appdev.charting.renderer.PieChartRenderer");
        ((PieChartRenderer)dataRenderer).getPaintHole().setColor(color);
    }

    @Nullable
    public final CharSequence getCenterText() {
        return this.mCenterText;
    }

    public final void setCenterText(@Nullable CharSequence text) {
        String string = Objects.requireNonNullElse(text, "");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"requireNonNullElse(...)");
        this.mCenterText = string;
    }

    @Override
    protected float getRequiredLegendOffset() {
        LegendRenderer legendRenderer = this.getLegendRenderer();
        if (legendRenderer != null) {
            LegendRenderer it = legendRenderer;
            boolean bl = false;
            return it.getLabelPaint().getTextSize() * 2.0f;
        }
        return 0.0f;
    }

    @Override
    protected float getRequiredBaseOffset() {
        return 0.0f;
    }

    @Override
    public float getRadius() {
        return Math.min(this.circleBox.width() / 2.0f, this.circleBox.height() / 2.0f);
    }

    @NotNull
    public final PointF getCenterCircleBox() {
        return PointF.Companion.getInstance(this.circleBox.centerX(), this.circleBox.centerY());
    }

    public final void setCenterTextTypeface(@Nullable Typeface t) {
        DataRenderer dataRenderer = this.getDataRenderer();
        Intrinsics.checkNotNull((Object)dataRenderer, (String)"null cannot be cast to non-null type info.appdev.charting.renderer.PieChartRenderer");
        ((PieChartRenderer)dataRenderer).getPaintCenterText().setTypeface(t);
    }

    public final void setCenterTextSize(float sizeDp) {
        DataRenderer dataRenderer = this.getDataRenderer();
        Intrinsics.checkNotNull((Object)dataRenderer, (String)"null cannot be cast to non-null type info.appdev.charting.renderer.PieChartRenderer");
        ((PieChartRenderer)dataRenderer).getPaintCenterText().setTextSize(NumberUtilsKt.convertDpToPixel(sizeDp));
    }

    public final void setCenterTextSizePixels(float sizePixels) {
        DataRenderer dataRenderer = this.getDataRenderer();
        Intrinsics.checkNotNull((Object)dataRenderer, (String)"null cannot be cast to non-null type info.appdev.charting.renderer.PieChartRenderer");
        ((PieChartRenderer)dataRenderer).getPaintCenterText().setTextSize(sizePixels);
    }

    public final void setCenterTextOffset(float x, float y) {
        this.mCenterTextOffset.setX(NumberUtilsKt.convertDpToPixel(x));
        this.mCenterTextOffset.setY(NumberUtilsKt.convertDpToPixel(y));
    }

    @NotNull
    public final PointF getCenterTextOffset() {
        return PointF.Companion.getInstance(this.mCenterTextOffset.getX(), this.mCenterTextOffset.getY());
    }

    public final void setCenterTextColor(int color) {
        DataRenderer dataRenderer = this.getDataRenderer();
        Intrinsics.checkNotNull((Object)dataRenderer, (String)"null cannot be cast to non-null type info.appdev.charting.renderer.PieChartRenderer");
        ((PieChartRenderer)dataRenderer).getPaintCenterText().setColor(color);
    }

    public final void setTransparentCircleColor(int color) {
        DataRenderer dataRenderer = this.getDataRenderer();
        Intrinsics.checkNotNull((Object)dataRenderer, (String)"null cannot be cast to non-null type info.appdev.charting.renderer.PieChartRenderer");
        Paint p = ((PieChartRenderer)dataRenderer).getPaintTransparentCircle();
        int alpha = p.getAlpha();
        p.setColor(color);
        p.setAlpha(alpha);
    }

    public final void setTransparentCircleAlpha(int alpha) {
        DataRenderer dataRenderer = this.getDataRenderer();
        Intrinsics.checkNotNull((Object)dataRenderer, (String)"null cannot be cast to non-null type info.appdev.charting.renderer.PieChartRenderer");
        ((PieChartRenderer)dataRenderer).getPaintTransparentCircle().setAlpha(alpha);
    }

    public final void setEntryLabelColor(int color) {
        DataRenderer dataRenderer = this.getDataRenderer();
        Intrinsics.checkNotNull((Object)dataRenderer, (String)"null cannot be cast to non-null type info.appdev.charting.renderer.PieChartRenderer");
        ((PieChartRenderer)dataRenderer).getPaintEntryLabels().setColor(color);
    }

    public final void setEntryLabelTypeface(@Nullable Typeface tf) {
        DataRenderer dataRenderer = this.getDataRenderer();
        Intrinsics.checkNotNull((Object)dataRenderer, (String)"null cannot be cast to non-null type info.appdev.charting.renderer.PieChartRenderer");
        ((PieChartRenderer)dataRenderer).getPaintEntryLabels().setTypeface(tf);
    }

    public final void setEntryLabelTextSize(float size) {
        DataRenderer dataRenderer = this.getDataRenderer();
        Intrinsics.checkNotNull((Object)dataRenderer, (String)"null cannot be cast to non-null type info.appdev.charting.renderer.PieChartRenderer");
        ((PieChartRenderer)dataRenderer).getPaintEntryLabels().setTextSize(NumberUtilsKt.convertDpToPixel(size));
    }

    public final float getMaxAngle() {
        return this.mMaxAngle;
    }

    public final void setMaxAngle(float value) {
        float maxAngle = value;
        if (maxAngle > 360.0f) {
            maxAngle = 360.0f;
        }
        if (maxAngle < 90.0f) {
            maxAngle = 90.0f;
        }
        this.mMaxAngle = maxAngle;
    }

    public final float getMinAngleForSlices() {
        return this.mMinAngleForSlices;
    }

    public final void setMinAngleForSlices(float minAngle) {
        float minAngle2 = minAngle;
        if (minAngle2 > this.mMaxAngle / 2.0f) {
            minAngle2 = this.mMaxAngle / 2.0f;
        } else if (minAngle2 < 0.0f) {
            minAngle2 = 0.0f;
        }
        this.mMinAngleForSlices = minAngle2;
    }

    @Override
    protected void onDetachedFromWindow() {
        if (this.getDataRenderer() != null && this.getDataRenderer() instanceof PieChartRenderer) {
            DataRenderer dataRenderer = this.getDataRenderer();
            Intrinsics.checkNotNull((Object)dataRenderer, (String)"null cannot be cast to non-null type info.appdev.charting.renderer.PieChartRenderer");
            ((PieChartRenderer)dataRenderer).releaseBitmap();
        }
        super.onDetachedFromWindow();
    }

    @Override
    @NotNull
    public String getAccessibilityDescription() {
        PieData pieData = (PieData)this.getData();
        int entryCount = 0;
        if (pieData != null) {
            entryCount = pieData.getEntryCount();
        }
        StringBuilder builder = new StringBuilder();
        Locale locale = Locale.getDefault();
        String string = "The pie chart has %d entries.";
        Object[] objectArray = new Object[]{entryCount};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        builder.append(string2);
        int n = entryCount;
        for (int i = 0; i < n; ++i) {
            PieEntry entry;
            PieData pieData2 = pieData;
            Intrinsics.checkNotNull((Object)pieData2);
            PieEntry pieEntry = entry = (PieEntry)pieData2.getDataSet().getEntryForIndex(i);
            Intrinsics.checkNotNull((Object)pieEntry);
            float percentage = pieEntry.getValue() / pieData.getYValueSum() * (float)100;
            Locale locale2 = Locale.getDefault();
            String string3 = "%s has %.2f percent pie taken";
            Object[] objectArray2 = new Object[]{TextUtils.isEmpty((CharSequence)entry.getLabel()) ? "No Label" : entry.getLabel(), Float.valueOf(percentage)};
            String string4 = String.format(locale2, string3, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            builder.append(string4);
        }
        String string5 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
        return string5;
    }
}

