/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.renderer;

import android.graphics.Canvas;
import info.appdev.charting.charts.RadarChart;
import info.appdev.charting.components.XAxis;
import info.appdev.charting.data.ChartData;
import info.appdev.charting.data.RadarData;
import info.appdev.charting.formatter.IAxisValueFormatter;
import info.appdev.charting.interfaces.datasets.IRadarDataSet;
import info.appdev.charting.renderer.XAxisRenderer;
import info.appdev.charting.utils.PointF;
import info.appdev.charting.utils.PointFKt;
import info.appdev.charting.utils.ViewPortHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Linfo/appdev/charting/renderer/XAxisRendererRadarChart;", "Linfo/appdev/charting/renderer/XAxisRenderer;", "viewPortHandler", "Linfo/appdev/charting/utils/ViewPortHandler;", "xAxis", "Linfo/appdev/charting/components/XAxis;", "chart", "Linfo/appdev/charting/charts/RadarChart;", "<init>", "(Linfo/appdev/charting/utils/ViewPortHandler;Linfo/appdev/charting/components/XAxis;Linfo/appdev/charting/charts/RadarChart;)V", "renderAxisLabels", "", "canvas", "Landroid/graphics/Canvas;", "renderLimitLines", "chartLib_release"})
public final class XAxisRendererRadarChart
extends XAxisRenderer {
    @NotNull
    private final RadarChart chart;

    public XAxisRendererRadarChart(@NotNull ViewPortHandler viewPortHandler, @NotNull XAxis xAxis, @NotNull RadarChart chart) {
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        Intrinsics.checkNotNullParameter((Object)xAxis, (String)"xAxis");
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        super(viewPortHandler, xAxis, null);
        this.chart = chart;
    }

    @Override
    public void renderAxisLabels(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (!this.getXAxis().isEnabled() || !this.getXAxis().isDrawLabelsEnabled()) {
            return;
        }
        float labelRotationAngleDegrees = this.getXAxis().getLabelRotationAngle();
        PointF drawLabelAnchor = PointF.Companion.getInstance(0.5f, 0.25f);
        this.getPaintAxisLabels().setTypeface(this.getXAxis().getTypeface());
        this.getPaintAxisLabels().setTextSize(this.getXAxis().getTextSize());
        this.getPaintAxisLabels().setColor(this.getXAxis().getTextColor());
        float sliceAngle = this.chart.getSliceAngle();
        float factor = this.chart.getFactor();
        PointF center = this.chart.getCenterOffsets();
        PointF pOut = null;
        pOut = PointF.Companion.getInstance(0.0f, 0.0f);
        Object object = (RadarData)this.chart.getData();
        if (object != null && (object = (IRadarDataSet)((ChartData)object).getMaxEntryCountSet()) != null) {
            Object maxEntryCountSet = object;
            boolean bl = false;
            int n = maxEntryCountSet.getEntryCount();
            for (int i = 0; i < n; ++i) {
                IAxisValueFormatter iAxisValueFormatter = this.getXAxis().getValueFormatter();
                String label = iAxisValueFormatter != null ? iAxisValueFormatter.getFormattedValue(i, this.getXAxis()) : null;
                float angle = (sliceAngle * (float)i + this.chart.getRotationAngle()) % 360.0f;
                pOut = PointFKt.getPosition(center, this.chart.getYRange() * factor + (float)this.getXAxis().getMLabelWidth() / 2.0f, angle);
                this.drawLabel(canvas, label, pOut.getX(), pOut.getY() - (float)this.getXAxis().getMLabelHeight() / 2.0f, drawLabelAnchor, labelRotationAngleDegrees);
            }
        }
        PointF.Companion.recycleInstance(center);
        PointF.Companion.recycleInstance(pOut);
        PointF.Companion.recycleInstance(drawLabelAnchor);
    }

    @Override
    public void renderLimitLines(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
    }
}

