/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.renderer;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import info.appdev.charting.animation.ChartAnimator;
import info.appdev.charting.data.BaseEntry;
import info.appdev.charting.data.Entry;
import info.appdev.charting.data.ScatterData;
import info.appdev.charting.highlight.Highlight;
import info.appdev.charting.interfaces.dataprovider.ScatterDataProvider;
import info.appdev.charting.interfaces.datasets.IScatterDataSet;
import info.appdev.charting.renderer.LineScatterCandleRadarRenderer;
import info.appdev.charting.renderer.scatter.IShapeRenderer;
import info.appdev.charting.utils.CanvasUtilsKt;
import info.appdev.charting.utils.NumberUtilsKt;
import info.appdev.charting.utils.PointD;
import info.appdev.charting.utils.PointF;
import info.appdev.charting.utils.Transformer;
import info.appdev.charting.utils.ViewPortHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0004J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J#\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016\u00a2\u0006\u0002\u0010\"R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006#"}, d2={"Linfo/appdev/charting/renderer/ScatterChartRenderer;", "Linfo/appdev/charting/renderer/LineScatterCandleRadarRenderer;", "dataProvider", "Linfo/appdev/charting/interfaces/dataprovider/ScatterDataProvider;", "animator", "Linfo/appdev/charting/animation/ChartAnimator;", "viewPortHandler", "Linfo/appdev/charting/utils/ViewPortHandler;", "<init>", "(Linfo/appdev/charting/interfaces/dataprovider/ScatterDataProvider;Linfo/appdev/charting/animation/ChartAnimator;Linfo/appdev/charting/utils/ViewPortHandler;)V", "getDataProvider", "()Linfo/appdev/charting/interfaces/dataprovider/ScatterDataProvider;", "setDataProvider", "(Linfo/appdev/charting/interfaces/dataprovider/ScatterDataProvider;)V", "initBuffers", "", "drawData", "canvas", "Landroid/graphics/Canvas;", "pixelBuffer", "", "getPixelBuffer", "()[F", "setPixelBuffer", "([F)V", "drawDataSet", "dataSet", "Linfo/appdev/charting/interfaces/datasets/IScatterDataSet;", "drawValues", "drawExtras", "drawHighlighted", "indices", "", "Linfo/appdev/charting/highlight/Highlight;", "(Landroid/graphics/Canvas;[Linfo/appdev/charting/highlight/Highlight;)V", "chartLib_release"})
public class ScatterChartRenderer
extends LineScatterCandleRadarRenderer {
    @NotNull
    private ScatterDataProvider dataProvider;
    @NotNull
    private float[] pixelBuffer;

    public ScatterChartRenderer(@NotNull ScatterDataProvider dataProvider, @NotNull ChartAnimator animator, @NotNull ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        super(animator, viewPortHandler);
        this.dataProvider = dataProvider;
        this.pixelBuffer = new float[2];
    }

    @NotNull
    public final ScatterDataProvider getDataProvider() {
        return this.dataProvider;
    }

    public final void setDataProvider(@NotNull ScatterDataProvider scatterDataProvider) {
        Intrinsics.checkNotNullParameter((Object)scatterDataProvider, (String)"<set-?>");
        this.dataProvider = scatterDataProvider;
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(@NotNull Canvas canvas) {
        block1: {
            ScatterData scatterData;
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            ScatterData scatterData2 = scatterData = this.dataProvider.getScatterData();
            if (scatterData2 == null) break block1;
            ScatterData it = scatterData2;
            boolean bl = false;
            for (IScatterDataSet set : it.getDataSets()) {
                if (!set.isVisible()) continue;
                this.drawDataSet(canvas, set);
            }
        }
    }

    @NotNull
    public final float[] getPixelBuffer() {
        return this.pixelBuffer;
    }

    public final void setPixelBuffer(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.pixelBuffer = fArray;
    }

    protected final void drawDataSet(@NotNull Canvas canvas, @NotNull IScatterDataSet dataSet) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        if (dataSet.getEntryCount() < 1) {
            return;
        }
        ViewPortHandler viewPortHandler = this.getViewPortHandler();
        Transformer trans = this.dataProvider.getTransformer(dataSet.getAxisDependency());
        float phaseY = this.getAnimator().getPhaseY();
        IShapeRenderer renderer = dataSet.getShapeRenderer();
        if (renderer == null) {
            Timber.Forest.i("There's no IShapeRenderer specified for ScatterDataSet", new Object[0]);
            return;
        }
        int max = (int)Math.min(Math.ceil((float)dataSet.getEntryCount() * this.getAnimator().getPhaseX()), (double)dataSet.getEntryCount());
        for (int i = 0; i < max; ++i) {
            Object entry;
            if (dataSet.getEntryForIndex(i) == null) continue;
            boolean bl = false;
            this.pixelBuffer[0] = ((Entry)entry).getX();
            this.pixelBuffer[1] = ((BaseEntry)entry).getY() * phaseY;
            Transformer transformer = trans;
            Intrinsics.checkNotNull((Object)transformer);
            transformer.pointValuesToPixel(this.pixelBuffer);
            if (!viewPortHandler.isInBoundsRight(this.pixelBuffer[0])) break;
            if (!viewPortHandler.isInBoundsLeft(this.pixelBuffer[0]) || !viewPortHandler.isInBoundsY(this.pixelBuffer[1])) continue;
            this.getPaintRender().setColor(dataSet.getColorByIndex(i / 2));
            renderer.renderShape(canvas, dataSet, this.getViewPortHandler(), this.pixelBuffer[0], this.pixelBuffer[1], this.getPaintRender());
        }
    }

    @Override
    public void drawValues(@NotNull Canvas canvas) {
        block8: {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            if (!this.isDrawingValuesAllowed(this.dataProvider)) break block8;
            ScatterData scatterData = this.dataProvider.getScatterData();
            if (scatterData != null) {
                ScatterData scatterData2 = scatterData;
                boolean bl = false;
                int n = scatterData2.getDataSetCount();
                for (int i = 0; i < n; ++i) {
                    IScatterDataSet dataSet = (IScatterDataSet)scatterData2.getDataSets().get(i);
                    if (dataSet.getEntryCount() == 0 || !this.shouldDrawValues(dataSet) || dataSet.getEntryCount() < 1) continue;
                    this.applyValueTextStyle(dataSet);
                    this.getXBounds().set(this.dataProvider, dataSet);
                    Transformer transformer = this.dataProvider.getTransformer(dataSet.getAxisDependency());
                    Intrinsics.checkNotNull((Object)transformer);
                    float[] positions = transformer.generateTransformedValuesScatter(dataSet, this.getAnimator().getPhaseX(), this.getAnimator().getPhaseY(), this.getXBounds().getMin(), this.getXBounds().getMax());
                    float shapeSize = NumberUtilsKt.convertDpToPixel(dataSet.getScatterShapeSize());
                    PointF iconsOffset = PointF.Companion.getInstance(dataSet.getIconsOffset());
                    iconsOffset.setX(NumberUtilsKt.convertDpToPixel(iconsOffset.getX()));
                    iconsOffset.setY(NumberUtilsKt.convertDpToPixel(iconsOffset.getY()));
                    int j = 0;
                    while (j < positions.length && this.getViewPortHandler().isInBoundsRight(positions[j])) {
                        if (!this.getViewPortHandler().isInBoundsLeft(positions[j]) || !this.getViewPortHandler().isInBoundsY(positions[j + 1])) {
                            j += 2;
                            continue;
                        }
                        if (dataSet.getEntryForIndex(j / 2 + this.getXBounds().getMin()) != null) {
                            Object entry;
                            boolean bl2 = false;
                            if (dataSet.isDrawValues()) {
                                this.drawValue(canvas, dataSet.getValueFormatter(), ((BaseEntry)entry).getY(), (Entry)entry, i, positions[j], positions[j + 1] - shapeSize, dataSet.getValueTextColor(j / 2 + this.getXBounds().getMin()));
                            }
                            if (((BaseEntry)entry).getIcon() != null && dataSet.isDrawIcons()) {
                                Drawable icon = ((BaseEntry)entry).getIcon();
                                if (icon != null) {
                                    Drawable it;
                                    boolean bl3 = false;
                                    CanvasUtilsKt.drawImage(canvas, it, (int)(positions[j] + iconsOffset.getX()), (int)(positions[j + 1] + iconsOffset.getY()));
                                }
                            }
                        }
                        j += 2;
                    }
                    PointF.Companion.recycleInstance(iconsOffset);
                }
            }
        }
    }

    @Override
    public void drawExtras(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
    }

    @Override
    public void drawHighlighted(@NotNull Canvas canvas, @NotNull Highlight[] indices) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        ScatterData scatterData = this.dataProvider.getScatterData();
        for (Highlight high : indices) {
            Object entry;
            IScatterDataSet set;
            ScatterData scatterData2 = scatterData;
            IScatterDataSet iScatterDataSet = set = scatterData2 != null ? (IScatterDataSet)scatterData2.getDataSetByIndex(high.getDataSetIndex()) : null;
            if (set == null || !set.isHighlight()) continue;
            if (set.getEntryForXValue(high.getX(), high.getY()) == null) continue;
            boolean bl = false;
            if (!this.isInBoundsX(entry, set)) continue;
            Transformer transformer = this.dataProvider.getTransformer(set.getAxisDependency());
            Intrinsics.checkNotNull((Object)transformer);
            PointD pix = transformer.getPixelForValues(((Entry)entry).getX(), ((BaseEntry)entry).getY() * this.getAnimator().getPhaseY());
            high.setDraw((float)pix.getX(), (float)pix.getY());
            this.drawHighlightLines(canvas, (float)pix.getX(), (float)pix.getY(), set);
        }
    }
}

