/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.renderer;

import android.graphics.Canvas;
import info.appdev.charting.animation.ChartAnimator;
import info.appdev.charting.charts.Chart;
import info.appdev.charting.charts.CombinedChart;
import info.appdev.charting.data.ChartData;
import info.appdev.charting.data.CombinedData;
import info.appdev.charting.highlight.Highlight;
import info.appdev.charting.renderer.BarChartRenderer;
import info.appdev.charting.renderer.BubbleChartRenderer;
import info.appdev.charting.renderer.CandleStickChartRenderer;
import info.appdev.charting.renderer.DataRenderer;
import info.appdev.charting.renderer.LineChartRenderer;
import info.appdev.charting.renderer.ScatterChartRenderer;
import info.appdev.charting.utils.ViewPortHandler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0016J#\u0010#\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00110%H\u0016\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u0004\u0018\u00010\u00012\u0006\u0010(\u001a\u00020)R \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\r\"\u0004\b\u0013\u0010\u000fR$\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006*"}, d2={"Linfo/appdev/charting/renderer/CombinedChartRenderer;", "Linfo/appdev/charting/renderer/DataRenderer;", "chart", "Linfo/appdev/charting/charts/CombinedChart;", "animator", "Linfo/appdev/charting/animation/ChartAnimator;", "viewPortHandler", "Linfo/appdev/charting/utils/ViewPortHandler;", "<init>", "(Linfo/appdev/charting/charts/CombinedChart;Linfo/appdev/charting/animation/ChartAnimator;Linfo/appdev/charting/utils/ViewPortHandler;)V", "dataRenderers", "", "getDataRenderers", "()Ljava/util/List;", "setDataRenderers", "(Ljava/util/List;)V", "highlightBuffer", "Linfo/appdev/charting/highlight/Highlight;", "getHighlightBuffer", "setHighlightBuffer", "weakChart", "Ljava/lang/ref/WeakReference;", "Linfo/appdev/charting/charts/Chart;", "getWeakChart", "()Ljava/lang/ref/WeakReference;", "setWeakChart", "(Ljava/lang/ref/WeakReference;)V", "createRenderers", "", "initBuffers", "drawData", "canvas", "Landroid/graphics/Canvas;", "drawValues", "drawExtras", "drawHighlighted", "indices", "", "(Landroid/graphics/Canvas;[Linfo/appdev/charting/highlight/Highlight;)V", "getSubRenderer", "index", "", "chartLib_release"})
@SourceDebugExtension(value={"SMAP\nCombinedChartRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CombinedChartRenderer.kt\ninfo/appdev/charting/renderer/CombinedChartRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,122:1\n1915#2,2:123\n1915#2,2:125\n1915#2,2:127\n1915#2,2:129\n1915#2:131\n1916#2:134\n37#3,2:132\n*S KotlinDebug\n*F\n+ 1 CombinedChartRenderer.kt\ninfo/appdev/charting/renderer/CombinedChartRenderer\n*L\n57#1:123,2\n63#1:125,2\n69#1:127,2\n75#1:129,2\n83#1:131\n83#1:134\n106#1:132,2\n*E\n"})
public class CombinedChartRenderer
extends DataRenderer {
    @NotNull
    private List<DataRenderer> dataRenderers;
    @NotNull
    private List<Highlight> highlightBuffer;
    @NotNull
    private WeakReference<Chart<?>> weakChart;

    public CombinedChartRenderer(@NotNull CombinedChart chart, @NotNull ChartAnimator animator, @NotNull ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        super(animator, viewPortHandler);
        this.dataRenderers = new ArrayList();
        this.highlightBuffer = new ArrayList();
        this.weakChart = new WeakReference<CombinedChart>(chart);
        this.createRenderers();
    }

    @NotNull
    protected final List<DataRenderer> getDataRenderers() {
        return this.dataRenderers;
    }

    protected final void setDataRenderers(@NotNull List<DataRenderer> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.dataRenderers = list;
    }

    @NotNull
    protected final List<Highlight> getHighlightBuffer() {
        return this.highlightBuffer;
    }

    protected final void setHighlightBuffer(@NotNull List<Highlight> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.highlightBuffer = list;
    }

    @NotNull
    protected final WeakReference<Chart<?>> getWeakChart() {
        return this.weakChart;
    }

    protected final void setWeakChart(@NotNull WeakReference<Chart<?>> weakReference) {
        Intrinsics.checkNotNullParameter(weakReference, (String)"<set-?>");
        this.weakChart = weakReference;
    }

    public final void createRenderers() {
        block9: {
            this.dataRenderers.clear();
            CombinedChart combinedChart = (CombinedChart)this.weakChart.get();
            if (combinedChart == null) {
                return;
            }
            CombinedChart combinedChart2 = combinedChart;
            List<CombinedChart.DrawOrder> list = combinedChart2.getDrawOrder();
            if (list == null) break block9;
            List<CombinedChart.DrawOrder> it = list;
            boolean bl = false;
            for (CombinedChart.DrawOrder order : it) {
                switch (WhenMappings.$EnumSwitchMapping$0[order.ordinal()]) {
                    case 1: {
                        boolean bl2 = this.dataRenderers.add(new BarChartRenderer(combinedChart2.getBarDataProvider(), this.getAnimator(), this.getViewPortHandler()));
                        break;
                    }
                    case 2: {
                        boolean bl2 = this.dataRenderers.add(new BubbleChartRenderer(combinedChart2.getBubbleDataProvider(), this.getAnimator(), this.getViewPortHandler()));
                        break;
                    }
                    case 3: {
                        boolean bl2 = this.dataRenderers.add(new LineChartRenderer(combinedChart2.getLineDataProvider(), this.getAnimator(), this.getViewPortHandler()));
                        break;
                    }
                    case 4: {
                        boolean bl2 = this.dataRenderers.add(new CandleStickChartRenderer(combinedChart2.getCandleDataProvider(), this.getAnimator(), this.getViewPortHandler()));
                        break;
                    }
                    case 5: {
                        boolean bl2 = this.dataRenderers.add(new ScatterChartRenderer(combinedChart2.getScatterDataProvider(), this.getAnimator(), this.getViewPortHandler()));
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
        }
    }

    @Override
    public void initBuffers() {
        Iterable $this$forEach$iv = this.dataRenderers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DataRenderer it = (DataRenderer)element$iv;
            boolean bl = false;
            it.initBuffers();
        }
    }

    @Override
    public void drawData(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Iterable $this$forEach$iv = this.dataRenderers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DataRenderer it = (DataRenderer)element$iv;
            boolean bl = false;
            it.drawData(canvas);
        }
    }

    @Override
    public void drawValues(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Iterable $this$forEach$iv = this.dataRenderers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DataRenderer it = (DataRenderer)element$iv;
            boolean bl = false;
            it.drawValues(canvas);
        }
    }

    @Override
    public void drawExtras(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Iterable $this$forEach$iv = this.dataRenderers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DataRenderer it = (DataRenderer)element$iv;
            boolean bl = false;
            it.drawExtras(canvas);
        }
    }

    @Override
    public void drawHighlighted(@NotNull Canvas canvas, @NotNull Highlight[] indices) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        Chart chart = (Chart)this.weakChart.get();
        if (chart == null) {
            return;
        }
        Chart chart2 = chart;
        Iterable $this$forEach$iv = this.dataRenderers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int n;
            DataRenderer renderer = (DataRenderer)element$iv;
            boolean bl = false;
            ChartData data = null;
            DataRenderer dataRenderer = renderer;
            if (dataRenderer instanceof BarChartRenderer) {
                data = ((BarChartRenderer)renderer).getDataProvider().getBarData();
            } else if (dataRenderer instanceof LineChartRenderer) {
                data = ((LineChartRenderer)renderer).getDataProvider().getLineData();
            } else if (dataRenderer instanceof CandleStickChartRenderer) {
                data = ((CandleStickChartRenderer)renderer).getDataProvider().getCandleData();
            } else if (dataRenderer instanceof ScatterChartRenderer) {
                data = ((ScatterChartRenderer)renderer).getDataProvider().getScatterData();
            } else if (dataRenderer instanceof BubbleChartRenderer) {
                data = ((BubbleChartRenderer)renderer).getDataProvider().getBubbleData();
            }
            if (data == null) {
                n = -1;
            } else {
                Object t = chart2.getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type info.appdev.charting.data.CombinedData");
                n = CollectionsKt.indexOf(((CombinedData)t).getAllData(), (Object)data);
            }
            int dataIndex = n;
            this.highlightBuffer.clear();
            for (Highlight h : indices) {
                if (h.getDataIndex() != dataIndex && h.getDataIndex() != -1) continue;
                this.highlightBuffer.add(h);
            }
            Collection $this$toTypedArray$iv = this.highlightBuffer;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            renderer.drawHighlighted(canvas, thisCollection$iv.toArray(new Highlight[0]));
        }
    }

    @Nullable
    public final DataRenderer getSubRenderer(int index) {
        return index >= this.dataRenderers.size() || index < 0 ? null : this.dataRenderers.get(index);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CombinedChart.DrawOrder.values().length];
            try {
                nArray[CombinedChart.DrawOrder.BAR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CombinedChart.DrawOrder.BUBBLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CombinedChart.DrawOrder.LINE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CombinedChart.DrawOrder.CANDLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CombinedChart.DrawOrder.SCATTER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

