/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.listener;

import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import info.appdev.charting.charts.Chart;
import info.appdev.charting.highlight.Highlight;
import info.appdev.charting.listener.OnChartGestureListener;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 /*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u00032\u00020\u0004:\u0002./B\u000f\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\u0010\u0010*\u001a\u00020&2\b\u0010+\u001a\u0004\u0018\u00010\u001aJ\u0012\u0010,\u001a\u00020&2\b\u0010-\u001a\u0004\u0018\u00010\u001aH\u0004R\u001c\u0010\u0005\u001a\u00028\u0000X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u0007R$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u0013@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u00060"}, d2={"Linfo/appdev/charting/listener/ChartTouchListener;", "T", "Linfo/appdev/charting/charts/Chart;", "Landroid/view/GestureDetector$SimpleOnGestureListener;", "Landroid/view/View$OnTouchListener;", "chart", "<init>", "(Linfo/appdev/charting/charts/Chart;)V", "getChart", "()Linfo/appdev/charting/charts/Chart;", "setChart", "Linfo/appdev/charting/charts/Chart;", "value", "Linfo/appdev/charting/listener/ChartTouchListener$ChartGesture;", "lastGesture", "getLastGesture", "()Linfo/appdev/charting/listener/ChartTouchListener$ChartGesture;", "setLastGesture", "(Linfo/appdev/charting/listener/ChartTouchListener$ChartGesture;)V", "", "touchMode", "getTouchMode", "()I", "setTouchMode", "(I)V", "mLastHighlighted", "Linfo/appdev/charting/highlight/Highlight;", "getMLastHighlighted", "()Linfo/appdev/charting/highlight/Highlight;", "setMLastHighlighted", "(Linfo/appdev/charting/highlight/Highlight;)V", "gestureDetector", "Landroid/view/GestureDetector;", "getGestureDetector", "()Landroid/view/GestureDetector;", "setGestureDetector", "(Landroid/view/GestureDetector;)V", "startAction", "", "me", "Landroid/view/MotionEvent;", "endAction", "setLastHighlighted", "high", "performHighlight", "highlight", "ChartGesture", "Companion", "chartLib_release"})
public abstract class ChartTouchListener<T extends Chart<?>>
extends GestureDetector.SimpleOnGestureListener
implements View.OnTouchListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private T chart;
    @NotNull
    private ChartGesture lastGesture;
    private int touchMode;
    @Nullable
    private Highlight mLastHighlighted;
    @Nullable
    private GestureDetector gestureDetector;
    protected static final int NONE = 0;
    protected static final int DRAG = 1;
    protected static final int X_ZOOM = 2;
    protected static final int Y_ZOOM = 3;
    protected static final int PINCH_ZOOM = 4;
    protected static final int POST_ZOOM = 5;
    protected static final int ROTATE = 6;

    public ChartTouchListener(@NotNull T chart) {
        Intrinsics.checkNotNullParameter(chart, (String)"chart");
        this.chart = chart;
        this.lastGesture = ChartGesture.NONE;
        this.gestureDetector = new GestureDetector(((View)this.chart).getContext(), (GestureDetector.OnGestureListener)this);
    }

    @NotNull
    protected final T getChart() {
        return this.chart;
    }

    protected final void setChart(@NotNull T t) {
        Intrinsics.checkNotNullParameter(t, (String)"<set-?>");
        this.chart = t;
    }

    @NotNull
    public final ChartGesture getLastGesture() {
        return this.lastGesture;
    }

    protected final void setLastGesture(@NotNull ChartGesture chartGesture) {
        Intrinsics.checkNotNullParameter((Object)((Object)chartGesture), (String)"<set-?>");
        this.lastGesture = chartGesture;
    }

    public final int getTouchMode() {
        return this.touchMode;
    }

    protected final void setTouchMode(int n) {
        this.touchMode = n;
    }

    @Nullable
    protected final Highlight getMLastHighlighted() {
        return this.mLastHighlighted;
    }

    protected final void setMLastHighlighted(@Nullable Highlight highlight) {
        this.mLastHighlighted = highlight;
    }

    @Nullable
    protected final GestureDetector getGestureDetector() {
        return this.gestureDetector;
    }

    protected final void setGestureDetector(@Nullable GestureDetector gestureDetector) {
        this.gestureDetector = gestureDetector;
    }

    public final void startAction(@NotNull MotionEvent me) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)me, (String)"me");
            OnChartGestureListener onChartGestureListener = ((Chart)this.chart).getOnChartGestureListener();
            if (onChartGestureListener == null) break block0;
            onChartGestureListener.onChartGestureStart(me, this.lastGesture);
        }
    }

    public final void endAction(@NotNull MotionEvent me) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)me, (String)"me");
            OnChartGestureListener onChartGestureListener = ((Chart)this.chart).getOnChartGestureListener();
            if (onChartGestureListener == null) break block0;
            onChartGestureListener.onChartGestureEnd(me, this.lastGesture);
        }
    }

    public final void setLastHighlighted(@Nullable Highlight high) {
        this.mLastHighlighted = high;
    }

    protected final void performHighlight(@Nullable Highlight highlight) {
        if (highlight == null || highlight.equalTo(this.mLastHighlighted)) {
            ((Chart)this.chart).highlightValue(null, true);
            this.mLastHighlighted = null;
        } else {
            ((Chart)this.chart).highlightValue(highlight, true);
            this.mLastHighlighted = highlight;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\r\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Linfo/appdev/charting/listener/ChartTouchListener$ChartGesture;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "DRAG", "X_ZOOM", "Y_ZOOM", "PINCH_ZOOM", "ROTATE", "SINGLE_TAP", "DOUBLE_TAP", "LONG_PRESS", "FLING", "chartLib_release"})
    public static final class ChartGesture
    extends Enum<ChartGesture> {
        public static final /* enum */ ChartGesture NONE = new ChartGesture();
        public static final /* enum */ ChartGesture DRAG = new ChartGesture();
        public static final /* enum */ ChartGesture X_ZOOM = new ChartGesture();
        public static final /* enum */ ChartGesture Y_ZOOM = new ChartGesture();
        public static final /* enum */ ChartGesture PINCH_ZOOM = new ChartGesture();
        public static final /* enum */ ChartGesture ROTATE = new ChartGesture();
        public static final /* enum */ ChartGesture SINGLE_TAP = new ChartGesture();
        public static final /* enum */ ChartGesture DOUBLE_TAP = new ChartGesture();
        public static final /* enum */ ChartGesture LONG_PRESS = new ChartGesture();
        public static final /* enum */ ChartGesture FLING = new ChartGesture();
        private static final /* synthetic */ ChartGesture[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ChartGesture[] values() {
            return (ChartGesture[])$VALUES.clone();
        }

        public static ChartGesture valueOf(String value) {
            return Enum.valueOf(ChartGesture.class, value);
        }

        @NotNull
        public static EnumEntries<ChartGesture> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = chartGestureArray = new ChartGesture[]{ChartGesture.NONE, ChartGesture.DRAG, ChartGesture.X_ZOOM, ChartGesture.Y_ZOOM, ChartGesture.PINCH_ZOOM, ChartGesture.ROTATE, ChartGesture.SINGLE_TAP, ChartGesture.DOUBLE_TAP, ChartGesture.LONG_PRESS, ChartGesture.FLING};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0004R\u000e\u0010\u0004\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Linfo/appdev/charting/listener/ChartTouchListener$Companion;", "", "<init>", "()V", "NONE", "", "DRAG", "X_ZOOM", "Y_ZOOM", "PINCH_ZOOM", "POST_ZOOM", "ROTATE", "distance", "", "eventX", "startX", "eventY", "startY", "chartLib_release"})
    public static final class Companion {
        private Companion() {
        }

        protected final float distance(float eventX, float startX, float eventY, float startY) {
            float dx = eventX - startX;
            float dy = eventY - startY;
            return (float)Math.sqrt(dx * dx + dy * dy);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

