/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.highlight;

import info.appdev.charting.data.BarData;
import info.appdev.charting.data.DataSet;
import info.appdev.charting.data.Entry;
import info.appdev.charting.highlight.BarHighlighter;
import info.appdev.charting.highlight.Highlight;
import info.appdev.charting.interfaces.dataprovider.BarDataProvider;
import info.appdev.charting.interfaces.datasets.IBarDataSet;
import info.appdev.charting.interfaces.datasets.IDataSet;
import info.appdev.charting.utils.PointD;
import info.appdev.charting.utils.Transformer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J4\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J(\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0014\u00a8\u0006\u0019"}, d2={"Linfo/appdev/charting/highlight/HorizontalBarHighlighter;", "Linfo/appdev/charting/highlight/BarHighlighter;", "dataProvider", "Linfo/appdev/charting/interfaces/dataprovider/BarDataProvider;", "<init>", "(Linfo/appdev/charting/interfaces/dataprovider/BarDataProvider;)V", "getHighlight", "Linfo/appdev/charting/highlight/Highlight;", "x", "", "y", "buildHighlights", "", "set", "Linfo/appdev/charting/interfaces/datasets/IDataSet;", "dataSetIndex", "", "xVal", "rounding", "Linfo/appdev/charting/data/DataSet$Rounding;", "getDistance", "x1", "y1", "x2", "y2", "chartLib_release"})
public final class HorizontalBarHighlighter
extends BarHighlighter {
    public HorizontalBarHighlighter(@NotNull BarDataProvider dataProvider) {
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        super(dataProvider);
    }

    @Override
    @Nullable
    public Highlight getHighlight(float x, float y) {
        BarData barData = ((BarDataProvider)this.getProvider()).getBarData();
        if (barData != null) {
            BarData barData2 = barData;
            boolean bl = false;
            PointD pos = this.getValsForTouch(y, x);
            Highlight highlight = this.getHighlightForX((float)pos.getY(), y, x);
            if (highlight == null) {
                return null;
            }
            Highlight high = highlight;
            IBarDataSet set = (IBarDataSet)barData2.getDataSetByIndex(high.getDataSetIndex());
            if (set != null && set.isStacked()) {
                return this.getStackedHighlight(high, set, (float)pos.getY(), (float)pos.getX());
            }
            PointD.Companion.recycleInstance(pos);
            return high;
        }
        return null;
    }

    @Override
    @NotNull
    protected List<Highlight> buildHighlights(@NotNull IDataSet<?> set, int dataSetIndex, float xVal, @Nullable DataSet.Rounding rounding) {
        Intrinsics.checkNotNullParameter(set, (String)"set");
        ArrayList<Highlight> highlights = new ArrayList<Highlight>();
        List<?> entries = null;
        entries = set.getEntriesForXValue(xVal);
        if (entries != null && entries.isEmpty()) {
            Object closestEntry;
            Object obj = closestEntry = set.getEntryForXValue(xVal, Float.NaN, rounding);
            if (obj != null) {
                Object closestE = obj;
                boolean bl = false;
                entries = set.getEntriesForXValue(((Entry)closestE).getX());
            }
        }
        if (entries != null && entries.isEmpty()) {
            return highlights;
        }
        if (entries != null) {
            for (Entry entry : entries) {
                Transformer transformer = ((BarDataProvider)this.getProvider()).getTransformer(set.getAxisDependency());
                Intrinsics.checkNotNull((Object)transformer);
                PointD pixels = transformer.getPixelForValues(entry.getY(), entry.getX());
                highlights.add(new Highlight(entry.getX(), entry.getY(), (float)pixels.getX(), (float)pixels.getY(), dataSetIndex, set.getAxisDependency()));
            }
        }
        return highlights;
    }

    @Override
    protected float getDistance(float x1, float y1, float x2, float y2) {
        return Math.abs(y1 - y2);
    }
}

