/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.components;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import info.appdev.charting.charts.Chart;
import info.appdev.charting.components.IMarker;
import info.appdev.charting.data.Entry;
import info.appdev.charting.highlight.Highlight;
import info.appdev.charting.utils.FSize;
import info.appdev.charting.utils.PointF;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017J\u0018\u0010(\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u0017H\u0016J\u0018\u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J \u00100\u001a\u00020\u00152\u0006\u00101\u001a\u0002022\u0006\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0010\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u0014\u0010\u001cR(\u0010\u001d\u001a\u0004\u0018\u00010\u00112\b\u0010\u001d\u001a\u0004\u0018\u00010\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R0\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\f\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u00063"}, d2={"Linfo/appdev/charting/components/MarkerImage;", "Linfo/appdev/charting/components/IMarker;", "mContext", "Landroid/content/Context;", "drawableResourceId", "", "<init>", "(Landroid/content/Context;I)V", "drawable", "Landroid/graphics/drawable/Drawable;", "mOffset", "Linfo/appdev/charting/utils/PointF;", "mOffset2", "mWeakChart", "Ljava/lang/ref/WeakReference;", "Linfo/appdev/charting/charts/Chart;", "mSize", "Linfo/appdev/charting/utils/FSize;", "mDrawableBoundsCache", "Landroid/graphics/Rect;", "setOffset", "", "offsetX", "", "offsetY", "offset", "getOffset", "()Linfo/appdev/charting/utils/PointF;", "(Linfo/appdev/charting/utils/PointF;)V", "size", "getSize", "()Linfo/appdev/charting/utils/FSize;", "setSize", "(Linfo/appdev/charting/utils/FSize;)V", "chart", "chartView", "getChartView", "()Linfo/appdev/charting/charts/Chart;", "setChartView", "(Linfo/appdev/charting/charts/Chart;)V", "getOffsetForDrawingAtPoint", "posX", "posY", "refreshContent", "entry", "Linfo/appdev/charting/data/Entry;", "highlight", "Linfo/appdev/charting/highlight/Highlight;", "draw", "canvas", "Landroid/graphics/Canvas;", "chartLib_release"})
@SourceDebugExtension(value={"SMAP\nMarkerImage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkerImage.kt\ninfo/appdev/charting/components/MarkerImage\n+ 2 Canvas.kt\nandroidx/core/graphics/CanvasKt\n*L\n1#1,131:1\n44#2,8:132\n*S KotlinDebug\n*F\n+ 1 MarkerImage.kt\ninfo/appdev/charting/components/MarkerImage\n*L\n123#1:132,8\n*E\n"})
public final class MarkerImage
implements IMarker {
    @NotNull
    private Context mContext;
    @Nullable
    private Drawable drawable;
    @NotNull
    private PointF mOffset;
    @NotNull
    private final PointF mOffset2;
    @Nullable
    private WeakReference<Chart<?>> mWeakChart;
    @Nullable
    private FSize mSize;
    @NotNull
    private final Rect mDrawableBoundsCache;

    public MarkerImage(@NotNull Context mContext, int drawableResourceId) {
        Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
        this.mContext = mContext;
        this.mOffset = new PointF();
        this.mOffset2 = new PointF();
        this.mSize = new FSize();
        this.mDrawableBoundsCache = new Rect();
        this.drawable = this.mContext.getResources().getDrawable(drawableResourceId, null);
    }

    public final void setOffset(float offsetX, float offsetY) {
        this.mOffset.setX(offsetX);
        this.mOffset.setY(offsetY);
    }

    @Override
    @NotNull
    public PointF getOffset() {
        return this.mOffset;
    }

    public void setOffset(@NotNull PointF offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        this.mOffset = offset;
    }

    @Nullable
    public final FSize getSize() {
        return this.mSize;
    }

    public final void setSize(@Nullable FSize size) {
        this.mSize = size;
        if (this.mSize == null) {
            this.mSize = new FSize();
        }
    }

    @Nullable
    public final Chart<?> getChartView() {
        Chart chart;
        if (this.mWeakChart == null) {
            chart = null;
        } else {
            WeakReference<Chart<?>> weakReference = this.mWeakChart;
            Intrinsics.checkNotNull(weakReference);
            chart = (Chart)weakReference.get();
        }
        return chart;
    }

    public final void setChartView(@Nullable Chart<?> chart) {
        this.mWeakChart = new WeakReference(chart);
    }

    @Override
    @NotNull
    public PointF getOffsetForDrawingAtPoint(float posX, float posY) {
        PointF offset = this.getOffset();
        this.mOffset2.setX(offset.getX());
        this.mOffset2.setY(offset.getY());
        Chart<?> chart = this.getChartView();
        FSize fSize = this.mSize;
        Intrinsics.checkNotNull((Object)fSize);
        float width = fSize.getWidth();
        FSize fSize2 = this.mSize;
        Intrinsics.checkNotNull((Object)fSize2);
        float height = fSize2.getHeight();
        if (width == 0.0f && this.drawable != null) {
            Drawable drawable = this.drawable;
            Intrinsics.checkNotNull((Object)drawable);
            width = drawable.getIntrinsicWidth();
        }
        if (height == 0.0f && this.drawable != null) {
            Drawable drawable = this.drawable;
            Intrinsics.checkNotNull((Object)drawable);
            height = drawable.getIntrinsicHeight();
        }
        if (posX + this.mOffset2.getX() < 0.0f) {
            this.mOffset2.setX(-posX);
        } else if (chart != null && posX + width + this.mOffset2.getX() > (float)chart.getWidth()) {
            this.mOffset2.setX((float)chart.getWidth() - posX - width);
        }
        if (posY + this.mOffset2.getY() < 0.0f) {
            this.mOffset2.setY(-posY);
        } else if (chart != null && posY + height + this.mOffset2.getY() > (float)chart.getHeight()) {
            this.mOffset2.setY((float)chart.getHeight() - posY - height);
        }
        return this.mOffset2;
    }

    @Override
    public void refreshContent(@NotNull Entry entry, @NotNull Highlight highlight) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)highlight, (String)"highlight");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void draw(@NotNull Canvas canvas, float posX, float posY) {
        void x$iv;
        void $this$withTranslation$iv;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (this.drawable == null) {
            return;
        }
        PointF offset = this.getOffsetForDrawingAtPoint(posX, posY);
        FSize fSize = this.mSize;
        Intrinsics.checkNotNull((Object)fSize);
        float width = fSize.getWidth();
        FSize fSize2 = this.mSize;
        Intrinsics.checkNotNull((Object)fSize2);
        float height = fSize2.getHeight();
        if (width == 0.0f) {
            Drawable drawable = this.drawable;
            Intrinsics.checkNotNull((Object)drawable);
            width = drawable.getIntrinsicWidth();
        }
        if (height == 0.0f) {
            Drawable drawable = this.drawable;
            Intrinsics.checkNotNull((Object)drawable);
            height = drawable.getIntrinsicHeight();
        }
        Drawable drawable = this.drawable;
        Intrinsics.checkNotNull((Object)drawable);
        drawable.copyBounds(this.mDrawableBoundsCache);
        Drawable drawable2 = this.drawable;
        Intrinsics.checkNotNull((Object)drawable2);
        drawable2.setBounds(this.mDrawableBoundsCache.left, this.mDrawableBoundsCache.top, this.mDrawableBoundsCache.left + (int)width, this.mDrawableBoundsCache.top + (int)height);
        Canvas canvas2 = canvas;
        float f = posX + offset.getX();
        float y$iv = posY + offset.getY();
        boolean $i$f$withTranslation = false;
        int checkpoint$iv = $this$withTranslation$iv.save();
        $this$withTranslation$iv.translate((float)x$iv, y$iv);
        try {
            void $this$draw_u24lambda_u240 = $this$withTranslation$iv;
            boolean bl = false;
            Drawable drawable3 = this.drawable;
            Intrinsics.checkNotNull((Object)drawable3);
            drawable3.draw(canvas);
        }
        finally {
            $this$withTranslation$iv.restoreToCount(checkpoint$iv);
        }
        Drawable drawable4 = this.drawable;
        Intrinsics.checkNotNull((Object)drawable4);
        drawable4.setBounds(this.mDrawableBoundsCache);
    }
}

