/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.utils;

import android.util.DisplayMetrics;
import info.appdev.charting.utils.ContextUtilsKt;
import info.appdev.charting.utils.Utils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0002*\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0002*\u00020\u0002\u001a$\u0010\u0006\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a\n\u0010\r\u001a\u00020\u0002*\u00020\u0002\u00a8\u0006\u000e"}, d2={"getDecimals", "", "", "roundToNextSignificant", "", "convertDpToPixel", "formatNumber", "", "digitCount", "separateThousands", "", "separateChar", "", "getNormalizedAngle", "chartLib_release"})
public final class NumberUtilsKt {
    public static final int getDecimals(float $this$getDecimals) {
        float i = NumberUtilsKt.roundToNextSignificant($this$getDecimals);
        if (Float.isInfinite(i)) {
            return 0;
        }
        return (int)Math.ceil(-Math.log10(i)) + 2;
    }

    public static final float roundToNextSignificant(double $this$roundToNextSignificant) {
        if (Double.isInfinite($this$roundToNextSignificant) || Double.isNaN($this$roundToNextSignificant) || $this$roundToNextSignificant == 0.0) {
            return 0.0f;
        }
        float d = (float)Math.ceil((float)Math.log10($this$roundToNextSignificant < 0.0 ? -$this$roundToNextSignificant : $this$roundToNextSignificant));
        int pw = 1 - (int)d;
        float magnitude = (float)Math.pow(10.0, pw);
        int shifted = MathKt.roundToInt((double)($this$roundToNextSignificant * (double)magnitude));
        return (float)shifted / magnitude;
    }

    public static final float convertDpToPixel(float $this$convertDpToPixel) {
        if (ContextUtilsKt.getMetrics() == null) {
            Timber.Forest.e("Utils NOT INITIALIZED. You need to call Utils.init(...) at least once before calling Utils.convertDpToPixel(...). Otherwise conversion does not take place.", new Object[0]);
            return $this$convertDpToPixel;
        }
        DisplayMetrics displayMetrics = ContextUtilsKt.getMetrics();
        Intrinsics.checkNotNull((Object)displayMetrics);
        return $this$convertDpToPixel * displayMetrics.density;
    }

    @NotNull
    public static final String formatNumber(float $this$formatNumber, int digitCount, boolean separateThousands, char separateChar) {
        boolean zero;
        float number = $this$formatNumber;
        int digitCount2 = digitCount;
        char[] out = new char[35];
        boolean neg = false;
        if (number == 0.0f) {
            return "0";
        }
        boolean bl = zero = number < 1.0f && number > -1.0f;
        if (number < 0.0f) {
            neg = true;
            number = -number;
        }
        if (digitCount2 > Utils.INSTANCE.getPOW_10().length) {
            digitCount2 = Utils.INSTANCE.getPOW_10().length - 1;
        }
        int ind = out.length - 1;
        int charCount = 0;
        boolean decimalPointAdded = false;
        for (long lVal = (long)Math.round(number *= (float)Utils.INSTANCE.getPOW_10()[digitCount2]); lVal != 0L || charCount < digitCount2 + 1; lVal /= (long)10) {
            int digit = (int)(lVal % (long)10);
            out[ind--] = (char)(digit + 48);
            if (++charCount != digitCount2) continue;
            out[ind--] = 44;
            ++charCount;
            decimalPointAdded = true;
        }
        if (zero) {
            out[ind--] = 48;
            ++charCount;
        }
        if (neg) {
            out[ind--] = 45;
            ++charCount;
        }
        int start = out.length - charCount;
        return new String(out, start, out.length - start);
    }

    public static /* synthetic */ String formatNumber$default(float f, int n, boolean bl, char c, int n2, Object object) {
        if ((n2 & 4) != 0) {
            c = (char)46;
        }
        return NumberUtilsKt.formatNumber(f, n, bl, c);
    }

    public static final float getNormalizedAngle(float $this$getNormalizedAngle) {
        float angle;
        for (angle = $this$getNormalizedAngle; angle < 0.0f; angle += 360.0f) {
        }
        return angle % 360.0f;
    }
}

