/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import info.appdev.charting.animation.ChartAnimator;
import info.appdev.charting.data.ChartData;
import info.appdev.charting.data.Entry;
import info.appdev.charting.formatter.IValueFormatter;
import info.appdev.charting.highlight.Highlight;
import info.appdev.charting.interfaces.dataprovider.base.IBaseProvider;
import info.appdev.charting.interfaces.datasets.IDataSet;
import info.appdev.charting.renderer.Renderer;
import info.appdev.charting.utils.NumberUtilsKt;
import info.appdev.charting.utils.ViewPortHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0014J\u0014\u0010 \u001a\u00020!2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#H\u0004J\b\u0010$\u001a\u00020!H&J\u0010\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020'H&J\u0010\u0010(\u001a\u00020!2\u0006\u0010&\u001a\u00020'H&JH\u0010)\u001a\u00020!2\u0006\u0010&\u001a\u00020'2\u0006\u0010*\u001a\u00020+2\u0006\u0010\f\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020,2\u0006\u00102\u001a\u00020,2\u0006\u00103\u001a\u000200J\u0010\u00104\u001a\u00020!2\u0006\u0010&\u001a\u00020'H&J#\u00105\u001a\u00020!2\u0006\u0010&\u001a\u00020'2\f\u00106\u001a\b\u0012\u0004\u0012\u00020807H&\u00a2\u0006\u0002\u00109R\u001a\u0010\u0002\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0013\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001a\u0010\u0016\u001a\u00020\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012R$\u0010\u0019\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0010\"\u0004\b\u001b\u0010\u0012\u00a8\u0006:"}, d2={"Linfo/appdev/charting/renderer/DataRenderer;", "Linfo/appdev/charting/renderer/Renderer;", "animator", "Linfo/appdev/charting/animation/ChartAnimator;", "viewPortHandler", "Linfo/appdev/charting/utils/ViewPortHandler;", "<init>", "(Linfo/appdev/charting/animation/ChartAnimator;Linfo/appdev/charting/utils/ViewPortHandler;)V", "getAnimator", "()Linfo/appdev/charting/animation/ChartAnimator;", "setAnimator", "(Linfo/appdev/charting/animation/ChartAnimator;)V", "value", "Landroid/graphics/Paint;", "paintRender", "getPaintRender", "()Landroid/graphics/Paint;", "setPaintRender", "(Landroid/graphics/Paint;)V", "paintHighlight", "getPaintHighlight", "setPaintHighlight", "drawPaint", "getDrawPaint", "setDrawPaint", "paintValues", "getPaintValues", "setPaintValues", "isDrawingValuesAllowed", "", "baseProvider", "Linfo/appdev/charting/interfaces/dataprovider/base/IBaseProvider;", "applyValueTextStyle", "", "set", "Linfo/appdev/charting/interfaces/datasets/IDataSet;", "initBuffers", "drawData", "canvas", "Landroid/graphics/Canvas;", "drawValues", "drawValue", "formatter", "Linfo/appdev/charting/formatter/IValueFormatter;", "", "entry", "Linfo/appdev/charting/data/Entry;", "dataSetIndex", "", "x", "y", "color", "drawExtras", "drawHighlighted", "indices", "", "Linfo/appdev/charting/highlight/Highlight;", "(Landroid/graphics/Canvas;[Linfo/appdev/charting/highlight/Highlight;)V", "chartLib_release"})
public abstract class DataRenderer
extends Renderer {
    @NotNull
    private ChartAnimator animator;
    @NotNull
    private Paint paintRender;
    @NotNull
    private Paint paintHighlight;
    @NotNull
    private Paint drawPaint;
    @NotNull
    private Paint paintValues;

    public DataRenderer(@NotNull ChartAnimator animator, @NotNull ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        super(viewPortHandler);
        this.animator = animator;
        this.paintRender = new Paint(1);
        this.paintRender.setStyle(Paint.Style.FILL);
        this.drawPaint = new Paint(4);
        this.paintValues = new Paint(1);
        this.paintValues.setColor(Color.rgb((int)63, (int)63, (int)63));
        this.paintValues.setTextAlign(Paint.Align.CENTER);
        this.paintValues.setTextSize(NumberUtilsKt.convertDpToPixel(9.0f));
        this.paintHighlight = new Paint(1);
        this.paintHighlight.setStyle(Paint.Style.STROKE);
        this.paintHighlight.setStrokeWidth(2.0f);
        this.paintHighlight.setColor(Color.rgb((int)255, (int)187, (int)115));
    }

    @NotNull
    protected final ChartAnimator getAnimator() {
        return this.animator;
    }

    protected final void setAnimator(@NotNull ChartAnimator chartAnimator) {
        Intrinsics.checkNotNullParameter((Object)chartAnimator, (String)"<set-?>");
        this.animator = chartAnimator;
    }

    @NotNull
    public final Paint getPaintRender() {
        return this.paintRender;
    }

    protected final void setPaintRender(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.paintRender = paint;
    }

    @NotNull
    public final Paint getPaintHighlight() {
        return this.paintHighlight;
    }

    protected final void setPaintHighlight(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.paintHighlight = paint;
    }

    @NotNull
    protected final Paint getDrawPaint() {
        return this.drawPaint;
    }

    protected final void setDrawPaint(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.drawPaint = paint;
    }

    @NotNull
    public final Paint getPaintValues() {
        return this.paintValues;
    }

    protected final void setPaintValues(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.paintValues = paint;
    }

    protected boolean isDrawingValuesAllowed(@NotNull IBaseProvider<?> baseProvider) {
        Intrinsics.checkNotNullParameter(baseProvider, (String)"baseProvider");
        Object obj = baseProvider.getData();
        Intrinsics.checkNotNull(obj);
        return (float)((ChartData)obj).getEntryCount() < (float)baseProvider.getMaxVisibleCount() * this.getViewPortHandler().getScaleX();
    }

    protected final void applyValueTextStyle(@NotNull IDataSet<?> set) {
        Intrinsics.checkNotNullParameter(set, (String)"set");
        this.paintValues.setTypeface(set.getValueTypeface());
        this.paintValues.setTextSize(set.getValueTextSize());
    }

    public abstract void initBuffers();

    public abstract void drawData(@NotNull Canvas var1);

    public abstract void drawValues(@NotNull Canvas var1);

    public final void drawValue(@NotNull Canvas canvas, @NotNull IValueFormatter formatter, float value, @Nullable Entry entry, int dataSetIndex, float x, float y, int color) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)formatter, (String)"formatter");
        this.paintValues.setColor(color);
        String string = formatter.getFormattedValue(value, entry, dataSetIndex, this.getViewPortHandler());
        Intrinsics.checkNotNull((Object)string);
        canvas.drawText(string, x, y, this.paintValues);
    }

    public abstract void drawExtras(@NotNull Canvas var1);

    public abstract void drawHighlighted(@NotNull Canvas var1, @NotNull Highlight[] var2);
}

