/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.charts;

import android.content.Context;
import android.graphics.RectF;
import android.util.AttributeSet;
import info.appdev.charting.charts.BarLineChartBase;
import info.appdev.charting.components.YAxis;
import info.appdev.charting.data.BarData;
import info.appdev.charting.data.BarEntry;
import info.appdev.charting.formatter.IAxisValueFormatter;
import info.appdev.charting.highlight.BarHighlighter;
import info.appdev.charting.highlight.Highlight;
import info.appdev.charting.highlight.IHighlighter;
import info.appdev.charting.interfaces.dataprovider.BarDataProvider;
import info.appdev.charting.interfaces.datasets.IBarDataSet;
import info.appdev.charting.renderer.BarChartRenderer;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0013\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001d\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0006\u0010\nB%\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\u0006\u0010\rJ\b\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u001cH\u0014J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u0019H\u0016J\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)J\u0018\u0010&\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020'H\u0016J\u000e\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020\u000fJ\u000e\u0010-\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020\u000fJ \u0010.\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u00192\u0006\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u00020\fH\u0016J\u000e\u00104\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020\u000fJ\u001e\u00105\u001a\u00020\u001c2\u0006\u00106\u001a\u00020\u00192\u0006\u00107\u001a\u00020\u00192\u0006\u00108\u001a\u00020\u0019J\u000e\u00109\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019R\u001a\u0010\u000e\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0012R\u001a\u0010\u0015\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0010\"\u0004\b\u0016\u0010\u0012R\u000e\u0010\u0017\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0016\u00101\u001a\u0004\u0018\u00010\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103\u00a8\u0006:"}, d2={"Linfo/appdev/charting/charts/BarChart;", "Linfo/appdev/charting/charts/BarLineChartBase;", "Linfo/appdev/charting/data/BarData;", "Linfo/appdev/charting/interfaces/dataprovider/BarDataProvider;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "isHighlightFullBarEnabled", "", "()Z", "setHighlightFullBarEnabled", "(Z)V", "isDrawValueAboveBarEnabled", "setDrawValueAboveBarEnabled", "isDrawBarShadowEnabled", "setDrawBarShadowEnabled", "mDrawRoundedBars", "mRoundedBarRadius", "", "mFitBars", "init", "", "calcMinMax", "getHighlightByTouchPoint", "Linfo/appdev/charting/highlight/Highlight;", "x", "y", "accessibilityDescription", "", "getAccessibilityDescription", "()Ljava/lang/String;", "getBarBounds", "Landroid/graphics/RectF;", "barEntry", "Linfo/appdev/charting/data/BarEntry;", "outputRect", "setDrawValueAboveBar", "enabled", "setDrawBarShadow", "getHighlightValue", "dataSetIndex", "dataIndex", "barData", "getBarData", "()Linfo/appdev/charting/data/BarData;", "setFitBars", "groupBars", "fromX", "groupSpace", "barSpace", "setRoundedBarRadius", "chartLib_release"})
public class BarChart
extends BarLineChartBase<BarData>
implements BarDataProvider {
    private boolean isHighlightFullBarEnabled;
    private boolean isDrawValueAboveBarEnabled = true;
    private boolean isDrawBarShadowEnabled;
    private boolean mDrawRoundedBars;
    private float mRoundedBarRadius;
    private boolean mFitBars;

    @Override
    public boolean isHighlightFullBarEnabled() {
        return this.isHighlightFullBarEnabled;
    }

    @Override
    public void setHighlightFullBarEnabled(boolean bl) {
        this.isHighlightFullBarEnabled = bl;
    }

    @Override
    public boolean isDrawValueAboveBarEnabled() {
        return this.isDrawValueAboveBarEnabled;
    }

    @Override
    public void setDrawValueAboveBarEnabled(boolean bl) {
        this.isDrawValueAboveBarEnabled = bl;
    }

    @Override
    public boolean isDrawBarShadowEnabled() {
        return this.isDrawBarShadowEnabled;
    }

    @Override
    public void setDrawBarShadowEnabled(boolean bl) {
        this.isDrawBarShadowEnabled = bl;
    }

    public BarChart(@Nullable Context context) {
        super(context);
    }

    public BarChart(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public BarChart(@Nullable Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init() {
        super.init();
        this.setDataRenderer(new BarChartRenderer(this, this.getMAnimator(), this.getViewPortHandler(), this.mDrawRoundedBars, this.mRoundedBarRadius));
        this.setHighlighter(new BarHighlighter(this));
        this.getXAxis().setSpaceMin(0.5f);
        this.getXAxis().setSpaceMax(0.5f);
    }

    @Override
    protected void calcMinMax() {
        block2: {
            BarData barData = (BarData)this.getMData();
            if (barData == null) break block2;
            BarData barData2 = barData;
            boolean bl = false;
            if (this.mFitBars) {
                this.getMXAxis().calculate(barData2.getXMin() - barData2.getBarWidth() / 2.0f, barData2.getXMax() + barData2.getBarWidth() / 2.0f);
            } else {
                this.getMXAxis().calculate(barData2.getXMin(), barData2.getXMax());
            }
            this.getMAxisLeft().calculate(barData2.getYMin(YAxis.AxisDependency.LEFT), barData2.getYMax(YAxis.AxisDependency.LEFT));
            this.getMAxisRight().calculate(barData2.getYMin(YAxis.AxisDependency.RIGHT), barData2.getYMax(YAxis.AxisDependency.RIGHT));
        }
    }

    @Override
    @Nullable
    public Highlight getHighlightByTouchPoint(float x, float y) {
        if (this.getMData() == null) {
            Timber.Forest.e("Can't select by touch. No data set.", new Object[0]);
            return null;
        }
        IHighlighter iHighlighter = this.getHighlighter();
        if (iHighlighter != null) {
            IHighlighter it = iHighlighter;
            boolean bl = false;
            Highlight h = it.getHighlight(x, y);
            if (h == null || !this.isHighlightFullBarEnabled()) {
                return h;
            }
            return new Highlight(h.getX(), h.getY(), h.getXPx(), h.getYPx(), h.getDataSetIndex(), -1, h.getAxis());
        }
        return null;
    }

    @Override
    @NotNull
    public String getAccessibilityDescription() {
        BarData barData = this.getBarData();
        if (barData != null) {
            IAxisValueFormatter xAxisValueFormatter;
            IAxisValueFormatter yAxisValueFormatter;
            BarData barData2 = barData;
            boolean bl = false;
            int entryCount = barData2.getEntryCount();
            IAxisValueFormatter iAxisValueFormatter = yAxisValueFormatter = this.getAxisLeft().getValueFormatter();
            Intrinsics.checkNotNull((Object)iAxisValueFormatter);
            String minVal = iAxisValueFormatter.getFormattedValue(barData2.getYMin(), null);
            String maxVal = yAxisValueFormatter.getFormattedValue(barData2.getYMax(), null);
            IAxisValueFormatter iAxisValueFormatter2 = xAxisValueFormatter = this.getXAxis().getValueFormatter();
            Intrinsics.checkNotNull((Object)iAxisValueFormatter2);
            String minRange = iAxisValueFormatter2.getFormattedValue(barData2.getXMin(), null);
            String maxRange = xAxisValueFormatter.getFormattedValue(barData2.getXMax(), null);
            String entries = entryCount == 1 ? "entry" : "entries";
            Locale locale = Locale.getDefault();
            String string = "The bar chart has %d %s. The minimum value is %s and maximum value is %s.Data ranges from %s to %s.";
            Object[] objectArray = new Object[]{entryCount, entries, minVal, maxVal, minRange, maxRange};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }
        return "";
    }

    @NotNull
    public final RectF getBarBounds(@NotNull BarEntry barEntry) {
        Intrinsics.checkNotNullParameter((Object)barEntry, (String)"barEntry");
        RectF bounds = new RectF();
        this.getBarBounds(barEntry, bounds);
        return bounds;
    }

    public void getBarBounds(@NotNull BarEntry barEntry, @NotNull RectF outputRect) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)barEntry, (String)"barEntry");
            Intrinsics.checkNotNullParameter((Object)outputRect, (String)"outputRect");
            BarData barData = (BarData)this.getMData();
            if (barData == null) break block1;
            BarData barData2 = barData;
            boolean bl = false;
            IBarDataSet set = (IBarDataSet)barData2.getDataSetForEntry(barEntry);
            if (set == null) {
                outputRect.set(Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE);
                return;
            }
            float y = barEntry.getY();
            float x = barEntry.getX();
            float barWidth = barData2.getBarWidth();
            float left = x - barWidth / 2.0f;
            float right = x + barWidth / 2.0f;
            float top = y >= 0.0f ? y : 0.0f;
            float bottom = y <= 0.0f ? y : 0.0f;
            outputRect.set(left, top, right, bottom);
            this.getTransformer(set.getAxisDependency()).rectValueToPixel(outputRect);
        }
    }

    public final void setDrawValueAboveBar(boolean enabled) {
        this.setDrawValueAboveBarEnabled(enabled);
    }

    public final void setDrawBarShadow(boolean enabled) {
        this.setDrawBarShadowEnabled(enabled);
    }

    @Override
    public void getHighlightValue(float x, int dataSetIndex, int dataIndex) {
        this.highlightValue(new Highlight(x, dataSetIndex, dataIndex), false);
    }

    @Override
    @Nullable
    public BarData getBarData() {
        return (BarData)this.getMData();
    }

    public final void setFitBars(boolean enabled) {
        this.mFitBars = enabled;
    }

    public final void groupBars(float fromX, float groupSpace, float barSpace) {
        BarData barData = this.getBarData();
        if (barData != null) {
            barData.groupBars(fromX, groupSpace, barSpace);
        }
        this.notifyDataSetChanged();
    }

    public final void setRoundedBarRadius(float mRoundedBarRadius) {
        this.mRoundedBarRadius = mRoundedBarRadius;
        this.mDrawRoundedBars = true;
        this.init();
    }
}

