package info.appdev.charting.formatter

import info.appdev.charting.interfaces.dataprovider.LineDataProvider
import info.appdev.charting.interfaces.datasets.ILineDataSet

/**
 * Interface for providing a custom logic to where the filling line of a LineDataSet should end. This of course only works if setFillEnabled(...) is set to true.
 */
interface IFillFormatter {
    /**
     * Returns the vertical (y-axis) position where the filled-line of the
     * LineDataSet should end.
     *
     * @param dataSet the ILineDataSet that is currently drawn
     * @param dataProvider
     */
    fun getFillLinePosition(dataSet: ILineDataSet?, dataProvider: LineDataProvider): Float
}
